/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.text.ParseException;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.dltk.annotations.Nullable;
import org.eclipse.dltk.internal.javascript.ti.JSDocSupport;
import org.eclipse.dltk.internal.javascript.ti.TypeInferencer2;
import org.eclipse.dltk.javascript.typeinfo.IModelBuilder;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParser;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeParserExtension;
import org.eclipse.dltk.javascript.typeinfo.JSDocTypeRegion;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;

public class JSDocTypeUtil {
    private static JSDocTypeParser createTypeParser(TypeInferencer2 inferencer) {
        IModelBuilder[] iModelBuilderArray = inferencer.getModelBuilders();
        int n = iModelBuilderArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModelBuilder builder = iModelBuilderArray[n2];
            if (builder instanceof JSDocSupport) {
                return ((JSDocSupport)builder).createTypeParser();
            }
            ++n2;
        }
        return null;
    }

    @Nullable
    public static JSDocTypeRegion findTypeAt(TypeInferencer2 inferencer2, String typeExpression, final int offsetInTypeExpression) {
        JSDocTypeParser typeParser = JSDocTypeUtil.createTypeParser(inferencer2);
        if (typeParser == null) {
            return null;
        }
        final AtomicReference result = new AtomicReference();
        typeParser.setExtension(new JSDocTypeParserExtension(){

            public void reportType(JSType type, int s, int e) {
                if (s <= offsetInTypeExpression && offsetInTypeExpression < e && type instanceof SimpleType && result.get() == null) {
                    result.set(new JSDocTypeRegion(((SimpleType)type).getTarget().getName(), s, e));
                }
            }
        });
        try {
            typeParser.parse(typeExpression);
        }
        catch (ParseException parseException) {}
        return (JSDocTypeRegion)result.get();
    }
}

