/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.search;

import java.util.List;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.matching2.AbstractMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.IMatchingPredicate;
import org.eclipse.dltk.core.search.matching2.MatchLevel;
import org.eclipse.dltk.internal.core.search.matching.MethodDeclarationPattern;
import org.eclipse.dltk.internal.core.search.matching.MethodPattern;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.internal.search.FieldDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.FieldReferenceNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.LocalVariableReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MatchingNode;
import org.eclipse.dltk.javascript.internal.search.MemberReferenceNode;
import org.eclipse.dltk.javascript.internal.search.MethodDeclarationNode;
import org.eclipse.dltk.javascript.internal.search.MethodReferenceNode;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodPredicate
extends AbstractMatchingPredicate<MatchingNode> {
    private final boolean declarations;
    private final boolean references;
    private final ISourceModule module;
    private final int nameStart;
    private final int nameEnd;

    public MethodPredicate(MethodPattern pattern) {
        this((SearchPattern)pattern, pattern.selector, pattern.findDeclarations, pattern.findReferences);
    }

    public MethodPredicate(MethodDeclarationPattern pattern) {
        this((SearchPattern)pattern, pattern.simpleName, true, false);
    }

    private MethodPredicate(SearchPattern pattern, char[] pat, boolean declarations, boolean references) {
        super(pattern, pat);
        this.declarations = declarations;
        this.references = references;
        ISourceRange nameRange = null;
        if (pattern.focus instanceof IMember) {
            try {
                nameRange = ((IMember)pattern.focus).getNameRange();
            }
            catch (ModelException modelException) {}
        }
        if (nameRange != null) {
            this.nameStart = nameRange.getOffset();
            this.nameEnd = this.nameStart + nameRange.getLength();
            this.module = pattern.focus != null ? (ISourceModule)pattern.focus.getAncestor(5) : null;
        } else {
            this.nameStart = -1;
            this.nameEnd = -1;
            this.module = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatchLevel match(MatchingNode node) {
        if (node instanceof MethodDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            MethodDeclarationNode mNode = (MethodDeclarationNode)node;
            if (this.nameStart == -1 || this.nameEnd == -1 || mNode.method == null) return this.matchName(mNode.getName());
            if (this.nameStart != mNode.sourceStart() || this.nameEnd != mNode.sourceEnd() || !this.isSame(mNode.method.getLocation().getSourceModule())) return null;
            return this.matchName(mNode.getName());
        }
        if (node instanceof FieldDeclarationNode) {
            if (!this.declarations) {
                return null;
            }
            FieldDeclarationNode fNode = (FieldDeclarationNode)node;
            if (this.nameStart == -1 || this.nameEnd == -1) return this.matchName(fNode.getName());
            if (this.nameStart != fNode.sourceStart() || this.nameEnd != fNode.sourceEnd() || !this.isSame(fNode.module)) return null;
            return this.matchName(fNode.getName());
        }
        if (node instanceof MethodReferenceNode) {
            if (!this.references) {
                return null;
            }
            MethodReferenceNode mNode = (MethodReferenceNode)node;
            if (this.nameStart == -1 || this.nameEnd == -1) return this.matchName(((Identifier)mNode.node).getName(), MatchLevel.INACCURATE_MATCH);
            ReferenceLocation location = mNode.location;
            if (location == null) return this.matchName(((Identifier)mNode.node).getName());
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)mNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (node instanceof FieldReferenceNode) {
            if (!this.references) {
                return null;
            }
            FieldReferenceNode mNode = (FieldReferenceNode)node;
            if (this.nameStart == -1 || this.nameEnd == -1) return this.matchName(((Identifier)mNode.node).getName(), MatchLevel.INACCURATE_MATCH);
            ReferenceLocation location = mNode.location;
            if (location == null) return this.matchName(((Identifier)mNode.node).getName());
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)mNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (node instanceof LocalVariableReferenceNode) {
            if (!this.references) {
                return null;
            }
            LocalVariableReferenceNode varNode = (LocalVariableReferenceNode)node;
            if (this.nameStart == -1 || this.nameEnd == -1) return this.matchName(((Identifier)varNode.node).getName(), MatchLevel.INACCURATE_MATCH);
            ReferenceLocation location = varNode.declarationLoc;
            if (location == null) return this.matchName(((Identifier)varNode.node).getName());
            if (location.getNameStart() != this.nameStart || location.getNameEnd() != this.nameEnd || !this.isSame(location.getSourceModule())) return null;
            return this.matchName(((Identifier)varNode.node).getName(), MatchLevel.ACCURATE_MATCH);
        }
        if (!(node instanceof LocalVariableDeclarationNode)) return null;
        if (!this.declarations) {
            return null;
        }
        LocalVariableDeclarationNode varNode = (LocalVariableDeclarationNode)node;
        if (((Identifier)varNode.node).sourceStart() != this.nameStart || ((Identifier)varNode.node).sourceEnd() != this.nameEnd || !this.isSame(varNode.module)) return null;
        return this.matchName(((Identifier)varNode.node).getName(), MatchLevel.ACCURATE_MATCH);
    }

    public MatchLevel resolvePotentialMatch(MatchingNode node) {
        if (this.nameStart != -1 && this.nameEnd != -1) {
            Expression exp;
            if (node instanceof MemberReferenceNode) {
                MemberReferenceNode mNode = (MemberReferenceNode)node;
                ReferenceLocation location = mNode.location;
                return location != null && location.getNameStart() == this.nameStart && location.getNameEnd() == this.nameEnd && this.isSame(location.getSourceModule()) ? MatchLevel.ACCURATE_MATCH : null;
            }
            if (node instanceof MethodDeclarationNode && (exp = (Expression)((MethodDeclarationNode)node).node) != null && exp.sourceStart() == this.nameStart && exp.sourceEnd() == this.nameEnd && this.isSame(((MethodDeclarationNode)node).method.getLocation().getSourceModule())) {
                return MatchLevel.ACCURATE_MATCH;
            }
        }
        return super.resolvePotentialMatch((Object)node);
    }

    private boolean isSame(ISourceModule module) {
        return module != null && module.equals(this.module);
    }

    protected void collectToStringOptions(List<String> options) {
        super.collectToStringOptions(options);
        if (this.declarations) {
            options.add("declarations");
        }
        if (this.references) {
            options.add("references");
        }
    }

    public boolean contains(IMatchingPredicate<MatchingNode> predicate) {
        if (predicate instanceof MethodPredicate) {
            MethodPredicate other = (MethodPredicate)predicate;
            if (CharOperation.equals((char[])this.namePattern, (char[])other.namePattern) && this.module != null && this.module.equals(other.module) && this.nameStart == other.nameStart && this.nameEnd == other.nameEnd && (this.references || this.references == other.references) && (this.declarations || this.declarations == other.declarations)) {
                return true;
            }
        }
        return super.contains(predicate);
    }
}

