/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.ProblemSeverity;
import org.eclipse.dltk.core.builder.IBuildContext;
import org.eclipse.dltk.core.builder.IBuildParticipant;
import org.eclipse.dltk.internal.javascript.validation.JavaScriptValidations;
import org.eclipse.dltk.javascript.ast.AbstractNavigationVisitor;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.Keywords;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.LoopStatement;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.parser.Reporter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CodeValidation
extends AbstractNavigationVisitor<Object>
implements IBuildParticipant {
    private Reporter reporter;
    private Scope scope;

    public void build(IBuildContext context) throws CoreException {
        Script script = JavaScriptValidations.parse(context);
        if (script == null) {
            return;
        }
        this.reporter = JavaScriptValidations.createReporter(context);
        this.scope = new Scope();
        this.visit((ASTNode)script);
    }

    public Object visitFunctionStatement(FunctionStatement node) {
        Scope savedScope = this.scope;
        this.scope = new Scope();
        Object result = super.visitFunctionStatement(node);
        this.scope = savedScope;
        return result;
    }

    public Object visitLabelledStatement(LabelledStatement node) {
        boolean added = this.scope.addLabel(node);
        Object result = super.visitLabelledStatement(node);
        if (added) {
            this.scope.removeLabel(node);
        }
        return result;
    }

    public Object visitBreakStatement(BreakStatement node) {
        if (node.getLabel() != null) {
            this.validateLabel(node.getLabel(), node.sourceStart(), 7);
        }
        return super.visitBreakStatement(node);
    }

    public Object visitContinueStatement(ContinueStatement node) {
        if (node.getLabel() != null) {
            this.validateLabel(node.getLabel(), node.sourceStart(), 10);
        }
        return super.visitContinueStatement(node);
    }

    private void validateLabel(Label label, int statementStart, int token) {
        LabelInfo info = this.scope.getLabel(label.getText());
        if (info == null) {
            return;
        }
        if (info.finished) {
            this.reporter.setMessage((IProblemIdentifier)(token == 7 ? JavaScriptProblems.BREAK_OUTSIDE_LABEL : JavaScriptProblems.CONTINUE_OUTSIDE_LABEL), String.valueOf(Keywords.fromToken((int)token)) + " outside of labelled statement");
            this.reporter.setSeverity(ProblemSeverity.ERROR);
            this.reporter.setRange(statementStart, label.sourceEnd());
            this.reporter.report();
            return;
        }
        if (!info.finished && info.statement.getStatement() instanceof LoopStatement) {
            return;
        }
        if (token == 7) {
            return;
        }
        this.reporter.setMessage((IProblemIdentifier)JavaScriptProblems.CONTINUE_NON_LOOP_LABEL, "continue can only use labels of iteration statements");
        this.reporter.setSeverity(ProblemSeverity.ERROR);
        this.reporter.setRange(statementStart, label.sourceEnd());
        this.reporter.report();
    }

    protected void visitCondition(Expression condition) {
        BinaryOperation operation;
        super.visitCondition(condition);
        if (condition instanceof BinaryOperation && (operation = (BinaryOperation)condition).getOperation() == 104) {
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.EQUAL_AS_ASSIGN, "Test for equality (==) mistyped as assignment (=)?", condition.sourceStart(), condition.sourceEnd());
        }
    }

    public Object visitBinaryOperation(BinaryOperation node) {
        if (node.getOperation() == 104 && !this.canAssignTo(node.getLeftExpression())) {
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INVALID_ASSIGN_LEFT, "Invalid assignment left-hand side.", node.sourceStart(), node.sourceEnd());
        }
        return super.visitBinaryOperation(node);
    }

    public Object visitUnaryOperation(UnaryOperation node) {
        if (this.isIncDec(node.getOperation()) && !this.canAssignTo(node.getExpression())) {
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.INVALID_ASSIGN_LEFT, "Invalid assignment left-hand side.", node.sourceStart(), node.sourceEnd());
        }
        return super.visitUnaryOperation(node);
    }

    private boolean isIncDec(int operation) {
        return operation == 90 || operation == 91 || operation == 147 || operation == 146;
    }

    private boolean canAssignTo(Expression expression) {
        return expression instanceof Identifier || expression instanceof PropertyExpression || expression instanceof GetArrayItemExpression;
    }

    public Object visitObjectInitializer(ObjectInitializer node) {
        HashSet<String> processed = new HashSet<String>();
        for (ObjectInitializerPart part : node.getInitializers()) {
            PropertyInitializer property;
            String propertyName;
            if (!(part instanceof PropertyInitializer) || (propertyName = (property = (PropertyInitializer)part).getNameAsString()) == null || processed.add(propertyName)) continue;
            this.reporter.reportProblem((IProblemIdentifier)JavaScriptProblems.DUPLICATE_PROPERTY_IN_LITERAL, NLS.bind((String)"Duplicate property {0} in object literal", (Object)propertyName), property.getName().sourceStart(), property.getName().sourceEnd());
        }
        return super.visitObjectInitializer(node);
    }

    static class LabelInfo {
        final LabelledStatement statement;
        boolean finished;

        public LabelInfo(LabelledStatement statement) {
            this.statement = statement;
        }
    }

    static class Scope {
        private final Map<String, LabelInfo> labels = new HashMap<String, LabelInfo>();

        Scope() {
        }

        public boolean addLabel(LabelledStatement statement) {
            String label = statement.getLabel().getText();
            if (this.labels.containsKey(label)) {
                return false;
            }
            this.labels.put(label, new LabelInfo(statement));
            return true;
        }

        public LabelInfo getLabel(String label) {
            return this.labels.get(label);
        }

        public void removeLabel(LabelledStatement statement) {
            LabelInfo info = this.labels.get(statement.getLabel().getText());
            if (info != null) {
                info.finished = true;
            }
        }
    }
}

