/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.ti;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.internal.javascript.ti.FunctionMethod;
import org.eclipse.dltk.internal.javascript.ti.FunctionTypeMethodValue;
import org.eclipse.dltk.internal.javascript.ti.IValue;
import org.eclipse.dltk.internal.javascript.ti.IValueProvider;
import org.eclipse.dltk.internal.javascript.ti.PhantomValue;
import org.eclipse.dltk.internal.javascript.ti.TypeSystemImpl;
import org.eclipse.dltk.internal.javascript.ti.Value;
import org.eclipse.dltk.internal.javascript.validation.ValidationMessages;
import org.eclipse.dltk.javascript.core.JavaScriptProblems;
import org.eclipse.dltk.javascript.typeinference.IAssignProtection;
import org.eclipse.dltk.javascript.typeinference.ILocationProvider;
import org.eclipse.dltk.javascript.typeinference.IValueCollection;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceKind;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.javascript.typeinfo.IMemberEvaluator;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRElement;
import org.eclipse.dltk.javascript.typeinfo.IRFunctionType;
import org.eclipse.dltk.javascript.typeinfo.IRLocalType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRMember;
import org.eclipse.dltk.javascript.typeinfo.IRMethod;
import org.eclipse.dltk.javascript.typeinfo.IRProperty;
import org.eclipse.dltk.javascript.typeinfo.IRRecordMember;
import org.eclipse.dltk.javascript.typeinfo.IRRecordType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRTypeDeclaration;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicate;
import org.eclipse.dltk.javascript.typeinfo.MemberPredicates;
import org.eclipse.dltk.javascript.typeinfo.RSimpleType;
import org.eclipse.dltk.javascript.typeinfo.RTypeMemberQuery;
import org.eclipse.dltk.javascript.typeinfo.RTypes;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.TypeUtil;
import org.eclipse.dltk.javascript.typeinfo.model.Element;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ElementValue
implements IValue {
    public static final IAssignProtection READONLY_PROPERTY = new IAssignProtection(){

        public IProblemIdentifier problemId() {
            return JavaScriptProblems.PROPERTY_READONLY;
        }

        public String problemMessage() {
            return ValidationMessages.AssignmentToReadonlyProperty;
        }
    };
    static final IAssignProtection UNASSIGNABLE_METHOD = new IAssignProtection(){

        public IProblemIdentifier problemId() {
            return JavaScriptProblems.UNASSIGNABLE_ELEMENT;
        }

        public String problemMessage() {
            return ValidationMessages.UnassignableMethod;
        }
    };
    static final IAssignProtection UNASSIGNABLE_CLASS = new IAssignProtection(){

        public IProblemIdentifier problemId() {
            return JavaScriptProblems.UNASSIGNABLE_ELEMENT;
        }

        public String problemMessage() {
            return ValidationMessages.UnassignableClass;
        }
    };

    public static IValue findMember(IRType type, String name) {
        return ElementValue.findMember(type, name, MemberPredicates.ALWAYS_TRUE);
    }

    static IValue findMemberA(IRType type, String name, boolean resolve) {
        Type target;
        MemberPredicate predicate = type instanceof IRClassType ? ((target = ((IRClassType)type).getTarget()) != null ? target.memberPredicateFor(type, MemberPredicates.STATIC) : MemberPredicates.STATIC) : (type instanceof IRSimpleType ? ((target = ((IRSimpleType)type).getTarget()) != null ? target.memberPredicateFor(type, MemberPredicates.NON_STATIC) : MemberPredicates.NON_STATIC) : (type instanceof IRUnionType ? MemberPredicates.ALWAYS_TRUE : MemberPredicates.NON_STATIC));
        return ElementValue.findMember(type, name, predicate, resolve);
    }

    public static IValue findMember(IRType type, String name, MemberPredicate predicate) {
        return ElementValue.findMember(type, name, predicate, true);
    }

    public static IValue findMember(IRType type, String name, MemberPredicate predicate, boolean resolve) {
        IRTypeDeclaration t;
        IRType arrayType;
        if ("[]".equals(name) && (arrayType = TypeUtil.extractArrayItemType(type)) != null && TypeUtil.kind(arrayType) != TypeKind.UNKNOWN && arrayType != RTypes.none() && arrayType != RTypes.arrayOf().getItemType()) {
            return new TypeValue(arrayType);
        }
        if (type instanceof IRClassType) {
            List<IRMember> selection;
            t = ((IRClassType)type).getDeclaration();
            if (t != null && !(selection = ElementValue.findMembers(t, name, predicate)).isEmpty()) {
                if (selection.size() == 1) {
                    return ElementValue.createElement(t.getTypeSystem(), t, selection.get(0));
                }
                return new MemberValue(selection.toArray(new IRMember[selection.size()]));
            }
            if ((t == null || t.getSource().hasPrototype()) && predicate.isCompatibleWith(MemberPredicates.STATIC) && !(selection = ElementValue.findMembers(t != null ? t.getTypeSystem().convert(t.getSource().getPrototypeType()) : RTypes.FUNCTION.getDeclaration(), name, MemberPredicates.NON_STATIC)).isEmpty()) {
                if (selection.size() == 1) {
                    IRMember selected = selection.get(0);
                    if ("prototype".equals(selected.getName()) && selected instanceof IRProperty) {
                        if (t != null) {
                            return new PrototypePropertyValue((IRProperty)selected, new PrototypeType(t));
                        }
                        return new PrototypePropertyValue((IRProperty)selected, new PrototypeType(RTypes.OBJECT.getDeclaration()));
                    }
                    return ElementValue.createElement(selected);
                }
                return new MemberValue(selection.toArray(new IRMember[selection.size()]));
            }
        } else if (type instanceof IRUnionType) {
            for (IRType unionTarget : ((IRUnionType)type).getTargets()) {
                IValue member = ElementValue.findMember(unionTarget, name, predicate, resolve);
                if (member == null) continue;
                return member;
            }
        } else {
            if (type instanceof IRRecordType) {
                IRRecordMember member = ((IRRecordType)type).getMember(name);
                if (member != null) {
                    return new RTypeValue(member.getType(), member);
                }
                return ElementValue.findMember(RTypes.OBJECT, name);
            }
            if (type instanceof IRFunctionType) {
                IRFunctionType functionType = (IRFunctionType)type;
                if (FunctionMethod.apply.test(name)) {
                    return ElementValue.getFunctionMethod(functionType.getTypeSystem(), functionType, FunctionMethod.apply);
                }
                if (FunctionMethod.call.test(name)) {
                    return ElementValue.getFunctionMethod(functionType.getTypeSystem(), functionType, FunctionMethod.call);
                }
                List<IRMember> selection = ElementValue.findMembers(RTypes.FUNCTION.getDeclaration(), name, predicate);
                if (!selection.isEmpty()) {
                    if (selection.size() == 1) {
                        return ElementValue.createElement(selection.get(0));
                    }
                    return new MemberValue(selection.toArray(new IRMember[selection.size()]));
                }
            } else {
                if (type instanceof IRLocalType) {
                    IValue value;
                    IValueReference child = ((IRLocalType)type).getDirectChild(name);
                    if (child != null && (value = ((IValueProvider)((Object)child)).getValue()) != null) {
                        return value;
                    }
                    return ElementValue.findMember(RTypes.OBJECT, name);
                }
                if (type instanceof IRSimpleType) {
                    t = ((IRSimpleType)type).getDeclaration();
                    if (t != null) {
                        List<IRMember> selection = ElementValue.findMembers(t, name, predicate);
                        if (!selection.isEmpty()) {
                            if (selection.size() == 1) {
                                return ElementValue.createElement(t.getTypeSystem(), t, selection.get(0));
                            }
                            return new MemberValue(selection.toArray(new IRMember[selection.size()]));
                        }
                        if (resolve && t.getTypeSystem() instanceof ITypeInfoContext) {
                            Type target = ((IRSimpleType)type).getTarget();
                            IMemberEvaluator[] iMemberEvaluatorArray = TypeInfoManager.getMemberEvaluators();
                            int n = iMemberEvaluatorArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IValueReference child;
                                IMemberEvaluator evaluator = iMemberEvaluatorArray[n2];
                                IValueCollection collection = evaluator.valueOf((ITypeInfoContext)t.getTypeSystem(), target);
                                if (collection != null && collection instanceof IValueProvider && (child = collection.getChild(name)) instanceof IValueProvider) {
                                    return ((IValueProvider)((Object)child)).getValue();
                                }
                                ++n2;
                            }
                        }
                    }
                } else if (type instanceof IRMapType) {
                    List<IRMember> selection = ElementValue.findMembers(RTypes.OBJECT.getDeclaration(), name, predicate);
                    if (!selection.isEmpty()) {
                        if (selection.size() == 1) {
                            return ElementValue.createElement(selection.get(0));
                        }
                        return new MemberValue(selection.toArray(new IRMember[selection.size()]));
                    }
                    if (!"[]".equals(name) && !"()".equals(name)) {
                        return new RTypeValue(((IRMapType)type).getValueType(), null);
                    }
                } else if (type == RTypes.any() && !"[]".equals(name) && !"()".equals(name)) {
                    return PhantomValue.VALUE;
                }
            }
        }
        return null;
    }

    private static ElementValue getFunctionMethod(ITypeSystem context, IRFunctionType type, FunctionMethod method) {
        if (context != null) {
            FunctionMethodKey key = new FunctionMethodKey(type, method);
            ElementValue value = (ElementValue)context.getValue(key);
            if (value == null) {
                value = new FunctionTypeMethodValue(type, method);
                context.setValue(key, value);
            }
            return value;
        }
        return new FunctionTypeMethodValue(type, method);
    }

    private static ElementValue createElement(IRMember member) {
        if (member instanceof IRProperty) {
            return new PropertyValue((IRProperty)member);
        }
        if (member instanceof IRMethod) {
            return new MethodValue((IRMethod)member);
        }
        throw new IllegalArgumentException("Unsupported IRMember of type " + member.getClass());
    }

    private static ElementValue createElement(ITypeSystem context, IRTypeDeclaration type, IRMember member) {
        if (member instanceof IRProperty) {
            if (TypeSystemImpl.isContextualizable(member.getType())) {
                return new PropertyValue(context.contextualize((IRProperty)member, type));
            }
            return new PropertyValue((IRProperty)member);
        }
        if (member instanceof IRMethod) {
            if (TypeSystemImpl.isContextualizable(member.getType())) {
                return new MethodValue(context.contextualize((IRMethod)member, type));
            }
            return new MethodValue((IRMethod)member);
        }
        return null;
    }

    public static List<IRMember> findMembers(IRTypeDeclaration type, String name, MemberPredicate predicate) {
        ArrayList<IRMember> selection = new ArrayList<IRMember>(4);
        for (IRMember member : new RTypeMemberQuery(type, predicate).ignoreDuplicates()) {
            if (!name.equals(member.getName())) continue;
            selection.add(member);
        }
        return selection;
    }

    public static ElementValue createFor(IRElement element) {
        if (element instanceof IRMethod) {
            return new MethodValue((IRMethod)element);
        }
        if (element instanceof IRProperty) {
            return new PropertyValue((IRProperty)element);
        }
        IRTypeDeclaration type = (IRTypeDeclaration)element;
        return new TypeValue(RTypes.simple(type));
    }

    public static ElementValue createClass(ITypeSystem context, Type type) {
        return new ClassValue(JSTypeSet.singleton(RTypes.classType(context, type)));
    }

    protected abstract Object getElements();

    public IValue resolveValue() {
        return this;
    }

    IValue resolveValue(IRMember member) {
        IRTypeDeclaration type = member.getDeclaringType();
        ITypeSystem typeSystem = type != null ? type.getTypeSystem() : ITypeSystem.CURRENT.get();
        return typeSystem != null ? typeSystem.valueOf(member) : null;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final void addValue(IValue src) {
    }

    @Override
    public final void addReference(IValue src) {
    }

    @Override
    public void removeReference(IValue value) {
    }

    @Override
    public final Object getAttribute(String key) {
        return this.getAttribute(key, false);
    }

    @Override
    public Object getAttribute(String key, boolean includeReferences) {
        Object source;
        Object elements;
        if ("ELEMENT".equals(key)) {
            return this.getElements();
        }
        if ("HIDE_ALLOWED".equals(key) && (elements = this.getElements()) instanceof IRElement && (source = ((IRElement)elements).getSource()) instanceof Element && ((Element)source).isHideAllowed()) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public final void setAttribute(String key, Object value) {
    }

    public final Set<String> getDirectChildren() {
        return this.getDirectChildren(0);
    }

    @Override
    public Set<String> getDirectChildren(int flags) {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getDeletedChildren() {
        return Collections.emptySet();
    }

    @Override
    public void deleteChild(String name, boolean force) {
    }

    @Override
    public final boolean hasChild(String name) {
        return false;
    }

    @Override
    public final IValue createChild(String name, int flags) {
        return this.getChild(name, true);
    }

    @Override
    public void putChild(String name, IValue value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ReferenceKind getKind() {
        return ReferenceKind.UNKNOWN;
    }

    @Override
    public ReferenceLocation getLocation() {
        return ReferenceLocation.UNKNOWN;
    }

    @Override
    public JSTypeSet getTypes() {
        return JSTypeSet.emptySet();
    }

    @Override
    public final void setDeclaredType(IRType declaredType) {
    }

    @Override
    public void addType(IRType type) {
    }

    @Override
    public final void setKind(ReferenceKind kind) {
    }

    @Override
    public final void setLocation(ReferenceLocation location) {
    }

    private static class ClassValue
    extends ElementValue
    implements IValue {
        private final JSTypeSet types;

        public ClassValue(JSTypeSet types) {
            this.types = types;
        }

        protected Type[] getElements() {
            return this.types.toArray();
        }

        public IValue getChild(String name, boolean resolve) {
            if (name.equals("()")) {
                IRType type;
                if (this.types.size() == 1 && (type = this.types.toRType()) instanceof IRClassType) {
                    return new TypeValue(((IRClassType)type).newItemType());
                }
                JSTypeSet returnTypes = JSTypeSet.create();
                for (IRType type2 : this.types) {
                    if (type2 instanceof IRClassType) {
                        returnTypes.add(((IRClassType)type2).newItemType());
                        continue;
                    }
                    returnTypes.add(type2);
                }
                return new TypeValue(returnTypes);
            }
            for (IRType type : this.types) {
                IValue child = ClassValue.findMember(type, name, MemberPredicates.STATIC);
                if (child == null) continue;
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            return this.types.toRType();
        }

        public JSTypeSet getDeclaredTypes() {
            return this.types;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.TYPE;
        }

        public Object getAttribute(String key, boolean includeReferences) {
            if (IAssignProtection.ATTRIBUTE.equals(key)) {
                return UNASSIGNABLE_CLASS;
            }
            return super.getAttribute(key, includeReferences);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + this.types;
        }
    }

    private static class FunctionMethodKey {
        private final IRFunctionType type;
        private final FunctionMethod method;

        public FunctionMethodKey(IRFunctionType type, FunctionMethod method) {
            this.type = type;
            this.method = method;
        }

        public int hashCode() {
            return this.type.hashCode() ^ this.method.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FunctionMethodKey) {
                FunctionMethodKey other = (FunctionMethodKey)obj;
                return this.type.equals(other.type) && this.method == other.method;
            }
            return false;
        }
    }

    private static class MemberValue
    extends ElementValue
    implements IValue {
        private TypeValue functionOperator;
        private final IRMember[] members;

        public MemberValue(IRMember[] members) {
            assert (members.length > 1);
            this.members = members;
        }

        protected IRMember[] getElements() {
            return this.members;
        }

        public ReferenceKind getKind() {
            IRMember[] iRMemberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                IRMember member = iRMemberArray[n2];
                if (member instanceof IRMethod) {
                    return ReferenceKind.METHOD;
                }
                ++n2;
            }
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            IValue child;
            IRType type;
            if ("()".equals(name)) {
                JSTypeSet types = null;
                IRMember[] iRMemberArray = this.members;
                int n = this.members.length;
                int n2 = 0;
                while (n2 < n) {
                    IRMethod method;
                    IRMember member = iRMemberArray[n2];
                    if (member instanceof IRMethod && (method = (IRMethod)member).getType() != null) {
                        if (types == null) {
                            types = JSTypeSet.create();
                        }
                        types.add(method.getType());
                    }
                    ++n2;
                }
                if (types != null) {
                    if (this.functionOperator == null) {
                        this.functionOperator = new TypeValue(types);
                    }
                    return this.functionOperator;
                }
            }
            if ((type = this.getDeclaredType()) != null && (child = ElementValue.findMemberA(type, name, resolve)) != null) {
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            IRMember[] iRMemberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                IRMember member = iRMemberArray[n2];
                if (member instanceof IRProperty) {
                    IRProperty property = (IRProperty)member;
                    if (property.getType() != null) {
                        return property.getType();
                    }
                } else if (member instanceof IRMethod) {
                    return RTypes.FUNCTION;
                }
                ++n2;
            }
            return null;
        }

        public JSTypeSet getDeclaredTypes() {
            JSTypeSet types = null;
            IRMember[] iRMemberArray = this.members;
            int n = this.members.length;
            int n2 = 0;
            while (n2 < n) {
                IRMember member = iRMemberArray[n2];
                if (member instanceof IRProperty) {
                    IRProperty property = (IRProperty)member;
                    if (property.getType() != null) {
                        if (types == null) {
                            types = JSTypeSet.create();
                        }
                        types.add(property.getType());
                    }
                } else if (member instanceof IRMethod) {
                    if (types == null) {
                        types = JSTypeSet.create();
                    }
                    types.add(RTypes.FUNCTION);
                }
                ++n2;
            }
            if (types != null) {
                return types;
            }
            return JSTypeSet.emptySet();
        }

        public Object getAttribute(String key, boolean includeReferences) {
            if (IAssignProtection.ATTRIBUTE.equals(key)) {
                IRMember[] iRMemberArray = this.members;
                int n = this.members.length;
                int n2 = 0;
                while (n2 < n) {
                    IRMember member = iRMemberArray[n2];
                    if (member instanceof IRProperty) {
                        if (((IRProperty)member).isReadOnly()) {
                            return READONLY_PROPERTY;
                        }
                    } else if (member instanceof IRMethod && member.getDeclaringType() == null) {
                        return UNASSIGNABLE_METHOD;
                    }
                    ++n2;
                }
                return null;
            }
            return super.getAttribute(key, includeReferences);
        }
    }

    private static class MethodValue
    extends ElementValue
    implements IValue {
        private TypeValue functionOperator;
        private final IRMethod method;

        public MethodValue(IRMethod method) {
            this.method = method;
        }

        protected IRMethod getElements() {
            return this.method;
        }

        public IValue resolveValue() {
            IValue value = this.resolveValue(this.method);
            if (value != null) {
                return value;
            }
            return this;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.METHOD;
        }

        public IValue getChild(String name, boolean resolve) {
            if ("()".equals(name) && this.method.getType() != null) {
                if (this.functionOperator == null) {
                    this.functionOperator = new TypeValue(JSTypeSet.singleton(this.method.getType()));
                }
                return this.functionOperator;
            }
            IValue child = ElementValue.findMemberA(this.getDeclaredType(), name, resolve);
            if (child != null) {
                return child;
            }
            return null;
        }

        public IRType getDeclaredType() {
            return RTypes.FUNCTION;
        }

        public JSTypeSet getDeclaredTypes() {
            return JSTypeSet.singleton(this.getDeclaredType());
        }

        public Object getAttribute(String key, boolean includeReferences) {
            if (IAssignProtection.ATTRIBUTE.equals(key) && this.method.getDeclaringType() == null) {
                return UNASSIGNABLE_METHOD;
            }
            return super.getAttribute(key, includeReferences);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.method + '>';
        }
    }

    private static class PropertyValue
    extends ElementValue
    implements IValue {
        private final IRProperty property;
        private final Map<String, IValue> children = new HashMap<String, IValue>(4, 0.9f);
        private JSTypeSet declaredTypes = null;

        public PropertyValue(IRProperty property) {
            this.property = property;
        }

        protected IRProperty getElements() {
            return this.property;
        }

        public IValue resolveValue() {
            IValue value = this.resolveValue(this.property);
            if (value != null) {
                return value;
            }
            return this;
        }

        public ReferenceKind getKind() {
            return ReferenceKind.PROPERTY;
        }

        public IValue getChild(String name, boolean resolve) {
            IValue child = this.children.get(name);
            if (child == null) {
                IRType propType;
                if ("[]".equals(name) && this.property.getType() != null) {
                    IRType arrayType = null;
                    if (this.property.getType() instanceof IRArrayType) {
                        arrayType = ((IRArrayType)this.property.getType()).getItemType();
                    } else if (this.property.getType() instanceof IRMapType) {
                        arrayType = ((IRMapType)this.property.getType()).getValueType();
                    }
                    if (arrayType != null) {
                        child = new TypeValue(arrayType);
                        this.children.put(name, child);
                        return child;
                    }
                }
                if ((child = ElementValue.findMemberA(propType = this.getDeclaredType(), name, resolve)) instanceof ElementValue) {
                    child = ((ElementValue)child).resolveValue();
                    this.children.put(name, child);
                }
            }
            return child;
        }

        public IRType getDeclaredType() {
            return this.property.getType();
        }

        public JSTypeSet getDeclaredTypes() {
            if (this.declaredTypes == null) {
                IRType type = this.getDeclaredType();
                this.declaredTypes = type != null ? JSTypeSet.singleton(type) : JSTypeSet.emptySet();
            }
            return this.declaredTypes;
        }

        public Object getAttribute(String key, boolean includeReferences) {
            if (IAssignProtection.ATTRIBUTE.equals(key)) {
                IRTypeDeclaration declaringType = this.property.getDeclaringType();
                if (declaringType != null) {
                    return declaringType.getReadOnlyStatus(this.property);
                }
                return this.property.isReadOnly() ? READONLY_PROPERTY : null;
            }
            return super.getAttribute(key, includeReferences);
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.property + '>';
        }
    }

    private static class PrototypePropertyValue
    extends PropertyValue {
        private final IRType valueType;

        public PrototypePropertyValue(IRProperty property, IRType valueType) {
            super(property);
            this.valueType = valueType;
        }

        public IRType getDeclaredType() {
            return this.valueType;
        }
    }

    private static class PrototypeType
    extends RSimpleType {
        public PrototypeType(IRTypeDeclaration declaration) {
            super(declaration);
        }

        public String getName() {
            return "prototype<" + this.getTarget().getName() + ">";
        }

        public boolean isExtensible() {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RTypeValue
    extends ElementValue
    implements IValue {
        private final IRType type;
        private final Map<String, IValue> children = new HashMap<String, IValue>();
        private final IRMember element;

        public RTypeValue(IRType type, IRMember element) {
            this.type = type;
            this.element = element;
        }

        @Override
        protected IRMember getElements() {
            return this.element;
        }

        @Override
        public ReferenceKind getKind() {
            return ReferenceKind.PROPERTY;
        }

        @Override
        public IValue getChild(String name, boolean resolve) {
            IValue child = this.children.get(name);
            if (child == null) {
                if ("[]".equals(name)) {
                    IRType arrayType = null;
                    if (this.type instanceof IRArrayType) {
                        arrayType = ((IRArrayType)this.type).getItemType();
                    } else if (this.type instanceof IRMapType) {
                        arrayType = ((IRMapType)this.type).getValueType();
                    }
                    if (arrayType != null) {
                        TypeValue arrayOpChild = new TypeValue(arrayType);
                        this.children.put(name, arrayOpChild);
                        return arrayOpChild;
                    }
                } else if ("()".equals(name) && this.type instanceof IRFunctionType) {
                    child = new Value();
                    child.addType(((IRFunctionType)this.type).getReturnType());
                    this.children.put(name, child);
                    return child;
                }
                if ((child = ElementValue.findMemberA(this.type, name, resolve)) instanceof ElementValue) {
                    child = ((ElementValue)child).resolveValue();
                    this.children.put(name, child);
                }
            }
            return child;
        }

        @Override
        public final Set<String> getDirectChildren(int flags) {
            if ((flags & 2) == 0) {
                HashSet<String> set = new HashSet<String>();
                IRType irType = this.getDeclaredType();
                if (irType instanceof IRLocalType) {
                    set.addAll(((IRLocalType)irType).getDirectChildren());
                }
                return set;
            }
            return Collections.emptySet();
        }

        @Override
        public IRType getDeclaredType() {
            return this.type;
        }

        @Override
        public JSTypeSet getDeclaredTypes() {
            if (this.type != null) {
                return JSTypeSet.singleton(this.type);
            }
            return JSTypeSet.emptySet();
        }

        @Override
        public ReferenceLocation getLocation() {
            if (this.element != null && this.element.getSource() instanceof ILocationProvider) {
                return ((ILocationProvider)this.element.getSource()).getLocation();
            }
            return super.getLocation();
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + '<' + this.type + '>';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TypeValue
    extends ElementValue
    implements IValue {
        private final Map<String, IValue> children = new HashMap<String, IValue>(4, 0.9f);
        private final JSTypeSet types;

        public TypeValue(IRType type) {
            this.types = JSTypeSet.singleton(type);
        }

        public TypeValue(JSTypeSet types) {
            this.types = types;
        }

        @Override
        public final Set<String> getDirectChildren(int flags) {
            if ((flags & 2) == 0) {
                HashSet<String> set = new HashSet<String>();
                for (IRType irType : this.getTypes()) {
                    if (!(irType instanceof IRLocalType)) continue;
                    set.addAll(((IRLocalType)irType).getDirectChildren());
                }
                return set;
            }
            return Collections.emptySet();
        }

        protected Type[] getElements() {
            return this.types.toArray();
        }

        @Override
        public IValue getChild(String name, boolean resolve) {
            IValue value = this.children.get(name);
            if (value == null) {
                for (IRType type : this.types) {
                    value = TypeValue.findMemberA(type, name, resolve);
                    if (value == null) continue;
                    if (!(value instanceof ElementValue)) break;
                    value = ((ElementValue)value).resolveValue();
                    break;
                }
                if (value == null && name.equals("[]")) {
                    value = new Value();
                }
                if (value != null) {
                    this.children.put(name, value);
                }
            }
            return value;
        }

        @Override
        public IRType getDeclaredType() {
            return this.types.toRType();
        }

        @Override
        public JSTypeSet getDeclaredTypes() {
            return this.types;
        }

        @Override
        public final JSTypeSet getTypes() {
            return this.types;
        }

        public String toString() {
            return String.valueOf(this.getClass().getSimpleName()) + this.types;
        }
    }
}

