/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.corext.refactoring.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.internal.javascript.corext.refactoring.util.Selection;
import org.eclipse.dltk.javascript.core.dom.Expression;
import org.eclipse.dltk.javascript.core.dom.Node;
import org.eclipse.dltk.javascript.core.dom.util.DomSwitch;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectionAnalyzer
extends DomSwitch<Boolean> {
    private Selection fSelection;
    private boolean fTraverseSelectedNode;
    private Node fLastCoveringNode;
    private List<Node> fSelectedNodes;

    public SelectionAnalyzer(Selection selection, boolean traverseSelectedNode) {
        Assert.isNotNull((Object)selection);
        this.fSelection = selection;
        this.fTraverseSelectedNode = traverseSelectedNode;
    }

    public boolean hasSelectedNodes() {
        return this.fSelectedNodes != null && !this.fSelectedNodes.isEmpty();
    }

    public Node[] getSelectedNodes() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return new Node[0];
        }
        return this.fSelectedNodes.toArray(new Node[this.fSelectedNodes.size()]);
    }

    public Node getFirstSelectedNode() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        return this.fSelectedNodes.get(0);
    }

    public boolean isExpressionSelected() {
        if (!this.hasSelectedNodes()) {
            return false;
        }
        return this.fSelectedNodes.get(0) instanceof Expression;
    }

    public IRegion getSelectedNodeRange() {
        if (this.fSelectedNodes == null || this.fSelectedNodes.isEmpty()) {
            return null;
        }
        Node firstNode = this.fSelectedNodes.get(0);
        Node lastNode = this.fSelectedNodes.get(this.fSelectedNodes.size() - 1);
        int start = firstNode.getBegin();
        return new Region(start, lastNode.getEnd() - start);
    }

    public Node getLastCoveringNode() {
        return this.fLastCoveringNode;
    }

    protected Selection getSelection() {
        return this.fSelection;
    }

    public void traverse(Node node) {
        if (this.isTraverseNeeded(node).booleanValue()) {
            for (EObject item : node.eContents()) {
                this.traverse((Node)item);
            }
        }
        this.doSwitch(node);
    }

    public Boolean isTraverseNeeded(Node node) {
        if (this.fSelection.liesOutside(node)) {
            return false;
        }
        if (this.fSelection.covers(node)) {
            if (this.isFirstNode()) {
                this.handleFirstSelectedNode(node);
            } else {
                this.handleNextSelectedNode(node);
            }
            return this.fTraverseSelectedNode;
        }
        if (this.fSelection.coveredBy(node)) {
            this.fLastCoveringNode = node;
            return true;
        }
        if (this.fSelection.endsIn(node)) {
            return this.handleSelectionEndsIn(node);
        }
        return true;
    }

    protected void reset() {
        this.fSelectedNodes = null;
    }

    protected void handleFirstSelectedNode(Node node) {
        this.fSelectedNodes = new ArrayList<Node>(5);
        this.fSelectedNodes.add(node);
    }

    protected void handleNextSelectedNode(Node node) {
        if (this.getFirstSelectedNode().eContainer() == node.eContainer()) {
            this.fSelectedNodes.add(node);
        }
    }

    protected boolean handleSelectionEndsIn(Node node) {
        return false;
    }

    private boolean isFirstNode() {
        return this.fSelectedNodes == null;
    }
}

