/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text.completion;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.codeassist.ICompletionEngine;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.CompletionRequestor;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.keyword.IKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordCategory;
import org.eclipse.dltk.javascript.core.JSKeywordManager;
import org.eclipse.dltk.javascript.internal.core.codeassist.JSCompletionEngine;
import org.eclipse.dltk.javascript.internal.ui.JavaScriptUI;
import org.eclipse.dltk.javascript.internal.ui.templates.JSDocTemplateCompletionProcessor;
import org.eclipse.dltk.javascript.internal.ui.text.completion.JavaScriptCompletionProposalCollector;
import org.eclipse.dltk.javascript.parser.jsdoc.JSDocTag;
import org.eclipse.dltk.javascript.typeinfo.TypeMode;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.templates.ScriptTemplateProposal;
import org.eclipse.dltk.ui.text.completion.ContentAssistInvocationContext;
import org.eclipse.dltk.ui.text.completion.IScriptCompletionProposalComputer;
import org.eclipse.dltk.ui.text.completion.ScriptCompletionProposal;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDocCompletionProposalComputer
implements IScriptCompletionProposalComputer {
    public void sessionStarted() {
    }

    public void sessionEnded() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ICompletionProposal> computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        IDocument document = context.getDocument();
        try {
            IRegion region = document.getLineInformationOfOffset(context.getInvocationOffset());
            char[] line = document.get(region.getOffset(), region.getLength()).toCharArray();
            int offsetInLine = context.getInvocationOffset() - region.getOffset();
            int index = 0;
            index = JSDocCompletionProposalComputer.skipSpaces(line, index, offsetInLine);
            if (index < offsetInLine && line[index] == '/') {
                ++index;
            }
            while (true) {
                if (index >= offsetInLine || line[index] != '*') {
                    if ((index = JSDocCompletionProposalComputer.skipSpaces(line, index, offsetInLine)) >= offsetInLine) return Collections.emptyList();
                    if (line[index] == '@') break;
                    return Collections.emptyList();
                }
                ++index;
            }
            int tagStart = index++;
            if (index < offsetInLine && Character.isJavaIdentifierStart(line[index])) {
                ++index;
                while (index < offsetInLine && (Character.isJavaIdentifierPart(line[index]) || line[index] == '.' || line[index] == '-')) {
                    ++index;
                }
            }
            if (index == offsetInLine) {
                return this.completionOnTag(context, new String(line, tagStart, index - tagStart));
            }
            int tagEnd = index;
            index = JSDocCompletionProposalComputer.skipSpaces(line, index, offsetInLine);
            int depth = 0;
            int nameStart = index;
            boolean breakOnSpace = false;
            if (index < offsetInLine && line[index] == '{') {
                depth = 1;
                nameStart = ++index;
            } else {
                if (!"@type".equals(new String(line, tagStart, tagEnd - tagStart))) return Collections.emptyList();
                breakOnSpace = true;
            }
            while (true) {
                if (index >= offsetInLine) {
                    if (index != offsetInLine) return Collections.emptyList();
                    return this.completionOnType(context, new String(line, nameStart, index - nameStart));
                }
                if (line[index] == '}') {
                    if (--depth <= 0) {
                        return Collections.emptyList();
                    }
                } else if (line[index] == '{') {
                    ++depth;
                } else if (line[index] == '<' || line[index] == '>' || line[index] == ',' || line[index] == '|') {
                    nameStart = index + 1;
                } else if (breakOnSpace && Character.isWhitespace(line[index])) {
                    return Collections.emptyList();
                }
                ++index;
            }
        }
        catch (BadLocationException e) {
            JavaScriptUI.log((Exception)((Object)e));
        }
        return Collections.emptyList();
    }

    private static int skipSpaces(char[] line, int index, int offsetInLine) {
        while (index < offsetInLine && Character.isWhitespace(line[index])) {
            ++index;
        }
        return index;
    }

    private List<ICompletionProposal> completionOnTag(ContentAssistInvocationContext context, String tag) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        JSDocTemplateCompletionProcessor processor = new JSDocTemplateCompletionProcessor((ScriptContentAssistInvocationContext)context);
        Collections.addAll(proposals, processor.computeCompletionProposals(context.getViewer(), context.getInvocationOffset()));
        HashSet tags = new HashSet();
        Collections.addAll(tags, JSDocTag.getTags());
        ISourceModule module = null;
        Collections.addAll(tags, JSKeywordManager.getInstance().getKeywords((IKeywordCategory)JSKeywordCategory.JS_DOC_TAG, module));
        tags.remove("@returns");
        HashSet<String> usedTags = new HashSet<String>();
        for (ICompletionProposal proposal : proposals) {
            if (!(proposal instanceof ScriptTemplateProposal)) continue;
            usedTags.add(((ScriptTemplateProposal)proposal).getTemplateName());
        }
        for (String jsdocTag : tags) {
            if (!CharOperation.prefixEquals((String)tag, (String)jsdocTag) || usedTags.contains(jsdocTag)) continue;
            proposals.add((ICompletionProposal)new ScriptCompletionProposal(String.valueOf(jsdocTag) + ' ', context.getInvocationOffset() - tag.length(), tag.length(), DLTKPluginImages.get((String)"org.eclipse.dltk.ui.jdoc_tag_obj.gif"), jsdocTag, 90, true));
        }
        return proposals;
    }

    private List<ICompletionProposal> completionOnType(ContentAssistInvocationContext context, String prefix) {
        JSCompletionEngine engine;
        if (context instanceof ScriptContentAssistInvocationContext && (engine = this.getCompletionEngine()) != null) {
            ISourceModule module = ((ScriptContentAssistInvocationContext)context).getSourceModule();
            JavaScriptCompletionProposalCollector collector = new JavaScriptCompletionProposalCollector(module);
            collector.setAttribute(TypeMode.JSDOC, Boolean.TRUE);
            collector.setInvocationContext((ScriptContentAssistInvocationContext)context);
            engine.setRequestor((CompletionRequestor)collector);
            engine.completeTypes(module, TypeMode.JSDOC, prefix.trim(), context.getInvocationOffset());
            return Arrays.asList(collector.getScriptCompletionProposals());
        }
        return Collections.emptyList();
    }

    private JSCompletionEngine getCompletionEngine() {
        ICompletionEngine[] engines = DLTKLanguageManager.getCompletionEngines((String)"org.eclipse.dltk.javascript.core.nature");
        if (engines != null) {
            ICompletionEngine[] iCompletionEngineArray = engines;
            int n = engines.length;
            int n2 = 0;
            while (n2 < n) {
                ICompletionEngine engine = iCompletionEngineArray[n2];
                if (engine instanceof JSCompletionEngine) {
                    return (JSCompletionEngine)engine;
                }
                ++n2;
            }
        }
        return null;
    }

    public List<IContextInformation> computeContextInformation(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        return Collections.emptyList();
    }

    public String getErrorMessage() {
        return null;
    }
}

