/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.dltk.javascript.typeinfo.IRAnyType;
import org.eclipse.dltk.javascript.typeinfo.IRArrayType;
import org.eclipse.dltk.javascript.typeinfo.IRClassType;
import org.eclipse.dltk.javascript.typeinfo.IRMapType;
import org.eclipse.dltk.javascript.typeinfo.IRSimpleType;
import org.eclipse.dltk.javascript.typeinfo.IRType;
import org.eclipse.dltk.javascript.typeinfo.IRUnionType;
import org.eclipse.dltk.javascript.typeinfo.ITypeInfoContext;
import org.eclipse.dltk.javascript.typeinfo.ITypeSystem;
import org.eclipse.dltk.javascript.typeinfo.JSTypeSet;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoResourceSet;
import org.eclipse.dltk.javascript.typeinfo.model.AnyType;
import org.eclipse.dltk.javascript.typeinfo.model.ArrayType;
import org.eclipse.dltk.javascript.typeinfo.model.ClassType;
import org.eclipse.dltk.javascript.typeinfo.model.Constructor;
import org.eclipse.dltk.javascript.typeinfo.model.JSType;
import org.eclipse.dltk.javascript.typeinfo.model.MapType;
import org.eclipse.dltk.javascript.typeinfo.model.Member;
import org.eclipse.dltk.javascript.typeinfo.model.ParameterizedType;
import org.eclipse.dltk.javascript.typeinfo.model.RecordType;
import org.eclipse.dltk.javascript.typeinfo.model.SimpleType;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelFactory;
import org.eclipse.dltk.javascript.typeinfo.model.TypeInfoModelLoader;
import org.eclipse.dltk.javascript.typeinfo.model.TypeKind;
import org.eclipse.dltk.javascript.typeinfo.model.UndefinedType;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeUtil {
    private static final String PROXY_SCHEME = "proxy";
    private static final String PROXY_OPAQUE_PART = "dltk/javascript/typeinfo/type";

    public static SimpleType ref(Type type) {
        if (type != null) {
            SimpleType ref = TypeInfoModelFactory.eINSTANCE.createSimpleType();
            ref.setTarget(type);
            return ref;
        }
        return null;
    }

    public static ClassType classType(Type type) {
        if (type != null) {
            ClassType ref = TypeInfoModelFactory.eINSTANCE.createClassType();
            ref.setTarget(type);
            return ref;
        }
        return null;
    }

    public static JSType ref(String typeName) {
        return TypeUtil.ref(TypeUtil.type(typeName));
    }

    public static Type type(String typeName) {
        Type type = TypeInfoModelLoader.getInstance().getType(typeName);
        if (type != null) {
            return type;
        }
        return TypeUtil.createProxy(typeName);
    }

    public static ArrayType arrayOf(String itemType) {
        return TypeUtil.arrayOf(TypeUtil.ref(itemType));
    }

    public static ArrayType arrayOf(JSType itemType) {
        ArrayType arrayType = TypeInfoModelFactory.eINSTANCE.createArrayType();
        arrayType.setItemType(itemType != null ? itemType : TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("Object")));
        return arrayType;
    }

    public static MapType mapOf(String keyType, String valueType) {
        return TypeUtil.mapOf(keyType != null ? TypeUtil.ref(keyType) : null, TypeUtil.ref(valueType));
    }

    public static MapType mapOf(JSType keyType, JSType valueType) {
        MapType mapType = TypeInfoModelFactory.eINSTANCE.createMapType();
        mapType.setKeyType(keyType != null ? keyType : TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("String")));
        mapType.setValueType(valueType != null ? valueType : TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("Object")));
        return mapType;
    }

    public static ParameterizedType genericType(String baseType, JSType ... typeParameters) {
        ParameterizedType genericType = TypeInfoModelFactory.eINSTANCE.createParameterizedType();
        genericType.setTarget(TypeUtil.type(baseType));
        JSType[] jSTypeArray = typeParameters;
        int n = typeParameters.length;
        int n2 = 0;
        while (n2 < n) {
            JSType typeParameter = jSTypeArray[n2];
            genericType.getActualTypeArguments().add((Object)typeParameter);
            ++n2;
        }
        return genericType;
    }

    public static Type extractType(JSType type) {
        if (type instanceof SimpleType) {
            return ((SimpleType)type).getTarget();
        }
        if (type instanceof ClassType) {
            return ((ClassType)type).getTarget();
        }
        if (type instanceof ArrayType) {
            return TypeInfoModelLoader.getInstance().getType("Array");
        }
        if (type instanceof MapType) {
            return TypeInfoModelLoader.getInstance().getType("Object");
        }
        if (type instanceof AnyType) {
            return TypeInfoModelLoader.getInstance().getType("Object");
        }
        return null;
    }

    public static Type extractType(ITypeSystem context, IRType type) {
        if (type instanceof IRSimpleType) {
            return ((IRSimpleType)type).getTarget();
        }
        if (type instanceof IRClassType) {
            return ((IRClassType)type).getTarget();
        }
        if (type instanceof IRArrayType) {
            IRArrayType arrayType = (IRArrayType)type;
            ITypeSystem saved = arrayType.activeTypeSystem();
            if (saved != null) {
                context = saved;
            }
            return context.parameterize(TypeInfoModelLoader.getInstance().getType("Array"), Collections.singletonList(arrayType.getItemType()));
        }
        if (type instanceof IRMapType) {
            return TypeInfoModelLoader.getInstance().getType("Object");
        }
        if (type instanceof IRAnyType) {
            return TypeInfoModelLoader.getInstance().getType("Object");
        }
        return null;
    }

    public static JSType extractArrayItemType(JSType type, ITypeInfoContext context) {
        if (type instanceof ArrayType) {
            return ((ArrayType)type).getItemType();
        }
        if (type instanceof MapType) {
            return ((MapType)type).getValueType();
        }
        if (type != null && type.getName().equals("XML")) {
            return type;
        }
        if (type != null && type.getName().equals("XMLList")) {
            return TypeUtil.ref(TypeInfoModelLoader.getInstance().getType("XML"));
        }
        return null;
    }

    public static IRType extractArrayItemType(IRType type) {
        if (type instanceof IRArrayType) {
            return ((IRArrayType)type).getItemType();
        }
        if (type instanceof IRMapType) {
            return ((IRMapType)type).getValueType();
        }
        if (type != null && type.getName().equals("XML")) {
            return type;
        }
        if (type != null && type.getName().equals("XMLList")) {
            return JSTypeSet.ref(TypeInfoModelLoader.getInstance().getType("XML"));
        }
        return null;
    }

    public static String getName(JSType type) {
        return type != null ? type.getName() : null;
    }

    public static String getName(IRType type) {
        return type != null ? type.getName() : null;
    }

    public static String getName(Type type) {
        if (type.isProxy()) {
            return URI.decode((String)((InternalEObject)type).eProxyURI().fragment());
        }
        return type.getName();
    }

    public static Type createProxy(String typeName) {
        return TypeUtil.createProxy(TypeUtil.createProxyURI(typeName));
    }

    public static Type createProxy(URI uri) {
        Type type = TypeInfoModelFactory.eINSTANCE.createType();
        type.setName(uri.fragment());
        ((InternalEObject)type).eSetProxyURI(uri);
        return type;
    }

    public static URI createProxyURI(String typeName) {
        if (typeName == null) {
            throw new NullPointerException("Type name is null");
        }
        return URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, (String)URI.encodeFragment((String)typeName, (boolean)false));
    }

    public static Type createProxy(Type type) {
        Type result = TypeInfoModelFactory.eINSTANCE.createType();
        if (type.isProxy()) {
            ((InternalEObject)result).eSetProxyURI(((InternalEObject)type).eProxyURI());
        } else {
            String typeName = type.getName();
            result.setName(typeName);
            ((InternalEObject)result).eSetProxyURI(TypeUtil.createProxyURI(typeName));
        }
        return result;
    }

    public static boolean isTypeProxy(URI uri) {
        return PROXY_SCHEME.equals(uri.scheme()) && PROXY_OPAQUE_PART.equals(uri.opaquePart());
    }

    public static URI createProxyResourceURI() {
        return URI.createGenericURI((String)PROXY_SCHEME, (String)PROXY_OPAQUE_PART, null);
    }

    public static EObject resolve(InternalEObject proxy, EObject objectContext) {
        ResourceSet resourceSet;
        Resource resource = objectContext.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) instanceof TypeInfoResourceSet) {
            return ((TypeInfoResourceSet)resourceSet).resolve(proxy, objectContext, resource);
        }
        return EcoreUtil.resolve((EObject)proxy, (EObject)objectContext);
    }

    public static boolean isDeclaringTypeVisible(Member member) {
        return member.getDeclaringType() != null && !(member.getDeclaringType().eContainer() instanceof RecordType);
    }

    public static boolean isValueTypeVisible(JSType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof UndefinedType) {
            return false;
        }
        return !(type instanceof RecordType);
    }

    public static TypeKind kind(IRType type) {
        if (type != null) {
            Type t;
            if (type instanceof IRSimpleType) {
                Type t2 = ((IRSimpleType)type).getTarget();
                if (t2 != null) {
                    return t2.getKind();
                }
            } else if (type instanceof IRClassType && (t = ((IRClassType)type).getTarget()) != null) {
                return t.getKind();
            }
        }
        return null;
    }

    public static List<Constructor> findConstructors(Type type) {
        HashSet<Type> types = new HashSet<Type>();
        while (types.add(type)) {
            EList<Constructor> constructors = type.getConstructors();
            if (!constructors.isEmpty()) {
                return constructors;
            }
            if (!type.isInheritConstructors() || (type = type.getSuperType()) == null) break;
        }
        return Collections.emptyList();
    }

    public static boolean isUndefined(IRType type) {
        if (type == JSTypeSet.undefined()) {
            return true;
        }
        if (type instanceof IRUnionType) {
            return ((IRUnionType)type).getTargets().contains(JSTypeSet.undefined());
        }
        return false;
    }
}

