/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import org.eclipse.dltk.compiler.IElementRequestor;
import org.eclipse.dltk.internal.javascript.parser.structure.Declaration;
import org.eclipse.dltk.internal.javascript.parser.structure.StructureReporter;
import org.eclipse.dltk.javascript.typeinference.IValueReference;
import org.eclipse.dltk.javascript.typeinference.ReferenceLocation;

class FieldDeclaration
extends Declaration {
    public FieldDeclaration(String childName, IValueReference child) {
        super(childName, child);
    }

    public void report(StructureReporter reporter, boolean allowFields) {
        ReferenceLocation location = this.child.getLocation();
        if (allowFields) {
            reporter.removeReference(this.childName, location.getNameStart(), location.getNameEnd());
            reporter.reportRefs(location.getDeclarationStart());
            IElementRequestor.FieldInfo fi = new IElementRequestor.FieldInfo();
            fi.name = this.childName;
            fi.type = FieldDeclaration.extractType(this.child);
            FieldDeclaration.copyLocation(location, (IElementRequestor.ElementInfo)fi);
            reporter.fRequestor.enterField(fi);
        }
        reporter.processScope(this.child, false);
        if (allowFields) {
            reporter.fRequestor.exitField(location.getDeclarationEnd());
        }
    }
}

