/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.Documentable;
import org.eclipse.dltk.javascript.ast.Literal;

public class StringLiteral
extends Literal
implements Documentable {
    private String text;
    private Comment documentation;

    public StringLiteral(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            visitor.endvisit((ASTNode)this);
        }
    }

    public String getText() {
        return this.text;
    }

    public String getValue() {
        return this.text != null ? StringLiteral.valueOf(this.text) : null;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        return this.text;
    }

    public Comment getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(Comment documentation) {
        this.documentation = documentation;
    }

    public static String valueOf(String text) {
        char ch0;
        int len = text.length();
        if (len >= 2 && ((ch0 = text.charAt(0)) == '\"' || ch0 == '\'') && text.charAt(len - 1) == ch0) {
            return text.substring(1, len - 1);
        }
        return text;
    }
}

