/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import org.antlr.runtime.CharStream;
import org.antlr.runtime.MismatchedTokenException;
import org.antlr.runtime.RecognitionException;
import org.eclipse.dltk.javascript.parser.JSTokenSource;
import org.eclipse.dltk.javascript.parser.JavaScriptLexer;

public class JavaScriptTokenSource
extends JavaScriptLexer
implements JSTokenSource {
    private int xmlMode = 0;
    private int xmlOpenTagsCount;
    private boolean xmlIsAttribute;
    private boolean xmlIsTagContent;

    public JavaScriptTokenSource(CharStream input) {
        super(input);
    }

    public int getMode() {
        return this.xmlMode;
    }

    public void setMode(int mode) {
        this.xmlMode = mode;
    }

    public void seek(int index) {
        this.input.seek(index);
    }

    public void mTokens() throws RecognitionException {
        if (this.xmlMode == 1) {
            this.readNextXml();
        } else if (this.xmlMode == 2) {
            try {
                super.mTokens();
            }
            catch (RecognitionException e) {
                this.recover(e);
                this.type = 122;
                this.emit();
            }
        } else {
            super.mTokens();
        }
    }

    protected void readFirstXml() throws RecognitionException {
        assert (this.xmlMode == 0);
        this.xmlOpenTagsCount = 0;
        this.xmlIsAttribute = false;
        this.xmlIsTagContent = false;
        this.readNextXml();
    }

    private void readNextXml() {
        try {
            this.type = this.readXmlToken();
            this.emit();
        }
        catch (LexerException lexerException) {
            this.type = 122;
            this.emit();
        }
    }

    private int readXmlToken() {
        int c;
        while ((c = this.input.LA(1)) != -1) {
            if (this.xmlIsTagContent) {
                switch (c) {
                    case 62: {
                        this.matchAny();
                        this.xmlIsTagContent = false;
                        this.xmlIsAttribute = false;
                        break;
                    }
                    case 47: {
                        this.matchAny();
                        if (this.input.LA(1) != 62) break;
                        this.matchAny();
                        this.xmlIsTagContent = false;
                        --this.xmlOpenTagsCount;
                        break;
                    }
                    case 123: {
                        return 120;
                    }
                    case 34: 
                    case 39: {
                        this.matchAny();
                        this.readQuotedString(c);
                        break;
                    }
                    case 61: {
                        this.matchAny();
                        this.xmlIsAttribute = true;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 13: 
                    case 32: {
                        this.matchAny();
                        break;
                    }
                    default: {
                        this.matchAny();
                        this.xmlIsAttribute = false;
                    }
                }
                if (this.xmlIsTagContent || this.xmlOpenTagsCount != 0) continue;
                return 121;
            }
            block9 : switch (c) {
                case 60: {
                    this.matchAny();
                    switch (this.input.LA(1)) {
                        case 33: {
                            this.matchAny();
                            switch (this.input.LA(1)) {
                                case 45: {
                                    this.matchAny();
                                    if (this.input.LA(1) == 45) {
                                        this.matchAny();
                                        this.readXmlComment();
                                        break block9;
                                    }
                                    throw new LexerException("msg.XML.bad.form");
                                }
                                case 91: {
                                    this.matchAny();
                                    try {
                                        this.match("CDATA[");
                                    }
                                    catch (MismatchedTokenException mismatchedTokenException) {
                                        throw new LexerException("CDATA[ expected");
                                    }
                                    this.readCDATA();
                                    break block9;
                                }
                            }
                            this.readEntity();
                            break block9;
                        }
                        case 63: {
                            this.matchAny();
                            this.readPI();
                            break block9;
                        }
                        case 47: {
                            this.matchAny();
                            if (this.xmlOpenTagsCount == 0) {
                                throw new LexerException("msg.XML.bad.form");
                            }
                            this.xmlIsTagContent = true;
                            --this.xmlOpenTagsCount;
                            break block9;
                        }
                    }
                    this.xmlIsTagContent = true;
                    ++this.xmlOpenTagsCount;
                    break;
                }
                case 123: {
                    return 120;
                }
                default: {
                    this.matchAny();
                }
            }
        }
        throw new LexerException("msg.XML.bad.form");
    }

    private void readQuotedString(int quote) {
        int c;
        while ((c = this.input.LA(1)) != -1) {
            this.matchAny();
            if (c != quote) continue;
            return;
        }
        throw new LexerException("msg.XML.bad.form");
    }

    private void readXmlComment() {
        int c;
        while ((c = this.input.LA(1)) != -1) {
            this.matchAny();
            if (c != 45 || this.input.LA(1) != 45 || this.input.LA(2) != 62) continue;
            return;
        }
        throw new LexerException("msg.XML.bad.form");
    }

    private void readCDATA() {
        int c;
        while ((c = this.input.LA(1)) != -1) {
            this.matchAny();
            if (c != 93 || this.input.LA(1) != 93 || this.input.LA(2) != 62) continue;
            return;
        }
        throw new LexerException("msg.XML.bad.form");
    }

    private void readEntity() {
        int c;
        int declTags = 1;
        while ((c = this.input.LA(1)) != -1) {
            this.matchAny();
            switch (c) {
                case 60: {
                    ++declTags;
                    break;
                }
                case 62: {
                    if (--declTags != 0) break;
                    return;
                }
            }
        }
        throw new LexerException("msg.XML.bad.form");
    }

    private void readPI() {
        int c;
        while ((c = this.input.LA(1)) != -1) {
            this.matchAny();
            if (c != 63 || this.input.LA(1) != 62) continue;
            this.matchAny();
            return;
        }
        throw new LexerException("msg.XML.bad.form");
    }

    private static class LexerException
    extends RuntimeException {
        public LexerException(String message) {
            super(message);
        }
    }
}

