/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.parser.structure;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.dltk.internal.javascript.parser.structure.ReferenceIterator;
import org.eclipse.dltk.internal.javascript.parser.structure.ReferenceKey;

class ReferenceSet {
    private final SortedMap<ReferenceKey, List<Object>> references = new TreeMap<ReferenceKey, List<Object>>();

    ReferenceSet() {
    }

    public void add(String name, int start, int end) {
        this.add(name, start, end, null);
    }

    public void add(String name, int start, int end, Object value) {
        ReferenceKey key = new ReferenceKey(start, end, name);
        ArrayList<Object> values = (ArrayList<Object>)this.references.get(key);
        if (values == null) {
            values = new ArrayList<Object>();
            this.references.put(key, values);
        }
        if (value != null && !values.contains(value)) {
            values.add(value);
        }
    }

    public ReferenceIterator iterator() {
        return new IteratorImpl();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class IteratorImpl
    implements ReferenceIterator {
        private final Iterator<Map.Entry<ReferenceKey, List<Object>>> entryIterator;
        private Map.Entry<ReferenceKey, List<Object>> currentEntry = null;

        public IteratorImpl() {
            this.entryIterator = ReferenceSet.this.references.entrySet().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.currentEntry != null || this.entryIterator.hasNext();
        }

        @Override
        public void moveNext() {
            this.currentEntry = this.currentEntry != null ? null : this.entryIterator.next();
        }

        private Map.Entry<ReferenceKey, List<Object>> fetch() {
            if (this.currentEntry == null) {
                this.currentEntry = this.entryIterator.next();
            }
            return this.currentEntry;
        }

        @Override
        public ReferenceKey current() {
            return this.fetch().getKey();
        }

        @Override
        public List<Object> getValues() {
            return this.fetch().getValue();
        }

        @Override
        public void remove(String name, int start, int end) {
            List values;
            ReferenceKey key = new ReferenceKey(start, end, name);
            if (this.currentEntry != null && key.equals(this.currentEntry.getKey())) {
                this.currentEntry = null;
            }
            if ((values = (List)ReferenceSet.this.references.get(key)) != null && !values.contains(Boolean.FALSE)) {
                values.clear();
                values.add(Boolean.FALSE);
            }
        }
    }
}

