/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.formatter.internal.nodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dltk.formatter.FormatterBlockNode;
import org.eclipse.dltk.formatter.FormatterUtils;
import org.eclipse.dltk.formatter.IFormatterContext;
import org.eclipse.dltk.formatter.IFormatterDocument;
import org.eclipse.dltk.formatter.IFormatterNode;
import org.eclipse.dltk.formatter.IFormatterTextNode;
import org.eclipse.dltk.formatter.IFormatterWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FormatterBlockWithBeginEndNode
extends FormatterBlockNode {
    private List<IFormatterNode> begin = null;
    private IFormatterTextNode end;

    public FormatterBlockWithBeginEndNode(IFormatterDocument document) {
        super(document);
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        context.setBlankLines(this.getBlankLinesBefore(context));
        if (this.begin != null) {
            for (IFormatterNode node : this.begin) {
                node.accept(context, visitor);
            }
        }
        context.resetBlankLines();
        boolean indenting = this.isIndenting();
        if (indenting) {
            context.incIndent();
        }
        super.accept(context, visitor);
        if (indenting) {
            context.decIndent();
        }
        if (this.end != null) {
            visitor.write(context, this.end.getStartOffset(), this.end.getEndOffset());
        }
        context.setBlankLines(this.getBlankLinesAfter(context));
    }

    protected int getBlankLinesBefore(IFormatterContext context) {
        return -1;
    }

    protected int getBlankLinesAfter(IFormatterContext context) {
        return -1;
    }

    public IFormatterNode[] getBegin() {
        return FormatterUtils.toTextNodeArray(this.begin);
    }

    public void setBegin(IFormatterTextNode begin) {
        if (this.begin == null) {
            this.begin = new ArrayList<IFormatterNode>();
        }
        this.begin.add((IFormatterNode)begin);
    }

    public void insertBefore(List<IFormatterNode> nodes) {
        if (this.begin == null) {
            this.begin = new ArrayList<IFormatterNode>();
        }
        this.begin.addAll(0, nodes);
    }

    public IFormatterTextNode getEnd() {
        return this.end;
    }

    public void setEnd(IFormatterTextNode node) {
        this.end = node;
    }

    protected boolean isIndenting() {
        return true;
    }

    public int getStartOffset() {
        if (this.begin != null) {
            return ((IFormatterTextNode)this.begin.get(0)).getStartOffset();
        }
        return super.getStartOffset();
    }

    public int getEndOffset() {
        if (this.end != null) {
            return this.end.getEndOffset();
        }
        if (!super.isEmpty()) {
            return super.getEndOffset();
        }
        if (this.begin != null) {
            return ((IFormatterTextNode)this.begin.get(this.begin.size() - 1)).getEndOffset();
        }
        return 0;
    }

    public boolean isEmpty() {
        return this.begin == null && this.end == null && super.isEmpty();
    }

    public List<IFormatterNode> getChildren() {
        if (this.begin == null && this.end == null) {
            return super.getChildren();
        }
        ArrayList<IFormatterNode> result = new ArrayList<IFormatterNode>();
        if (this.begin != null) {
            result.addAll(this.begin);
        }
        result.addAll(super.getChildren());
        if (this.end != null) {
            result.add((IFormatterNode)this.end);
        }
        return result;
    }

    public String toString() {
        return this.begin + "\n" + super.toString() + "\n" + this.end;
    }
}

