/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.typeinfo.model;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.javascript.typeinfo.TypeInfoManager;
import org.eclipse.dltk.javascript.typeinfo.model.Type;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInfoModelLoader {
    private static TypeInfoModelLoader instance = null;
    private final ResourceSet resourceSet = TypeInfoManager.loadModelResources();

    public static synchronized TypeInfoModelLoader getInstance() {
        if (instance == null) {
            instance = new TypeInfoModelLoader();
        }
        return instance;
    }

    private TypeInfoModelLoader() {
    }

    public Type getType(String typeName) {
        for (Resource resource : this.resourceSet.getResources()) {
            for (EObject object : resource.getContents()) {
                Type type;
                if (!(object instanceof Type) || !typeName.equals((type = (Type)object).getName())) continue;
                return type;
            }
        }
        return null;
    }

    public Set<String> listTypes(String prefix) {
        HashSet<String> result = new HashSet<String>();
        for (Resource resource : this.resourceSet.getResources()) {
            for (EObject object : resource.getContents()) {
                Type type;
                if (!(object instanceof Type) || !CharOperation.prefixEquals((String)prefix, (String)(type = (Type)object).getName())) continue;
                result.add(type.getName());
            }
        }
        return result;
    }
}

