/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.validation;

import java.util.List;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstStatement;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.EmptyStatement;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.Method;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ObjectInitializerPart;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.SimpleType;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VariableStatement;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractNavigationVisitor<E>
extends ASTVisitor<E> {
    public E visitArrayInitializer(ArrayInitializer node) {
        for (ASTNode item : node.getItems()) {
            this.visit(item);
        }
        return null;
    }

    public E visitAsteriskExpression(AsteriskExpression node) {
        return null;
    }

    public E visitBinaryOperation(BinaryOperation node) {
        this.visit((ASTNode)node.getLeftExpression());
        this.visit((ASTNode)node.getRightExpression());
        return null;
    }

    public E visitBooleanLiteral(BooleanLiteral node) {
        return null;
    }

    public E visitBreakStatement(BreakStatement node) {
        return null;
    }

    public E visitCallExpression(CallExpression node) {
        this.visit(node.getExpression());
        for (ASTNode argument : node.getArguments()) {
            this.visit(argument);
        }
        return null;
    }

    public E visitCommaExpression(CommaExpression node) {
        for (ASTNode item : node.getItems()) {
            this.visit(item);
        }
        return null;
    }

    public E visitConditionalOperator(ConditionalOperator node) {
        this.visit((ASTNode)node.getCondition());
        this.visit((ASTNode)node.getTrueValue());
        this.visit((ASTNode)node.getFalseValue());
        return null;
    }

    public E visitConstDeclaration(ConstStatement node) {
        this.processVariables(node.getVariables());
        return null;
    }

    private void processVariables(List<VariableDeclaration> variables) {
        for (VariableDeclaration declaration : variables) {
            if (declaration.getInitializer() == null) continue;
            this.visit((ASTNode)declaration.getInitializer());
        }
    }

    public E visitContinueStatement(ContinueStatement node) {
        return null;
    }

    public E visitDecimalLiteral(DecimalLiteral node) {
        return null;
    }

    public E visitDefaultXmlNamespace(DefaultXmlNamespaceStatement node) {
        return null;
    }

    public E visitDeleteStatement(DeleteStatement node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitDoWhileStatement(DoWhileStatement node) {
        Object result = this.visit((ASTNode)node.getBody());
        this.visitCondition(node.getCondition());
        return (E)result;
    }

    protected void visitCondition(Expression condition) {
        this.visit((ASTNode)condition);
    }

    public E visitEmptyExpression(EmptyExpression node) {
        return null;
    }

    public E visitEmptyStatement(EmptyStatement node) {
        return null;
    }

    public E visitForEachInStatement(ForEachInStatement node) {
        this.visit((ASTNode)node.getItem());
        this.visit((ASTNode)node.getIterator());
        return (E)this.visit((ASTNode)node.getBody());
    }

    public E visitForInStatement(ForInStatement node) {
        this.visit((ASTNode)node.getItem());
        this.visit((ASTNode)node.getIterator());
        return (E)this.visit((ASTNode)node.getBody());
    }

    public E visitForStatement(ForStatement node) {
        this.visit((ASTNode)node.getInitial());
        this.visit((ASTNode)node.getCondition());
        this.visit((ASTNode)node.getStep());
        return (E)this.visit((ASTNode)node.getBody());
    }

    public E visitFunctionStatement(FunctionStatement node) {
        return (E)this.visit((ASTNode)node.getBody());
    }

    public E visitGetAllChildrenExpression(GetAllChildrenExpression node) {
        this.visit((ASTNode)node.getObject());
        this.visit((ASTNode)node.getProperty());
        return null;
    }

    public E visitGetArrayItemExpression(GetArrayItemExpression node) {
        this.visit((ASTNode)node.getArray());
        this.visit((ASTNode)node.getIndex());
        return null;
    }

    public E visitGetLocalNameExpression(GetLocalNameExpression node) {
        this.visit((ASTNode)node.getNamespace());
        this.visit((ASTNode)node.getLocalName());
        return null;
    }

    public E visitIdentifier(Identifier node) {
        return null;
    }

    public E visitIfStatement(IfStatement node) {
        this.visitCondition(node.getCondition());
        this.visit((ASTNode)node.getThenStatement());
        if (node.getElseStatement() != null) {
            this.visit((ASTNode)node.getElseStatement());
        }
        return null;
    }

    public E visitLabelledStatement(LabelledStatement node) {
        this.visit((ASTNode)node.getStatement());
        return null;
    }

    public E visitNewExpression(NewExpression node) {
        this.visit((ASTNode)node.getObjectClass());
        return null;
    }

    public E visitNullExpression(NullExpression node) {
        return null;
    }

    public E visitObjectInitializer(ObjectInitializer node) {
        for (ObjectInitializerPart part : node.getInitializers()) {
            if (part instanceof GetMethod) {
                this.visitMethod((Method)((GetMethod)part));
                continue;
            }
            if (part instanceof SetMethod) {
                this.visitMethod((Method)((SetMethod)part));
                continue;
            }
            if (!(part instanceof PropertyInitializer)) continue;
            PropertyInitializer pi = (PropertyInitializer)part;
            this.visit((ASTNode)pi.getName());
            this.visit((ASTNode)pi.getValue());
        }
        return null;
    }

    protected E visitMethod(Method method) {
        return (E)this.visit((ASTNode)method.getBody());
    }

    public E visitParenthesizedExpression(ParenthesizedExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitPropertyExpression(PropertyExpression node) {
        this.visit((ASTNode)node.getObject());
        this.visit((ASTNode)node.getProperty());
        return null;
    }

    public E visitRegExpLiteral(RegExpLiteral node) {
        return null;
    }

    public E visitReturnStatement(ReturnStatement node) {
        if (node.getValue() != null) {
            this.visit((ASTNode)node.getValue());
        }
        return null;
    }

    public E visitScript(Script node) {
        for (Statement statement : node.getStatements()) {
            this.visit((ASTNode)statement);
        }
        return null;
    }

    public E visitSimpleType(SimpleType node) {
        return null;
    }

    public E visitStatementBlock(StatementBlock node) {
        for (Statement statement : node.getStatements()) {
            this.visit((ASTNode)statement);
        }
        return null;
    }

    public E visitStringLiteral(StringLiteral node) {
        return null;
    }

    public E visitSwitchStatement(SwitchStatement node) {
        return null;
    }

    public E visitThisExpression(ThisExpression node) {
        return null;
    }

    public E visitThrowStatement(ThrowStatement node) {
        if (node.getException() != null) {
            this.visit((ASTNode)node.getException());
        }
        return null;
    }

    public E visitTryStatement(TryStatement node) {
        Statement finallyStatement;
        this.visit((ASTNode)node.getBody());
        for (CatchClause catchClause : node.getCatches()) {
            Statement catchStatement = catchClause.getStatement();
            if (catchStatement == null) continue;
            this.visit((ASTNode)catchStatement);
        }
        if (node.getFinally() != null && (finallyStatement = node.getFinally().getStatement()) != null) {
            this.visit((ASTNode)finallyStatement);
        }
        return null;
    }

    public E visitTypeOfExpression(TypeOfExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitUnaryOperation(UnaryOperation node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitVariableStatment(VariableStatement node) {
        this.processVariables(node.getVariables());
        return null;
    }

    public E visitVoidExpression(VoidExpression node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitVoidOperator(VoidOperator node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitWhileStatement(WhileStatement node) {
        this.visitCondition(node.getCondition());
        return (E)this.visit((ASTNode)node.getBody());
    }

    public E visitWithStatement(WithStatement node) {
        this.visit((ASTNode)node.getExpression());
        this.visit((ASTNode)node.getStatement());
        return null;
    }

    public E visitXmlLiteral(XmlLiteral node) {
        return null;
    }

    public E visitXmlPropertyIdentifier(XmlAttributeIdentifier node) {
        this.visit((ASTNode)node.getExpression());
        return null;
    }

    public E visitYieldOperator(YieldOperator node) {
        this.visit(node.getParent());
        return null;
    }
}

