/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import com.xored.org.mozilla.javascript.FunctionNode;
import com.xored.org.mozilla.javascript.Node;
import com.xored.org.mozilla.javascript.ScriptOrFnNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import org.eclipse.dltk.compiler.ISourceElementRequestor;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.ReferenceResolverContext;
import org.eclipse.dltk.internal.javascript.typeinference.AutoCompleteReference;
import org.eclipse.dltk.internal.javascript.typeinference.CallResultReference;
import org.eclipse.dltk.internal.javascript.typeinference.CombinedOrReference;
import org.eclipse.dltk.internal.javascript.typeinference.ContextReference;
import org.eclipse.dltk.internal.javascript.typeinference.HostCollection;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.NewReference;
import org.eclipse.dltk.internal.javascript.typeinference.NodeSwitch;
import org.eclipse.dltk.internal.javascript.typeinference.PositionReachedException;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceFactory;
import org.eclipse.dltk.internal.javascript.typeinference.ReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.StandardSelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.TransparentRef;
import org.eclipse.dltk.internal.javascript.typeinference.XMLLiteralInferencer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeInferencer {
    public static final String RETURN_VALUE = "!!!returnValue";
    private ReferenceResolverContext cs;
    private final Stack<HostCollection> contexts = new Stack();
    private final Stack<IReference> withContexts = new Stack();
    private final Map<Integer, HostCollection> functionNodes = new HashMap<Integer, HostCollection>();
    HostCollection collection = new HostCollection();
    IModelElement module;
    private XMLLiteralInferencer xmlInferencer = null;
    ISourceElementRequestor requestor;

    public TypeInferencer(ModelElement owner, ReferenceResolverContext cs) {
        this.module = owner;
        this.cs = cs;
    }

    public HostCollection getCollection() {
        return this.collection;
    }

    public IReference evaluateReference(String key, Node expression, ReferenceResolverContext cs) {
        IReference result = this.internalEvaluate(this.collection, key, expression, this.module, cs);
        if (result != null) {
            return result;
        }
        return new StandardSelfCompletingReference(key, false);
    }

    IReference internalEvaluate(HostCollection collection, String key, Node expression, IModelElement parent, ReferenceResolverContext cs) {
        if (expression == null) {
            return null;
        }
        int type = expression.getType();
        switch (type) {
            case 130: {
                return this.internalEvaluate(collection, key, expression.getFirstChild(), parent, cs);
            }
            case 39: {
                return new CombinedOrReference(new NewReference(key, "Number", cs), new StandardSelfCompletingReference(key, false));
            }
            case 40: {
                return new CombinedOrReference(new NewReference(key, "String", cs), new StandardSelfCompletingReference(key, false));
            }
            case 43: 
            case 44: {
                return new CombinedOrReference(new NewReference(key, "Boolean", cs), new StandardSelfCompletingReference(key, false));
            }
            case 64: {
                return this.createObjectLiteral(collection, key, expression, parent, cs);
            }
            case 63: {
                return TypeInferencer.createArrayLiteralReference(collection, key, expression, cs);
            }
            case 37: {
                return TypeInferencer.createCallResult(collection, key, expression, cs);
            }
            case 105: {
                return TypeInferencer.createNewFunctionReference(collection, key, expression);
            }
            case 30: {
                return this.createNewObjectRefernce(collection, key, expression, cs);
            }
            case 33: 
            case 35: 
            case 38: {
                IReference ref;
                String key1 = TypeInferencer.getObjId(expression);
                if (key1.endsWith(".e")) {
                    key1 = key1.substring(0, key1.length() - 2);
                }
                if ((ref = collection.queryElement(key1, true)) == null) {
                    ref = TypeInferencer.resolveReferenceTree(key, cs, key1, ref);
                }
                if (ref != null) {
                    ref = new TransparentRef(this, ref, expression, key, parent, cs);
                }
                return ref;
            }
        }
        return null;
    }

    private static IReference resolveReferenceTree(String key, ReferenceResolverContext cs, String key1, IReference ref) {
        Set resolveGlobals = cs.resolveGlobals(key1);
        if (resolveGlobals.size() > 0) {
            ref = new AutoCompleteReference(key, key1, cs);
        }
        return ref;
    }

    private static IReference createNewFunctionReference(HostCollection collection2, String key, Node expression) {
        HostCollection function = collection2.getFunction(expression);
        if (function == null) {
            return null;
        }
        return new ContextReference(function, key);
    }

    private static IReference createCallResult(HostCollection collection2, String key, Node expression, ReferenceResolverContext cs) {
        Node nm = expression.getFirstChild();
        String id = TypeInferencer.getObjId(nm);
        if (id == null) {
            return null;
        }
        CallResultReference ref = new CallResultReference(collection2, key, id, cs);
        CombinedOrReference ws = new CombinedOrReference(ref, new StandardSelfCompletingReference(key, false));
        return ws;
    }

    private IReference createNewObjectRefernce(HostCollection collection2, String key, Node expression, ReferenceResolverContext cs) {
        Node lastChild;
        Node nm = expression.getFirstChild();
        String id = TypeInferencer.getObjId(nm);
        if (id == null) {
            return null;
        }
        NewReference ref = new NewReference(key, id, cs);
        StandardSelfCompletingReference unknownReference = new StandardSelfCompletingReference(key, false);
        if (id.equals("XML") && (lastChild = expression.getLastChild()) instanceof Node.StringNode) {
            String xmlText = lastChild.getString();
            if (this.xmlInferencer == null) {
                this.xmlInferencer = new XMLLiteralInferencer();
            }
            this.xmlInferencer.modifyReference(unknownReference, xmlText, cs);
        }
        return new CombinedOrReference(ref, unknownReference);
    }

    private static IReference createArrayLiteralReference(HostCollection collection2, String key, Node expression, ReferenceResolverContext cs) {
        String id = "Array";
        NewReference ref = new NewReference(key, id, cs);
        StandardSelfCompletingReference unknownReference = new StandardSelfCompletingReference(key, false);
        CombinedOrReference ws = new CombinedOrReference(ref, unknownReference);
        return ws;
    }

    private IReference createObjectLiteral(HostCollection col, String key, Node expression, IModelElement parent, ReferenceResolverContext cs) {
        Object[] ids = (Object[])expression.getProp(12);
        ArrayList positions = (ArrayList)expression.getProp(4);
        Node child = expression.getFirstChild();
        StandardSelfCompletingReference uRef = new StandardSelfCompletingReference(key, false);
        int a = 0;
        while (a < ids.length) {
            if (ids[a] instanceof String) {
                String name = (String)ids[a];
                IReference internalEvaluate = this.internalEvaluate(col, name, child, parent, cs);
                if (internalEvaluate == null) {
                    internalEvaluate = new StandardSelfCompletingReference(name, false);
                    if (child.getType() == 105) {
                        ((StandardSelfCompletingReference)internalEvaluate).setFunctionRef();
                    }
                }
                internalEvaluate.setLocationInformation(new ReferenceLocation(parent, (Integer)positions.get(a) - name.length() - 1, name.length()));
                uRef.setChild(name, internalEvaluate);
                child = child.getNext();
            }
            ++a;
        }
        return uRef;
    }

    public static String getObjId(Node id) {
        if (id == null) {
            return "";
        }
        switch (id.getType()) {
            case 37: {
                Node n = id.getFirstChild();
                return TypeInferencer.getObjId(n);
            }
            case 33: {
                Node n = id.getFirstChild();
                String result = String.valueOf(TypeInferencer.getObjId(n)) + '.' + id.getLastChild().getString();
                return result;
            }
            case 35: {
                Node n = id.getFirstChild();
                String res = TypeInferencer.getObjId(n);
                return String.valueOf(res) + "[]";
            }
            case 42: {
                return "this";
            }
            case 38: 
            case 48: {
                return TypeInferencer.getKey(id);
            }
        }
        return null;
    }

    public static String getKey(Node id) {
        try {
            return id.getString();
        }
        catch (ClassCastException classCastException) {
            return "";
        }
    }

    public HostCollection doInterferencing(ScriptOrFnNode node, int tillPosition) {
        HostCollection hostCollection = new HostCollection();
        TypeInferencerSwitch sw = new TypeInferencerSwitch(node, tillPosition);
        sw.doAction(node, hostCollection);
        return hostCollection;
    }

    public Map<Integer, HostCollection> getFunctionMap() {
        return this.functionNodes;
    }

    public void setRequestor(ISourceElementRequestor requestor) {
        this.requestor = requestor;
    }

    private final class TypeInferencerSwitch
    extends NodeSwitch {
        private final LinkedList<HostCollection> functionContexts;

        private TypeInferencerSwitch(ScriptOrFnNode module, int position) {
            super(module, position);
            this.functionContexts = new LinkedList();
        }

        public Object processNewNode(Node node, Object arg) {
            try {
                Node firstChild = node.getFirstChild();
                TypeInferencer.getObjId(firstChild.getNext());
                String call = TypeInferencer.getObjId(firstChild);
                if (call == null) {
                    return super.processNewNode(node, arg);
                }
                int length = call.length();
                int indexOf = call.indexOf(46);
                if (indexOf != -1) {
                    call = call.substring(indexOf + 1);
                }
                if (TypeInferencer.this.requestor != null && call != null && firstChild.getPosition() != 0) {
                    TypeInferencer.this.requestor.acceptMethodReference(call, 0, firstChild.getPosition() - length, firstChild.getPosition() - 1);
                }
            }
            catch (Throwable throwable) {}
            return super.processScriptNode(node, arg);
        }

        public Object processCall(Node node, Object arg) {
            try {
                Node firstChild = node.getFirstChild();
                String objId = TypeInferencer.getObjId(firstChild.getNext());
                String call = TypeInferencer.getObjId(firstChild);
                if (call == null) {
                    return super.processNewNode(node, arg);
                }
                int length = call.length();
                int indexOf = call.indexOf(46);
                if (indexOf != -1) {
                    call = call.substring(indexOf + 1);
                }
                TypeInferencer.this.cs.processCall(call, objId);
                if (TypeInferencer.this.requestor != null && call != null && firstChild.getPosition() != 0) {
                    int start = firstChild.getPosition() - length;
                    int end = firstChild.getPosition() - 1;
                    TypeInferencer.this.requestor.acceptMethodReference(call, 0, start, end);
                }
            }
            catch (Throwable throwable) {}
            return super.processCall(node, arg);
        }

        public Object processSetElemNode(Node node, Object arg) {
            if (node.getFirstChild().getNext() instanceof Node.StringNode) {
                String objId = TypeInferencer.getObjId(node.getFirstChild());
                String fieldId = node.getFirstChild().getNext().getString();
                this.internalSetProp(node, objId, fieldId);
            } else {
                String string = String.valueOf(TypeInferencer.getObjId(node.getFirstChild())) + "[]";
                TypeInferencer.this.collection.write(string, TypeInferencer.this.evaluateReference(string, node.getLastChild(), TypeInferencer.this.cs));
            }
            return arg;
        }

        public Object processSwitch(Node node, Object arg) {
            Object processScriptNode = this.processScriptNode(node, arg);
            return processScriptNode;
        }

        public Object processBlock(Node node, Object arg) {
            Node nm = node.getFirstChild();
            if (nm instanceof Node.Jump) {
                Node.Jump jm = (Node.Jump)nm;
                int type = nm.getType();
                if (type == 7) {
                    return this.processIf(arg, jm);
                }
            }
            Object processScriptNode = this.processScriptNode(node, arg);
            return processScriptNode;
        }

        public Object processReturn(Node node, Object arg) {
            IReference r = TypeInferencer.this.evaluateReference(TypeInferencer.RETURN_VALUE, node.getFirstChild(), TypeInferencer.this.cs);
            TypeInferencer.this.collection.setReference(TypeInferencer.RETURN_VALUE, r);
            return arg;
        }

        public Object processHookNode(Node node, Object arg) {
            HostCollection root = TypeInferencer.this.collection;
            TypeInferencer.this.contexts.push(root);
            HostCollection ifContext = new HostCollection(root);
            HostCollection elseContext = new HostCollection(root);
            TypeInferencer.this.collection = ifContext;
            Node ifNode = node.getFirstChild().getNext();
            this.doAction(ifNode, arg);
            TypeInferencer.this.collection = elseContext;
            Node elseNode = node.getLastChild();
            this.doAction(elseNode, arg);
            TypeInferencer.this.collection = (HostCollection)TypeInferencer.this.contexts.pop();
            root.mergeElseIf(ifContext, elseContext);
            return arg;
        }

        public Object processCatchScopeNode(Node node, Object arg) {
            Node n1 = node.getFirstChild();
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection.getParent());
            String name = n1.getString();
            TypeInferencer.this.collection.setReference(name, new StandardSelfCompletingReference(name, true));
            node.getFirstChild();
            this.processScriptNode(node, arg);
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            if (node.getPosition() >= this.position) {
                throw new PositionReachedException(null);
            }
            TypeInferencer.this.collection = pop;
            return arg;
        }

        public Object processLoop(Node node, Object arg) {
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection);
            this.processScriptNode(node, arg);
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            pop.mergeIf(TypeInferencer.this.collection);
            TypeInferencer.this.collection = pop;
            return arg;
        }

        private Object processIf(Object arg, Node.Jump jm) {
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection);
            HostCollection ifCollection = null;
            Node n = jm;
            while (n != null) {
                HostCollection elseCollection;
                Node cm;
                this.doAction(n, arg);
                n = n.getNext();
                if (!(n instanceof Node.Jump) || (cm = n).getType() != 5) continue;
                HostCollection pop = (HostCollection)TypeInferencer.this.contexts.peek();
                ifCollection = TypeInferencer.this.collection;
                TypeInferencer.this.collection = elseCollection = new HostCollection(pop);
            }
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            if (ifCollection == null) {
                pop.mergeIf(TypeInferencer.this.collection);
            } else {
                pop.mergeElseIf(TypeInferencer.this.collection, ifCollection);
            }
            TypeInferencer.this.collection = pop;
            return arg;
        }

        public Object processFunction(Node node, Object arg) {
            ScriptOrFnNode oldC = this.context;
            String sn = node.getString();
            if (sn.length() > 0) {
                int a = 0;
                while (a < this.context.getFunctionCount()) {
                    FunctionNode functionNode = this.context.getFunctionNode(a);
                    String name = functionNode.getFunctionName();
                    if (name != null && name.equals(sn)) {
                        this.context = functionNode;
                        this.internalProcessFunctionNode(arg, functionNode, node);
                        break;
                    }
                    ++a;
                }
            } else {
                int index = node.getIntProp(1, -1);
                if (index >= 0 && index < this.context.getFunctionCount()) {
                    FunctionNode functionNode = this.context.getFunctionNode(index);
                    this.context = functionNode;
                    this.internalProcessFunctionNode(arg, functionNode, node);
                }
            }
            this.context = oldC;
            return null;
        }

        private void internalProcessFunctionNode(Object arg, FunctionNode functionNode, Node function) {
            if (functionNode.getEncodedSourceStart() >= this.position) {
                throw new PositionReachedException(this.context);
            }
            HostCollection parent = TypeInferencer.this.collection;
            this.functionContexts.addLast(TypeInferencer.this.collection);
            TypeInferencer.this.contexts.push(parent);
            TypeInferencer.this.collection = new HostCollection(this.functionContexts.getFirst(), functionNode.getFunctionName(), 1);
            String comment = functionNode.getFunctionComments();
            Map paramTypes = this.parseComment(comment);
            int am = 0;
            while (am < functionNode.getParamCount()) {
                String paramOrVarName = functionNode.getParamOrVarName(am);
                String type = (String)paramTypes.get(paramOrVarName);
                IReference reference = null;
                if (type != null) {
                    reference = ReferenceFactory.createTypeReference(paramOrVarName, type, TypeInferencer.this.cs);
                }
                if (reference == null) {
                    reference = new StandardSelfCompletingReference(paramOrVarName, false);
                }
                reference.setLocationInformation(new ReferenceLocation(TypeInferencer.this.module, functionNode.nameStart, functionNode.getFunctionName().length()));
                if (reference instanceof StandardSelfCompletingReference) {
                    ((StandardSelfCompletingReference)reference).setParameterIndex(am);
                }
                TypeInferencer.this.collection.write(paramOrVarName, reference);
                ++am;
            }
            this.processScriptNode(functionNode.getFirstChild(), arg);
            TypeInferencer.this.functionNodes.put(new Integer(functionNode.getEncodedSourceStart()), TypeInferencer.this.collection);
            if (functionNode.getEncodedSourceEnd() >= this.position) {
                throw new PositionReachedException(functionNode);
            }
            HostCollection pop = (HostCollection)TypeInferencer.this.contexts.pop();
            for (IReference o : TypeInferencer.this.collection.getReferences().values()) {
                IReference rf;
                if (!(o instanceof IReference) || (rf = o).isLocal() || "this".equals(rf.getName())) continue;
                pop.write(rf.getName(), rf);
            }
            pop.recordFunction(function, TypeInferencer.this.collection);
            pop.recordFunction(functionNode, TypeInferencer.this.collection);
            TypeInferencer.this.collection = pop;
            this.functionContexts.removeLast();
        }

        private Map parseComment(String comment) {
            if (comment == null) {
                return Collections.EMPTY_MAP;
            }
            HashMap<String, String> map = new HashMap<String, String>();
            int paramIndex = comment.indexOf("@param");
            while (paramIndex != -1) {
                int endLineIndex = comment.indexOf("\n", paramIndex);
                StringTokenizer st = new StringTokenizer(comment.substring(paramIndex + 6, endLineIndex));
                String type = "";
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if (token.startsWith("{") && token.endsWith("}")) {
                        type = token.substring(1, token.length() - 1);
                        continue;
                    }
                    map.put(token, type);
                    break;
                }
                paramIndex = comment.indexOf("@param", endLineIndex);
            }
            return map;
        }

        public Object processVarDeclaration(Node node, Object arg) {
            Node firstChild = node.getFirstChild();
            Object processScriptNode = this.processScriptNode(node, arg);
            while (firstChild != null) {
                String key = TypeInferencer.getKey(firstChild);
                IReference evaluateReference = TypeInferencer.this.evaluateReference(key, firstChild.getFirstChild(), TypeInferencer.this.cs);
                if (evaluateReference == null) {
                    evaluateReference = new StandardSelfCompletingReference(key, false);
                }
                evaluateReference.setLocationInformation(new ReferenceLocation(TypeInferencer.this.module, firstChild.getPosition() + 1, key.length()));
                evaluateReference.setLocal(true);
                TypeInferencer.this.collection.write(key, evaluateReference);
                firstChild = firstChild.getNext();
            }
            return processScriptNode;
        }

        public Object processSetPropNode(Node node, Object arg) {
            Node obj = node.getFirstChild();
            String objId = TypeInferencer.getObjId(obj);
            if (objId == null) {
                return null;
            }
            Node id = node.getFirstChild().getNext();
            Object processScriptNode = this.processScriptNode(node, arg);
            String fieldId = TypeInferencer.getKey(id);
            this.internalSetProp(node, objId, fieldId);
            return processScriptNode;
        }

        public Object processDelProp(Node node, Object arg) {
            Node firstChild = node.getFirstChild();
            String objId = TypeInferencer.getKey(firstChild);
            if (firstChild.getType() == 48) {
                TypeInferencer.this.collection.recordDelete(objId);
            } else {
                Node id = node.getFirstChild().getNext();
                String fieldId = TypeInferencer.getKey(id);
                IReference queryElement = TypeInferencer.this.collection.queryElement(objId, false);
                if (queryElement != null) {
                    queryElement.recordDelete(fieldId);
                }
            }
            return null;
        }

        private void internalSetProp(Node node, String objId, String fieldId) {
            IReference evaluateReference = TypeInferencer.this.evaluateReference(fieldId, node.getLastChild(), TypeInferencer.this.cs);
            int pos = objId.indexOf(46);
            String rootName = pos == -1 ? objId : objId.substring(0, pos);
            IReference root = TypeInferencer.this.collection.getReferenceNoParentContext(rootName);
            if (root == null) {
                root = new StandardSelfCompletingReference(rootName, true);
                root.setLocationInformation(new ReferenceLocation(TypeInferencer.this.module, node.getPosition(), fieldId.length()));
                HostCollection parent = TypeInferencer.this.collection.getParent();
                if (parent == null) {
                    TypeInferencer.this.collection.setReference(rootName, root);
                } else {
                    IReference rm = parent.getReference(rootName);
                    if (rm != null) {
                        rm = new CombinedOrReference(rm, root);
                        TypeInferencer.this.collection.setReference(rootName, rm);
                    } else {
                        TypeInferencer.this.collection.setReference(rootName, root);
                    }
                }
            }
            ++pos;
            while (pos != 0) {
                int p1 = objId.indexOf(46, pos);
                String field = p1 != -1 ? objId.substring(pos, p1) : objId.substring(pos);
                IReference child = root.getChild(field, false);
                if (child == null) {
                    child = new StandardSelfCompletingReference(field, true);
                    child.setLocationInformation(new ReferenceLocation(TypeInferencer.this.module, node.getPosition(), fieldId.length()));
                    root.setChild(field, child);
                }
                root = child;
                pos = p1 + 1;
            }
            TransparentRef transparentRef = new TransparentRef(TypeInferencer.this, evaluateReference, node.getLastChild(), fieldId, TypeInferencer.this.module, TypeInferencer.this.cs);
            TypeInferencer.this.collection.addTransparent(transparentRef);
            transparentRef.setLocationInformation(new ReferenceLocation(TypeInferencer.this.module, node.getPosition(), fieldId.length()));
            if (root.getName().equals("this")) {
                TypeInferencer.this.collection.add(transparentRef.getName(), transparentRef);
            }
            root.setChild(fieldId, transparentRef);
        }

        public Object processLeaveWith(Node node, Object arg) {
            if (node.getPosition() >= this.position) {
                throw new PositionReachedException(null);
            }
            if (TypeInferencer.this.withContexts.isEmpty()) {
                return arg;
            }
            IReference to = (IReference)TypeInferencer.this.withContexts.pop();
            if (to != null) {
                Map<String, IReference> mn = TypeInferencer.this.collection.getReferences();
                for (String next : mn.keySet()) {
                    to.setChild(next, mn.get(next));
                }
            }
            TypeInferencer.this.collection = (HostCollection)TypeInferencer.this.contexts.pop();
            return null;
        }

        public Object processEnterWith(Node node, Object arg) {
            Node firstChild = node.getFirstChild();
            if (!(firstChild instanceof Node.StringNode)) {
                TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
                TypeInferencer.this.withContexts.push(null);
                return arg;
            }
            TypeInferencer.this.contexts.push(TypeInferencer.this.collection);
            String name = firstChild.getString();
            IReference ref = TypeInferencer.this.collection.queryElement(name, false);
            TypeInferencer.this.withContexts.push(ref);
            TypeInferencer.this.collection = new HostCollection(TypeInferencer.this.collection);
            if (ref != null) {
                IReference r = ref.getPrototype(false);
                if (r != null) {
                    LinkedHashSet<IReference> lm = new LinkedHashSet<IReference>();
                    while (r != null && !lm.contains(r)) {
                        lm.add(r);
                        r = r.getPrototype(false);
                    }
                    ArrayList list = new ArrayList(lm);
                    Collections.reverse(list);
                    for (IReference k : list) {
                        Set<IReference> sm = k.getChilds(false);
                        for (IReference k1 : sm) {
                            TypeInferencer.this.collection.setReference(k1.getName(), k1);
                        }
                    }
                }
                Set<IReference> sm = ref.getChilds(false);
                for (IReference k : sm) {
                    TypeInferencer.this.collection.setReference(k.getName(), k);
                }
            }
            return null;
        }

        public Object processSetNameNode(Node node, Object arg) {
            String key = TypeInferencer.getKey(node.getFirstChild());
            Node lastChild = node.getLastChild();
            Object processScriptNode = this.processScriptNode(node, arg);
            IReference evaluateReference = TypeInferencer.this.evaluateReference(key, lastChild, TypeInferencer.this.cs);
            evaluateReference.setLocationInformation(new ReferenceLocation(TypeInferencer.this.module, node.getFirstChild().getPosition() - key.length(), key.length()));
            TypeInferencer.this.collection.write(key, evaluateReference);
            return processScriptNode;
        }
    }
}

