/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.javascript.typeinference;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.javascript.reference.resolvers.SelfCompletingReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReference;
import org.eclipse.dltk.internal.javascript.typeinference.IReferenceLocation;
import org.eclipse.dltk.internal.javascript.typeinference.TransparentRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombinedOrReference
implements IReference,
SelfCompletingReference {
    private final List<IReference> lstReadonly;
    private final List<IReference> lstReferences = new ArrayList<IReference>();
    private boolean recursiveCheck;
    boolean recursive = false;

    public CombinedOrReference() {
        this.lstReadonly = new ArrayList<IReference>();
    }

    private CombinedOrReference(List<IReference> references, List<IReference> readonly) {
        this();
        IReference element;
        int i = 0;
        while (i < readonly.size()) {
            element = readonly.get(i);
            this.addReadonly(element);
            ++i;
        }
        i = 0;
        while (i < references.size()) {
            element = references.get(i);
            this.addReference(element);
            ++i;
        }
    }

    public CombinedOrReference(IReference rm, IReference root) {
        this();
        this.addReadonly(rm);
        this.addReference(root);
    }

    public void addReference(IReference reference) {
        if (reference instanceof CombinedOrReference) {
            this.addCombinedReference(reference);
        } else if (!this.testContains(reference)) {
            this.lstReferences.add(reference);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean testContains(IReference reference) {
        if (reference == this) {
            return true;
        }
        if (this.recursive) {
            return true;
        }
        try {
            IReference element;
            this.recursive = true;
            int i = 0;
            while (i < this.lstReferences.size()) {
                element = this.lstReferences.get(i);
                if (element.equals(reference)) {
                    return true;
                }
                if (this.testTransparentRef(reference, element)) {
                    return true;
                }
                ++i;
            }
            i = 0;
            while (i < this.lstReadonly.size()) {
                element = this.lstReadonly.get(i);
                if (element.equals(reference)) {
                    return true;
                }
                if (this.testTransparentRef(reference, element)) {
                    return true;
                }
                ++i;
            }
            if (!this.testTransparentRef(this, reference)) return false;
            return true;
        }
        finally {
            this.recursive = false;
        }
    }

    private boolean testTransparentRef(IReference reference, Object element) {
        if (element instanceof TransparentRef) {
            CombinedOrReference cor;
            TransparentRef transparentRef = (TransparentRef)element;
            if (transparentRef.evaluateReference == reference) {
                return true;
            }
            if (transparentRef.evaluateReference instanceof CombinedOrReference && (cor = (CombinedOrReference)transparentRef.evaluateReference).testContains(this)) {
                return true;
            }
        }
        return false;
    }

    private void addCombinedReference(IReference reference) {
        CombinedOrReference cor = (CombinedOrReference)reference;
        int i = 0;
        while (i < cor.lstReferences.size()) {
            this.addReference(cor.lstReferences.get(i));
            ++i;
        }
        i = 0;
        while (i < cor.lstReadonly.size()) {
            this.addReadonly(cor.lstReadonly.get(i));
            ++i;
        }
    }

    public void addReadonly(IReference reference) {
        if (reference instanceof CombinedOrReference) {
            this.addCombinedReference(reference);
        } else if (!this.testContains(reference)) {
            this.lstReadonly.add(reference);
        }
    }

    @Override
    public void addModelElements(Collection<IModelElement> toAdd) {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            element.addModelElements(toAdd);
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            element.addModelElements(toAdd);
            ++i;
        }
    }

    @Override
    public IReference getChild(String key, boolean resolveLocals) {
        ArrayList<IReference> alReferences = new ArrayList<IReference>();
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = this.lstReferences.get(i);
            IReference child = element.getChild(key, resolveLocals);
            if (child != null && !alReferences.contains(child)) {
                alReferences.add(child);
            }
            ++i;
        }
        ArrayList<IReference> alReadonly = new ArrayList<IReference>();
        int i2 = 0;
        while (i2 < this.lstReadonly.size()) {
            IReference element = this.lstReadonly.get(i2);
            IReference child = element.getChild(key, resolveLocals);
            if (child != null && !alReadonly.contains(child)) {
                alReadonly.add(child);
            }
            ++i2;
        }
        if (alReferences.size() == 0 && alReadonly.size() == 0) {
            return null;
        }
        if (alReferences.size() == 1 && alReadonly.size() == 0) {
            return (IReference)alReferences.get(0);
        }
        if (alReferences.size() == 0 && alReadonly.size() == 1) {
            return alReadonly.get(0);
        }
        return new CombinedOrReference(alReferences, alReadonly).compressed();
    }

    private IReference compressed() {
        if (this.lstReferences.size() == 1 && this.lstReadonly.size() == 0) {
            return this.lstReferences.get(0);
        }
        if (this.lstReferences.size() == 0 && this.lstReadonly.size() == 1) {
            return this.lstReadonly.get(0);
        }
        return this;
    }

    @Override
    public Set<IReference> getChilds(boolean resolveLocals) {
        if (this.recursiveCheck) {
            return Collections.emptySet();
        }
        HashSet<IReference> set = new HashSet<IReference>();
        try {
            IReference element;
            this.recursiveCheck = true;
            int i = 0;
            while (i < this.lstReferences.size()) {
                element = this.lstReferences.get(i);
                set.addAll(element.getChilds(resolveLocals));
                ++i;
            }
            i = 0;
            while (i < this.lstReadonly.size()) {
                element = this.lstReadonly.get(i);
                set.addAll(element.getChilds(resolveLocals));
                ++i;
            }
        }
        finally {
            this.recursiveCheck = false;
        }
        return set;
    }

    @Override
    public String getName() {
        if (this.lstReferences.size() > 0) {
            return this.lstReferences.get(0).getName();
        }
        if (this.lstReadonly.size() > 0) {
            return this.lstReadonly.get(0).getName();
        }
        return null;
    }

    @Override
    public Set<String> getTypes() {
        Set<String> refTypes;
        HashSet<String> types = new HashSet<String>();
        for (IReference ref : this.lstReferences) {
            refTypes = ref.getTypes();
            if (refTypes == null) continue;
            types.addAll(refTypes);
        }
        for (IReference ref : this.lstReadonly) {
            refTypes = ref.getTypes();
            if (refTypes == null) continue;
            types.addAll(refTypes);
        }
        return types;
    }

    @Override
    public IReference getPrototype(boolean resolveLocals) {
        ArrayList<IReference> alReferences = new ArrayList<IReference>();
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = this.lstReferences.get(i);
            IReference prototype = element.getPrototype(resolveLocals);
            if (prototype != null && !alReferences.contains(prototype)) {
                alReferences.add(prototype);
            }
            ++i;
        }
        ArrayList<IReference> alReadonly = new ArrayList<IReference>();
        int i2 = 0;
        while (i2 < this.lstReadonly.size()) {
            IReference element = this.lstReadonly.get(i2);
            IReference prototype = element.getPrototype(resolveLocals);
            if (prototype != null && !alReadonly.contains(prototype)) {
                alReadonly.add(prototype);
            }
            ++i2;
        }
        if (alReferences.size() == 0 && alReadonly.size() == 0) {
            return null;
        }
        if (alReferences.size() == 1 && alReadonly.size() == 0) {
            return (IReference)alReferences.get(0);
        }
        if (alReferences.size() == 0 && alReadonly.size() == 1) {
            return alReadonly.get(0);
        }
        return new CombinedOrReference(alReferences, alReadonly).compressed();
    }

    @Override
    public boolean isChildishReference() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element.isChildishReference()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element.isChildishReference()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isFunctionRef() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element.isFunctionRef()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element.isFunctionRef()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean isLocal() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element.isLocal()) {
                return true;
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element.isLocal()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void recordDelete(String fieldId) {
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = this.lstReferences.get(i);
            element.recordDelete(fieldId);
            ++i;
        }
    }

    @Override
    public void setChild(String key, IReference ref) {
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = this.lstReferences.get(i);
            element.setChild(key, ref);
            ++i;
        }
    }

    @Override
    public void setLocal(boolean local) {
        IReference element;
        int i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            element.setLocal(local);
            ++i;
        }
        i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            element.setLocal(local);
            ++i;
        }
    }

    @Override
    public void setLocationInformation(IReferenceLocation location) {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            element.setLocationInformation(location);
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            element.setLocationInformation(location);
            ++i;
        }
    }

    @Override
    public void setPrototype(IReference ref) {
        int i = 0;
        while (i < this.lstReferences.size()) {
            IReference element = this.lstReferences.get(i);
            element.setPrototype(ref);
            ++i;
        }
    }

    public boolean contains(IReference ref) {
        return this.lstReferences.contains(ref) || this.lstReadonly.contains(ref);
    }

    @Override
    public URL getImageURL() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getImageURL() != null) {
                return ((SelfCompletingReference)element).getImageURL();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getImageURL() != null) {
                return ((SelfCompletingReference)element).getImageURL();
            }
            ++i;
        }
        return null;
    }

    @Override
    public int getKind() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getKind() != 0) {
                return ((SelfCompletingReference)element).getKind();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getKind() != 0) {
                return ((SelfCompletingReference)element).getKind();
            }
            ++i;
        }
        return 0;
    }

    @Override
    public String[] getParameterNames() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getParameterNames() != null) {
                return ((SelfCompletingReference)element).getParameterNames();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getParameterNames() != null) {
                return ((SelfCompletingReference)element).getParameterNames();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getReturnType() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getReturnType() != null) {
                return ((SelfCompletingReference)element).getReturnType();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getReturnType() != null) {
                return ((SelfCompletingReference)element).getReturnType();
            }
            ++i;
        }
        return null;
    }

    @Override
    public String getProposalInfo() {
        IReference element;
        int i = 0;
        while (i < this.lstReferences.size()) {
            element = this.lstReferences.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getProposalInfo() != null) {
                return ((SelfCompletingReference)element).getProposalInfo();
            }
            ++i;
        }
        i = 0;
        while (i < this.lstReadonly.size()) {
            element = this.lstReadonly.get(i);
            if (element instanceof SelfCompletingReference && ((SelfCompletingReference)element).getProposalInfo() != null) {
                return ((SelfCompletingReference)element).getProposalInfo();
            }
            ++i;
        }
        return null;
    }
}

