/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.ast;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.javascript.ast.Expression;

public class GetLocalNameExpression
extends Expression {
    private Expression namespace;
    private Expression localName;
    private int coloncolon = -1;

    public GetLocalNameExpression(ASTNode parent) {
        super(parent);
    }

    public void traverse(ASTVisitor visitor) throws Exception {
        if (visitor.visit((ASTNode)this)) {
            if (this.namespace != null) {
                this.namespace.traverse(visitor);
            }
            if (this.localName != null) {
                this.localName.traverse(visitor);
            }
            visitor.endvisit((ASTNode)this);
        }
    }

    public Expression getNamespace() {
        return this.namespace;
    }

    public void setNamespace(Expression object) {
        this.namespace = object;
    }

    public Expression getLocalName() {
        return this.localName;
    }

    public void setLocalName(Expression localName) {
        this.localName = localName;
    }

    public int getColonColonPosition() {
        return this.coloncolon;
    }

    public void setColonColonPosition(int coloncolon) {
        this.coloncolon = coloncolon;
    }

    public String toSourceString(String indentationString) {
        Assert.isTrue((this.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((this.sourceEnd() > 0 ? 1 : 0) != 0);
        Assert.isTrue((this.coloncolon > 0 ? 1 : 0) != 0);
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.namespace.toSourceString(indentationString));
        buffer.append("::");
        buffer.append(this.localName.toSourceString(indentationString));
        return buffer.toString();
    }
}

