/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.dltk.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclCheckContentExcludeInputDialog;
import org.eclipse.dltk.tcl.internal.ui.preferences.TclPreferencesMessages;
import org.eclipse.dltk.ui.preferences.AbstractConfigurationBlockPropertyAndPreferencePage;
import org.eclipse.dltk.ui.preferences.AbstractOptionsBlock;
import org.eclipse.dltk.ui.preferences.PreferenceKey;
import org.eclipse.dltk.ui.util.IStatusChangeListener;
import org.eclipse.dltk.ui.util.PixelConverter;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.dltk.utils.TextUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class TclCorePreferencePage
extends AbstractConfigurationBlockPropertyAndPreferencePage {
    private static int IDX_ADD = 0;
    private static int IDX_EDIT = 1;
    private static int IDX_REMOVE = 2;

    protected AbstractOptionsBlock createOptionsBlock(IStatusChangeListener newStatusChangedListener, IProject project, IWorkbenchPreferenceContainer container) {
        return new TclCorePreferenceBlock(newStatusChangedListener, project, container);
    }

    protected String getHelpId() {
        return null;
    }

    protected String getProjectHelpId() {
        return null;
    }

    protected String getNatureId() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    protected void setDescription() {
    }

    protected void setPreferenceStore() {
    }

    protected String getPreferencePageId() {
        return null;
    }

    protected String getPropertyPageId() {
        return null;
    }

    protected static class TclCorePreferenceBlock
    extends AbstractOptionsBlock {
        private static final PreferenceKey[] KEYS = new PreferenceKey[]{new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.empty_extension.local"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.empty_extension.remote"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.any_extension.local"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.any_extension.remote"), new PreferenceKey("org.eclipse.dltk.tcl.core", "check_content.excludes")};
        private ListDialogField excludeDialog;

        protected void initialize() {
            super.initialize();
            this.initExcludePatterns();
        }

        public void performDefaults() {
            super.performDefaults();
            this.initExcludePatterns();
        }

        private void initExcludePatterns() {
            ArrayList excludePatterns = new ArrayList();
            String[] patterns = TextUtils.split((String)this.getString(KEYS[4]), (char)';');
            if (patterns != null) {
                excludePatterns.addAll(Arrays.asList(patterns));
            }
            this.excludeDialog.setElements(excludePatterns);
        }

        private void updateExcludes() {
            this.setString(KEYS[4], TextUtils.join((Collection)this.excludeDialog.getElements(), (char)';'));
        }

        public TclCorePreferenceBlock(IStatusChangeListener context, IProject project, IWorkbenchPreferenceContainer container) {
            super(context, project, KEYS, container);
        }

        private void createCheckbox(Composite block, String label, PreferenceKey key) {
            Button checkButton = SWTFactory.createCheckButton((Composite)block, (String)label);
            GridData data = new GridData();
            data.horizontalIndent = 16;
            checkButton.setLayoutData((Object)data);
            this.bindControl(checkButton, key, null);
        }

        protected Control createOptionsBlock(Composite parent) {
            Composite block = SWTFactory.createComposite((Composite)parent, (Font)parent.getFont(), (int)1, (int)1, (int)1808);
            SWTFactory.createLabel((Composite)block, (String)TclPreferencesMessages.TclCorePreferencePage_checkContentWithoutExtension, (int)1);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_local, KEYS[0]);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_remote, KEYS[1]);
            SWTFactory.createLabel((Composite)block, (String)TclPreferencesMessages.TclCorePreferencePage_checkContentAnyExtension, (int)1);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_local, KEYS[2]);
            this.createCheckbox(block, TclPreferencesMessages.TclCorePreferencePage_remote, KEYS[3]);
            SWTFactory.createLabel((Composite)block, (String)TclPreferencesMessages.TclCorePreferencePage_checkContentExcludes, (int)1);
            Composite excludeComposite = SWTFactory.createComposite((Composite)block, (Font)block.getFont(), (int)1, (int)1, (int)1808);
            GridLayout excludeLayout = new GridLayout();
            excludeLayout.numColumns = 2;
            excludeComposite.setLayout((Layout)excludeLayout);
            TclCheckContentAdapter adapter = new TclCheckContentAdapter();
            String[] buttons = new String[]{TclPreferencesMessages.TclCorePreferencePage_checkContentAddExclude, TclPreferencesMessages.TclCorePreferencePage_checkContentEditExclude, TclPreferencesMessages.TclCorePreferencePage_checkContentRemoveExclude};
            this.excludeDialog = new ListDialogField((IListAdapter)adapter, buttons, (ILabelProvider)new LabelProvider());
            this.excludeDialog.setDialogFieldListener((IDialogFieldListener)adapter);
            this.excludeDialog.setRemoveButtonIndex(IDX_REMOVE);
            this.excludeDialog.setViewerSorter(new ViewerSorter());
            Control listControl = this.excludeDialog.getListControl(excludeComposite);
            GridData listControlLayoutData = new GridData(1808);
            listControlLayoutData.heightHint = new PixelConverter(listControl).convertHeightInCharsToPixels(6);
            listControl.setLayoutData((Object)listControlLayoutData);
            this.excludeDialog.getButtonBox(excludeComposite).setLayoutData((Object)new GridData(258));
            return block;
        }

        private class TclCheckContentAdapter
        implements IListAdapter,
        IDialogFieldListener {
            private TclCheckContentAdapter() {
            }

            public void customButtonPressed(ListDialogField field, int index) {
                TclCheckContentExcludeInputDialog dialog;
                String edited = null;
                if (index != IDX_ADD) {
                    edited = (String)field.getSelectedElements().get(0);
                }
                if ((index == IDX_ADD || index == IDX_EDIT) && (dialog = new TclCheckContentExcludeInputDialog(TclCorePreferenceBlock.this.getShell(), edited, field.getElements())).open() == 0) {
                    if (edited != null) {
                        field.replaceElement((Object)edited, (Object)dialog.getResult());
                    } else {
                        field.addElement((Object)dialog.getResult());
                    }
                }
            }

            private boolean canEdit(List selectedElements) {
                return selectedElements.size() == 1;
            }

            public void doubleClicked(ListDialogField field) {
                if (this.canEdit(field.getSelectedElements())) {
                    this.customButtonPressed(field, IDX_EDIT);
                }
            }

            public void selectionChanged(ListDialogField field) {
                List selectedElements = field.getSelectedElements();
                field.enableButton(IDX_EDIT, this.canEdit(selectedElements));
            }

            public void dialogFieldChanged(DialogField field) {
                TclCorePreferenceBlock.this.updateExcludes();
            }
        }
    }
}

