/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.debug.ui.interpreters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.debug.ui.launchConfigurations.IMainLaunchConfigurationTabListenerManager;
import org.eclipse.dltk.internal.debug.ui.interpreters.AbstractInterpreterComboBlock;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.InterpreterContainerHelper;
import org.eclipse.dltk.launching.ScriptRuntime;
import org.eclipse.dltk.tcl.core.TclPackagesManager;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class TclInterpreterComboBlock
extends AbstractInterpreterComboBlock {
    private Set<String> packages = new HashSet<String>();
    private Set<String> autoPackages = new HashSet<String>();
    private TreeViewer fElements;
    private IScriptProject scriptProject;
    private Button addButton;
    private Button addAllButton;

    protected TclInterpreterComboBlock(IMainLaunchConfigurationTabListenerManager tab) {
        super(tab);
    }

    protected void showInterpreterPreferencePage() {
        this.showPrefPage("org.eclipse.dltk.tcl.preferences.interpreters");
    }

    protected String getCurrentLanguageNature() {
        return "org.eclipse.dltk.tcl.core.nature";
    }

    public void createControl(Composite ancestor) {
        super.createControl(ancestor);
        Composite mainComposite = (Composite)this.getControl();
        Composite composite = new Composite(mainComposite, 0);
        GridData compositeData = new GridData(4, 4, true, true);
        compositeData.horizontalSpan = ((GridLayout)mainComposite.getLayout()).numColumns;
        composite.setLayoutData((Object)compositeData);
        GridLayout gridLayout = new GridLayout(2, false);
        composite.setLayout((Layout)gridLayout);
        this.fElements = new TreeViewer(composite);
        GridData data = new GridData(4, 4, true, true);
        this.fElements.getTree().setLayoutData((Object)data);
        Composite buttons = new Composite(composite, 0);
        GridData data2 = new GridData(4, 4, false, false);
        buttons.setLayoutData((Object)data2);
        GridLayout gridLayout2 = new GridLayout(1, true);
        buttons.setLayout((Layout)gridLayout2);
        this.addButton = new Button(buttons, 8);
        data2 = new GridData(4, 4, false, false);
        this.addButton.setLayoutData((Object)data2);
        this.addButton.setText("Add");
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclInterpreterComboBlock.this.addPackage();
            }
        });
        this.addAllButton = new Button(buttons, 8);
        data2 = new GridData(4, 4, false, false);
        this.addAllButton.setLayoutData((Object)data2);
        this.addAllButton.setText("Add all");
        this.addAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclInterpreterComboBlock.this.addAllPackages();
            }
        });
        final Button remove = new Button(buttons, 8);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TclInterpreterComboBlock.this.removePackage();
            }
        });
        remove.setText("Remove");
        remove.setLayoutData((Object)data2);
        this.fElements.setContentProvider((IContentProvider)new PackagesContentProvider());
        this.fElements.setLabelProvider((IBaseLabelProvider)new PackagesLabelProvider());
        this.fElements.setInput(this.packages);
        this.fElements.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)selection;
                    remove.setEnabled(!sel.isEmpty());
                }
            }
        });
        this.fElements.setComparator(new ViewerComparator());
        remove.setEnabled(false);
        this.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("PROPERTY_INTERPRETER")) {
                    TclInterpreterComboBlock.this.refreshView();
                }
            }
        });
    }

    protected void removePackage() {
        ISelection selection = this.fElements.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)selection;
            boolean update = false;
            for (String pkg : sel) {
                boolean res = this.packages.remove(pkg);
                if (!res) continue;
                update = res;
            }
            if (update) {
                this.refreshView();
            }
        }
    }

    private void refreshView() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IInterpreterInstall install;
                block3: {
                    TclInterpreterComboBlock.this.fElements.refresh();
                    install = TclInterpreterComboBlock.this.getInterpreter();
                    if (install == null) {
                        try {
                            install = ScriptRuntime.getInterpreterInstall((IScriptProject)TclInterpreterComboBlock.this.scriptProject);
                        }
                        catch (CoreException e) {
                            if (!DLTKCore.DEBUG) break block3;
                            e.printStackTrace();
                        }
                    }
                }
                TclInterpreterComboBlock.this.addButton.setEnabled(install != null);
            }
        });
    }

    protected void addPackage() {
        IInterpreterInstall install = null;
        install = this.getInterpreter();
        if (install == null) {
            install = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry("org.eclipse.dltk.tcl.core.nature", "org.eclipse.dltk.core.environment.localEnvironment"));
        }
        if (install != null) {
            Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
            final ArrayList names = new ArrayList();
            names.addAll(packages);
            Collections.sort(names, String.CASE_INSENSITIVE_ORDER);
            ListDialog dialog = new ListDialog(this.fElements.getControl().getShell());
            dialog.setTitle("Add Packages");
            dialog.setContentProvider(new IStructuredContentProvider(){

                public Object[] getElements(Object inputElement) {
                    return names.toArray();
                }

                public void dispose() {
                }

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }
            });
            dialog.setLabelProvider((ILabelProvider)new PackagesLabelProvider());
            dialog.setInput(names);
            if (dialog.open() == 0) {
                Object[] result = dialog.getResult();
                int i = 0;
                while (i < result.length) {
                    String pkg = (String)result[i];
                    this.packages.add(pkg);
                    ++i;
                }
                this.refreshView();
            }
        } else {
            MessageBox box = new MessageBox(this.fElements.getControl().getShell(), 65576);
            box.setText("Packages");
            box.setMessage("Project interpreter could not be found...");
            box.open();
        }
    }

    protected void addAllPackages() {
        IInterpreterInstall install;
        block4: {
            install = null;
            try {
                install = ScriptRuntime.getInterpreterInstall((IScriptProject)this.scriptProject);
            }
            catch (CoreException e) {
                if (!DLTKCore.DEBUG) break block4;
                e.printStackTrace();
            }
        }
        if (install != null) {
            Set packages = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install);
            this.packages.addAll(packages);
            this.refreshView();
        } else {
            MessageBox box = new MessageBox(this.fElements.getControl().getShell(), 65570);
            box.setText("Packages");
            box.setText("Project interpreter could not be found...");
            box.open();
        }
    }

    public void initialize(IScriptProject project, IBuildpathEntry[] currentEntries) {
        this.scriptProject = project;
        HashSet set = new HashSet();
        HashSet autoSet = new HashSet();
        InterpreterContainerHelper.getInterpreterContainerDependencies((IScriptProject)project, set, autoSet);
        this.packages.addAll(set);
        this.autoPackages.addAll(autoSet);
    }

    public IBuildpathEntry getEntry() {
        IBuildpathEntry createPackagesContainer = InterpreterContainerHelper.createPackagesContainer(this.packages, this.autoPackages, (IPath)this.getInterpreterPath());
        return createPackagesContainer;
    }

    private static class PackagesContentProvider
    implements ITreeContentProvider {
        private PackagesContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof Set) {
                return this.getElements(parentElement);
            }
            return CharOperation.NO_STRINGS;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof Set) {
                return ((Set)inputElement).toArray();
            }
            return CharOperation.NO_STRINGS;
        }
    }

    public class PackagesLabelProvider
    extends LabelProvider {
        public Image getImage(Object element) {
            if (element instanceof String) {
                Set names;
                String packageName = (String)element;
                IInterpreterInstall install = TclInterpreterComboBlock.this.getInterpreter();
                if (install == null) {
                    install = ScriptRuntime.getDefaultInterpreterInstall((ScriptRuntime.DefaultInterpreterEntry)new ScriptRuntime.DefaultInterpreterEntry("org.eclipse.dltk.tcl.core.nature", "org.eclipse.dltk.core.environment.localEnvironment"));
                }
                if (install != null && !(names = TclPackagesManager.getPackageInfosAsString((IInterpreterInstall)install)).contains(packageName)) {
                    return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.error_obj.gif");
                }
            }
            return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.package_obj.gif");
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return (String)element;
            }
            return super.getText(element);
        }
    }
}

