/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.formatter.preferences;

import java.net.URL;
import org.eclipse.dltk.ruby.formatter.preferences.Messages;
import org.eclipse.dltk.ui.formatter.FormatterModifyTabPage;
import org.eclipse.dltk.ui.formatter.IFormatterControlManager;
import org.eclipse.dltk.ui.formatter.IFormatterModifyDialog;
import org.eclipse.dltk.ui.preferences.FormatterMessages;
import org.eclipse.dltk.ui.util.SWTFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class RubyFormatterIndentationTabPage
extends FormatterModifyTabPage {
    private Combo tabPolicy;
    private Text indentSize;
    private Text tabSize;
    private final String[] tabPolicyItems = new String[]{"space", "tab", "mixed"};
    private TabPolicyListener tabPolicyListener;

    public RubyFormatterIndentationTabPage(IFormatterModifyDialog dialog) {
        super(dialog);
    }

    protected void createOptions(IFormatterControlManager manager, Composite parent) {
        Group tabPolicyGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.RubyFormatterIndentationTabPage_generalSettings, (int)2, (int)1, (int)768);
        this.tabPolicy = manager.createCombo((Composite)tabPolicyGroup, (Object)"formatter.tabulation.char", FormatterMessages.IndentationTabPage_general_group_option_tab_policy, this.tabPolicyItems, new String[]{FormatterMessages.IndentationTabPage_general_group_option_tab_policy_SPACE, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_TAB, FormatterMessages.IndentationTabPage_general_group_option_tab_policy_MIXED});
        this.tabPolicyListener = new TabPolicyListener(manager);
        this.tabPolicy.addSelectionListener((SelectionListener)this.tabPolicyListener);
        manager.addInitializeListener((IFormatterControlManager.IInitializeListener)this.tabPolicyListener);
        this.indentSize = manager.createNumber((Composite)tabPolicyGroup, (Object)"formatter.indentation.size", FormatterMessages.IndentationTabPage_general_group_option_indent_size);
        this.tabSize = manager.createNumber((Composite)tabPolicyGroup, (Object)"formatter.tabulation.size", FormatterMessages.IndentationTabPage_general_group_option_tab_size);
        this.tabSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean tabMode;
                int index = RubyFormatterIndentationTabPage.this.tabPolicy.getSelectionIndex();
                if (index >= 0 && (tabMode = "tab".equals(RubyFormatterIndentationTabPage.this.tabPolicyItems[index]))) {
                    RubyFormatterIndentationTabPage.this.indentSize.setText(RubyFormatterIndentationTabPage.this.tabSize.getText());
                }
            }
        });
        Group indentGroup = SWTFactory.createGroup((Composite)parent, (String)Messages.RubyFormatterIndentationTabPage_indentWithinDefinitions, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentGroup, (Object)"indent.class", Messages.RubyFormatterIndentationTabPage_declarationsWithinClassBody);
        manager.createCheckbox((Composite)indentGroup, (Object)"indent.module", Messages.RubyFormatterIndentationTabPage_declarationsWithinModuleBody);
        manager.createCheckbox((Composite)indentGroup, (Object)"indent.method", Messages.RubyFormatterIndentationTabPage_statementsWithinMethodBody);
        Group indentBlocks = SWTFactory.createGroup((Composite)parent, (String)Messages.RubyFormatterIndentationTabPage_indentWithinBlocks, (int)1, (int)1, (int)768);
        manager.createCheckbox((Composite)indentBlocks, (Object)"indent.blocks", Messages.RubyFormatterIndentationTabPage_statementsWithinBlockBody);
        manager.createCheckbox((Composite)indentBlocks, (Object)"indent.if", Messages.RubyFormatterIndentationTabPage_statementsWithinIfBody);
        manager.createCheckbox((Composite)indentBlocks, (Object)"indent.case", Messages.RubyFormatterIndentationTabPage_statementsWithinCaseBody);
        manager.createCheckbox((Composite)indentBlocks, (Object)"indent.when", Messages.RubyFormatterIndentationTabPage_StatementsWithinWhenBody);
    }

    protected URL getPreviewContent() {
        return ((Object)((Object)this)).getClass().getResource("indentation-preview.rb");
    }

    private class TabPolicyListener
    extends SelectionAdapter
    implements IFormatterControlManager.IInitializeListener {
        private final IFormatterControlManager manager;

        public TabPolicyListener(IFormatterControlManager manager) {
            this.manager = manager;
        }

        public void widgetSelected(SelectionEvent e) {
            int index = RubyFormatterIndentationTabPage.this.tabPolicy.getSelectionIndex();
            if (index >= 0) {
                boolean tabMode = "tab".equals(RubyFormatterIndentationTabPage.this.tabPolicyItems[index]);
                this.manager.enableControl((Control)RubyFormatterIndentationTabPage.this.indentSize, !tabMode);
            }
        }

        public void initialize() {
            boolean tabMode = "tab".equals(this.manager.getString((Object)"formatter.tabulation.char"));
            this.manager.enableControl((Control)RubyFormatterIndentationTabPage.this.indentSize, !tabMode);
        }
    }
}

