/*******************************************************************************
 * Copyright (c) 2009 xored software, Inc.  
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html  
 *
 * Contributors:
 *     xored software, Inc. - initial API and Implementation (Vladimir Belov)
 *******************************************************************************/

package org.eclipse.dltk.javascript.ast;

import java.util.List;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;

public class StatementList extends Statement {

	private List statements;

	public StatementList(ASTNode parent) {
		super(parent);
	}

	public List getStatementList() {
		return this.statements;
	}

	public void setStatementList(List statements) {
		this.statements = statements;
	}

	public String toSourceString(String indentationString) {

		Assert.isTrue(statements.size() == 0 || sourceStart() > 0);
		Assert.isTrue(statements.size() == 0 || sourceEnd() > 0);

		StringBuffer buffer = new StringBuffer();

		for (int i = 0; i < statements.size(); i++) {
			buffer.append(((ISourceable) statements.get(i))
					.toSourceString(indentationString));
		}

		return buffer.toString();
	}

	public boolean isBlock() {
		return true;
	}
}
