/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.validators.internal.ui.popup.actions;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.dltk.validators.core.ValidatorRuntime;
import org.eclipse.dltk.validators.internal.core.ValidatorUtils;
import org.eclipse.dltk.validators.internal.ui.ValidatorConsoleTrackerManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.IPatternMatchListener;

public class ValidatorSelectionWithConsoleAction
implements IObjectActionDelegate {
    public static final String DLTK_VALIDATORS_CONSOLE = "DLTK Validators output";
    ISelection selection;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        IConsoleManager consoleManager = ConsolePlugin.getDefault().getConsoleManager();
        IOConsole ioConsole = new IOConsole(DLTK_VALIDATORS_CONSOLE, null);
        IPatternMatchListener[] listeners = ValidatorConsoleTrackerManager.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ioConsole.addPatternMatchListener(listeners[i]);
            ++i;
        }
        consoleManager.addConsoles(new IConsole[]{ioConsole});
        consoleManager.showConsoleView((IConsole)ioConsole);
        IOConsoleOutputStream newOutputStream = ioConsole.newOutputStream();
        if (this.selection == null) {
            return;
        }
        this.processSelectionToElements((OutputStream)newOutputStream, this.selection);
        try {
            newOutputStream.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void processSelectionToElements(OutputStream out, ISelection selection) {
        ArrayList elements = new ArrayList();
        ArrayList resources = new ArrayList();
        if (this.selection != null && this.selection instanceof IStructuredSelection) {
            IStructuredSelection sel = (IStructuredSelection)this.selection;
            Iterator iterator = sel.iterator();
            while (iterator.hasNext()) {
                Object o = iterator.next();
                ValidatorUtils.processResourcesToElements(o, elements, resources);
            }
        }
        ValidatorRuntime.executeAllValidatorsWithConsole((OutputStream)out, elements, resources);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }
}

