/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.LaunchingMessages;

public abstract class AbstractInterpreterRunner
implements IInterpreterRunner {
    private IInterpreterInstall interpreterInstall;

    protected IInterpreterInstall getInstall() {
        return this.interpreterInstall;
    }

    protected String constructProgramString() throws CoreException {
        File exe = this.interpreterInstall.getInstallLocation();
        if (exe == null) {
            this.abort(MessageFormat.format((String)LaunchingMessages.StandardInterpreterRunner_Unable_to_locate_executable_for, (Object[])new String[]{this.interpreterInstall.getName()}), null, 100);
        }
        return exe.getAbsolutePath();
    }

    public static String renderProcessLabel(String[] commandLine) {
        String format = LaunchingMessages.StandardInterpreterRunner;
        String timestamp = DateFormat.getDateTimeInstance((int)2, (int)2).format(new Date(System.currentTimeMillis()));
        return MessageFormat.format((String)format, (Object[])new String[]{commandLine[0], timestamp});
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            buf.append(' ');
            char[] characters = commandLine[i].toCharArray();
            StringBuffer command = new StringBuffer();
            boolean containsSpace = false;
            int j = 0;
            while (j < characters.length) {
                char character = characters[j];
                if (character == '\"') {
                    command.append('\\');
                } else if (character == ' ') {
                    containsSpace = true;
                }
                command.append(character);
                ++j;
            }
            if (containsSpace) {
                buf.append('\"');
                buf.append(command.toString());
                buf.append('\"');
            } else {
                buf.append(command.toString());
            }
            ++i;
        }
        return buf.toString();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        this.abort(this.getPluginId(), message, exception, code);
    }

    protected void abort(String pluginId, String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, pluginId, code, message, exception));
    }

    protected Process exec(String[] cmdLine, File workingDirectory) throws CoreException {
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory);
    }

    protected Process exec(String[] cmdLine, File workingDirectory, String[] envp) throws CoreException {
        return DebugPlugin.exec((String[])cmdLine, (File)workingDirectory, (String[])envp);
    }

    protected Map getDefaultProcessMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(IProcess.ATTR_PROCESS_TYPE, this.getProcessType());
        return map;
    }

    protected String getProcessType() {
        return "script";
    }

    protected AbstractInterpreterRunner(IInterpreterInstall install) {
        this.interpreterInstall = install;
    }

    protected IProcess newProcess(ILaunch launch, Process p, String label, Map attributes) throws CoreException {
        IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)label, (Map)attributes);
        if (process == null) {
            p.destroy();
            this.abort(LaunchingMessages.AbstractInterpreterRunner_0, null, 100);
        }
        return process;
    }

    protected void rawRun(ILaunch launch, String[] cmdLine, File workingDirectory, String[] environment) throws CoreException {
        Process p = this.exec(cmdLine, workingDirectory, environment);
        if (p == null) {
            return;
        }
        String cmdLineLabel = AbstractInterpreterRunner.renderCommandLine(cmdLine);
        String processLabel = AbstractInterpreterRunner.renderProcessLabel(cmdLine);
        launch.setAttribute("org.eclipse.dltk.launching.LAUNCH_COMMAND_LINE", cmdLineLabel);
        IProcess process = this.newProcess(launch, p, processLabel, this.getDefaultProcessMap());
        process.setAttribute(IProcess.ATTR_CMDLINE, cmdLineLabel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            block10: {
                block9: {
                    block8: {
                        monitor.beginTask("Launching...", 5);
                        if (!monitor.isCanceled()) break block8;
                        break block9;
                    }
                    monitor.subTask("Getting interpreter args");
                    String[] interpreterArgs = this.interpreterInstall.getInterpreterArguments();
                    if (interpreterArgs != null) {
                        config.addInterpreterArgs(interpreterArgs);
                    }
                    if (!monitor.isCanceled()) break block10;
                }
                Object var5_4 = null;
                monitor.done();
                return;
            }
            monitor.worked(1);
            monitor.subTask("Running");
            this.rawRun(launch, config.renderCommandLine(this.constructProgramString()), config.getWorkingDirectory(), config.getEnvironmentAsStrings());
            monitor.worked(4);
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected abstract String getPluginId();
}

