/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ti;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.evaluation.types.UnknownType;
import org.eclipse.dltk.ti.ITypeInferencer;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class DLTKTypeInferenceEngine
implements ITypeInferencer {
    private static final String NATURE = "nature";
    private static final String TYPE_EVALUATORS = "org.eclipse.dltk.core.typeEvaluators";
    private static final Map evaluatorsByNatures = new HashMap();

    static {
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(TYPE_EVALUATORS);
        IExtension[] ext = extensionPoint.getExtensions();
        int a = 0;
        while (a < ext.length) {
            IConfigurationElement[] elements = ext[a].getConfigurationElements();
            IConfigurationElement myElement = elements[0];
            try {
                String nature = myElement.getAttribute(NATURE);
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)evaluatorsByNatures.get(nature);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    evaluatorsByNatures.put(nature, list);
                }
                list.add(myElement);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++a;
        }
    }

    public IEvaluatedType evaluateType(AbstractTypeGoal goal, int time) {
        String nature = goal.getContext().getLangNature();
        List list = (List)evaluatorsByNatures.get(nature);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ITypeInferencer ti;
                IConfigurationElement element = (IConfigurationElement)iterator.next();
                try {
                    ti = (ITypeInferencer)element.createExecutableExtension("evaluator");
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    continue;
                }
                System.out.println();
                IEvaluatedType type = ti.evaluateType(goal, time);
                if (type == null || type instanceof UnknownType) continue;
                return type;
            }
        }
        return null;
    }
}

