/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.dltk.compiler.CharOperation;
import org.eclipse.dltk.compiler.env.lookup.Scope;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.IBuildpathEntry;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.internal.compiler.lookup.TypeScope;
import org.eclipse.dltk.internal.core.Model;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.ProjectFragment;
import org.eclipse.dltk.internal.core.ScriptProject;
import org.eclipse.dltk.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.dltk.internal.core.util.Util;

public class HandleFactory {
    private String lastPkgFragmentRootPath;
    private IProjectFragment lastPkgFragmentRoot;
    private HashtableOfArrayToObject packageHandles;
    private Model model = ModelManager.getModelManager().getModel();

    public Openable createOpenable(String resourcePath, IDLTKSearchScope scope) {
        Object[] pkgName;
        String[] simpleNames;
        int length;
        int separatorIndex = resourcePath.indexOf("|");
        if (separatorIndex > -1) {
            Object[] pkgName2;
            String classFilePath;
            String[] simpleNames2;
            int length2;
            int rootPathLength;
            if (this.lastPkgFragmentRootPath == null || (rootPathLength = this.lastPkgFragmentRootPath.length()) != resourcePath.length() || !resourcePath.regionMatches(0, this.lastPkgFragmentRootPath, 0, rootPathLength)) {
                String archivePath = resourcePath.substring(0, separatorIndex);
                IProjectFragment root = this.getArchiveProjectFragment(archivePath, scope);
                if (root == null) {
                    return null;
                }
                this.lastPkgFragmentRootPath = archivePath;
                this.lastPkgFragmentRoot = root;
                this.packageHandles = new HashtableOfArrayToObject(5);
            }
            if ((length2 = (simpleNames2 = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
                pkgName2 = new String[length2];
                System.arraycopy(simpleNames2, 0, pkgName2, 0, length2);
            } else {
                pkgName2 = CharOperation.NO_STRINGS;
            }
            IScriptFolder pkgFragment = (IScriptFolder)this.packageHandles.get(pkgName2);
            if (pkgFragment == null) {
                pkgFragment = ((ProjectFragment)this.lastPkgFragmentRoot).getScriptFolder(this.toPath((String[])pkgName2));
                this.packageHandles.put(pkgName2, pkgFragment);
            }
            ISourceModule classFile = pkgFragment.getSourceModule(simpleNames2[length2]);
            return (Openable)((Object)classFile);
        }
        int rootPathLength = -1;
        if (this.lastPkgFragmentRootPath == null || !resourcePath.startsWith(this.lastPkgFragmentRootPath) || (rootPathLength = this.lastPkgFragmentRootPath.length()) <= 0 || resourcePath.charAt(rootPathLength) != '/') {
            IProjectFragment root = this.getProjectFragment(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.getPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IScriptFolder pkgFragment = (IScriptFolder)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((ProjectFragment)this.lastPkgFragmentRoot).getScriptFolder(this.toPath((String[])pkgName));
            this.packageHandles.put(pkgName, pkgFragment);
        }
        String simpleName = simpleNames[length];
        ISourceModule unit = pkgFragment.getSourceModule(simpleName);
        return (Openable)((Object)unit);
    }

    private IPath toPath(String[] pkgName) {
        Path path = new Path("");
        int i = 0;
        while (i < pkgName.length) {
            path = path.append(pkgName[i]);
            ++i;
        }
        return path;
    }

    public IModelElement createElement(TypeScope scope, ISourceModule unit, HashSet existingElements, HashMap knownScopes) {
        return this.createElement(scope, scope.referenceContext.sourceStart(), unit, existingElements, knownScopes);
    }

    private IModelElement createElement(Scope scope, int elementPosition, ISourceModule unit, HashSet existingElements, HashMap knownScopes) {
        if (DLTKCore.DEBUG) {
            System.err.println("TODO: HandleFactory: Add implementation...");
        }
        return null;
    }

    private IProjectFragment getArchiveProjectFragment(String archivePathString, IDLTKSearchScope scope) {
        IScriptProject[] projects;
        Path archivePath = new Path(archivePathString);
        Object target = Model.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)archivePath, false);
        if (target instanceof IFile) {
            IFile archiveFile = (IFile)target;
            ScriptProject scriptProject = (ScriptProject)this.model.getScriptProject((IResource)archiveFile);
            try {
                IBuildpathEntry[] classpathEntries = scriptProject.getResolvedBuildpath();
                int j = 0;
                int entryCount = classpathEntries.length;
                while (j < entryCount) {
                    if (classpathEntries[j].getPath().equals((Object)archivePath)) {
                        return scriptProject.getProjectFragment((IResource)archiveFile);
                    }
                    ++j;
                }
            }
            catch (ModelException modelException) {}
        }
        if (scope != null) {
            IProjectFragment root;
            IPath[] enclosingProjectsAndArchives = scope.enclosingProjectsAndZips();
            int length = enclosingProjectsAndArchives.length;
            projects = new IScriptProject[length];
            int index = 0;
            int i = 0;
            while (i < length) {
                IPath path = enclosingProjectsAndArchives[i];
                if (!org.eclipse.dltk.compiler.util.Util.isArchiveFileName(path.lastSegment())) {
                    projects[index++] = this.model.getScriptProject(path.segment(0));
                }
                ++i;
            }
            if (index < length) {
                IScriptProject[] iScriptProjectArray = projects;
                projects = new IScriptProject[index];
                System.arraycopy(iScriptProjectArray, 0, projects, 0, index);
            }
            if ((root = this.getArchiveFolder((IPath)archivePath, target, projects)) != null) {
                return root;
            }
        }
        try {
            projects = this.model.getScriptProjects();
        }
        catch (ModelException modelException) {
            return null;
        }
        return this.getArchiveFolder((IPath)archivePath, target, projects);
    }

    private IProjectFragment getArchiveFolder(IPath archivePath, Object target, IScriptProject[] projects) {
        int i = 0;
        int projectCount = projects.length;
        while (i < projectCount) {
            try {
                ScriptProject scriptProject = (ScriptProject)projects[i];
                IBuildpathEntry[] classpathEntries = scriptProject.getResolvedBuildpath(true, false, false);
                int j = 0;
                int entryCount = classpathEntries.length;
                while (j < entryCount) {
                    if (classpathEntries[j].getPath().equals((Object)archivePath)) {
                        if (target instanceof IFile) {
                            return scriptProject.getProjectFragment((IResource)((IFile)target));
                        }
                        return scriptProject.getProjectFragment0(archivePath);
                    }
                    ++j;
                }
            }
            catch (ModelException modelException) {}
            ++i;
        }
        return null;
    }

    private IProjectFragment getProjectFragment(String pathString) {
        Path path = new Path(pathString);
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        int max = projects.length;
        while (i < max) {
            try {
                IProject project = projects[i];
                if (project.isAccessible() && DLTKLanguageManager.hasScriptNature(project)) {
                    IScriptProject scriptProject = this.model.getScriptProject((IResource)project);
                    IProjectFragment[] roots = scriptProject.getProjectFragments();
                    int j = 0;
                    int rootCount = roots.length;
                    while (j < rootCount) {
                        ProjectFragment root = (ProjectFragment)roots[j];
                        if (root.getPath().isPrefixOf((IPath)path) && !Util.isExcluded((IPath)path, root.fullInclusionPatternChars(), root.fullExclusionPatternChars(), false)) {
                            return root;
                        }
                        ++j;
                    }
                }
            }
            catch (CoreException coreException) {}
            ++i;
        }
        return null;
    }
}

