/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.launching;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dltk.internal.launching.AbstractInterpreterInstallType;
import org.eclipse.dltk.internal.launching.InterpreterMessages;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterInstallType;
import org.eclipse.dltk.ruby.internal.launching.RubyGenericInstall;
import org.eclipse.dltk.ruby.launching.RubyLaunchingPlugin;
import org.osgi.framework.Bundle;

public class RubyGenericInstallType
extends AbstractInterpreterInstallType {
    private static String[] interpreterNames = new String[]{"ruby"};

    public String getNatureId() {
        return "org.eclipse.dltk.ruby.core.nature";
    }

    public String getName() {
        return "Generic Ruby install";
    }

    protected String getPluginId() {
        return "org.eclipse.dltk.ruby.launching";
    }

    protected String[] getPossibleInterpreterNames() {
        return interpreterNames;
    }

    protected IInterpreterInstall doCreateInterpreterInstall(String id) {
        return new RubyGenericInstall((IInterpreterInstallType)this, id);
    }

    protected File createPathFile() throws IOException {
        Bundle bundle = RubyLaunchingPlugin.getDefault().getBundle();
        return this.storeToMetadata(bundle, "path.rb", "scripts/path.rb");
    }

    protected String getBuildPathDelimeter() {
        return ";:";
    }

    public IStatus validateInstallLocation(File installLocation) {
        if (!installLocation.exists() || !installLocation.isFile() || installLocation.isHidden()) {
            return this.createStatus(4, InterpreterMessages.errNonExistentOrInvalidInstallLocation, null);
        }
        String name = installLocation.getName();
        if (Platform.getOS().equals("win32") && name.equals("jruby.bat")) {
            return this.createStatus(0, "", null);
        }
        return super.validateInstallLocation(installLocation);
    }

    protected ILog getLog() {
        return RubyLaunchingPlugin.getDefault().getLog();
    }
}

