/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.lowvision.eval;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import org.eclipse.actf.ui.util.DialogSave;
import org.eclipse.actf.util.FileUtils;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineData;
import org.eclipse.actf.visualization.eval.problem.IProblemConst;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.eval.problem.IProblemItemImage;
import org.eclipse.actf.visualization.lowvision.ui.internal.Messages;
import org.eclipse.actf.visualization.lowvision.util.LowVisionVizResourceUtil;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SaveReportLowVision {
    private static final String UNDERSCORE = "_";
    private static final String LVIMG_FILE = "lvimg.bmp";
    private static final String RESULT_BMP_FILE = "result.bmp";
    private static final String[] ERROR_IMAGE_ALT = new String[]{Messages.SaveReportLowVision_Iro21_Error_Alt, Messages.SaveReportLowVision_Boke21_Error_Alt};
    private Shell shell;
    private String saveFileName;
    private List<IProblemItem> problemList;
    private String currentUrlS;
    private boolean bSave;
    private String saveImgName;
    private String strParamNo;
    private int iColorNum;
    private int iFontNum;
    private int processNo;
    private Document document;
    private File vizImageFile;
    private File reportImageFile;
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();

    public SaveReportLowVision(Shell shell) {
        this.shell = shell;
        this.saveFileName = "";
    }

    public void doSave(String string, List<IProblemItem> list, File file, File file2) {
        this.currentUrlS = string;
        this.saveFileName = DialogSave.open((Shell)this.shell, (int)1, (String)this.currentUrlS, (String)"_lowVision.htm");
        this.saveImgName = LVIMG_FILE;
        this.problemList = list;
        if (this.saveFileName == null) {
            return;
        }
        this.document = null;
        this.bSave = true;
        this.vizImageFile = file;
        this.reportImageFile = file2;
        SaveBmpFileThread saveBmpFileThread = new SaveBmpFileThread();
        saveBmpFileThread.start();
    }

    public void doSave(int n, int[] nArray, String string, String string2, Document document, String string3, List<IProblemItem> list, File file, File file2) {
        this.currentUrlS = string3;
        this.processNo = n;
        this.vizImageFile = file;
        this.reportImageFile = file2;
        this.saveFileName = this.currentUrlS;
        if (this.saveFileName != null) {
            int n2 = this.saveFileName.indexOf("//");
            if (n2 == -1) {
                n2 = 0;
            }
            this.saveFileName = this.saveFileName.substring(n2 + 2);
            this.saveFileName = this.saveFileName.replaceAll("\\p{Punct}", UNDERSCORE);
            if (this.saveFileName.indexOf(".") > 0) {
                this.saveFileName = this.saveFileName.substring(0, this.saveFileName.lastIndexOf("."));
            }
            if (this.saveFileName.length() > 100) {
                this.saveFileName = this.saveFileName.substring(0, 100);
            }
        }
        this.saveImgName = String.valueOf(this.saveFileName) + UNDERSCORE + String.valueOf(this.processNo) + UNDERSCORE + String.valueOf(nArray[0]) + String.valueOf(nArray[1]) + String.valueOf(nArray[2]) + "_lvimg.png";
        this.saveFileName = String.valueOf(this.saveFileName) + UNDERSCORE + String.valueOf(this.processNo) + UNDERSCORE + String.valueOf(nArray[0]) + String.valueOf(nArray[1]) + String.valueOf(nArray[2]) + "_lowVision.htm";
        File file3 = new File(string2 = String.valueOf(string2) + "lowvision" + File.separator);
        if (!file3.isDirectory()) {
            file3.mkdirs();
        }
        this.saveFileName = String.valueOf(string2) + this.saveFileName;
        this.strParamNo = string;
        this.problemList = list;
        if (this.saveFileName == null) {
            return;
        }
        this.document = document;
        this.bSave = true;
        SaveBmpFileThread saveBmpFileThread = new SaveBmpFileThread();
        saveBmpFileThread.start();
    }

    public boolean isInSaveReport() {
        return this.bSave;
    }

    public int getNumColorProblem() {
        return this.iColorNum;
    }

    public int getNumFontProblem() {
        return this.iFontNum;
    }

    private String getFileName(String string) {
        int n;
        int n2 = string.lastIndexOf("/");
        if (n2 < (n = string.lastIndexOf("\\"))) {
            n2 = n;
        }
        if (n2 > -1) {
            return string.substring(n2 + 1);
        }
        return string;
    }

    private class SaveBmpFileThread
    extends Thread {
        private SaveBmpFileThread() {
        }

        private String getArrayString(int[][] nArray, int n) {
            StringBuffer stringBuffer = new StringBuffer();
            try {
                if (nArray.length > 0) {
                    int n2 = 0;
                    while (n2 < nArray.length) {
                        stringBuffer.append(String.valueOf(nArray[n2][n]) + ",");
                        ++n2;
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return stringBuffer.toString();
        }

        private void prepareJavaScript(Writer writer, IProblemItemImage[] iProblemItemImageArray, String string) {
            int n = iProblemItemImageArray.length;
            int[][] nArray = new int[n][4];
            int n2 = 0;
            while (n2 < n) {
                nArray[n2][0] = iProblemItemImageArray[n2].getX();
                nArray[n2][1] = iProblemItemImageArray[n2].getY();
                nArray[n2][2] = iProblemItemImageArray[n2].getWidth();
                nArray[n2][3] = iProblemItemImageArray[n2].getHeight();
                ++n2;
            }
            try {
                writer.write("<SCRIPT Language=\"JavaScript\">" + FileUtils.LINE_SEP);
                writer.write("var divLeft = new Array(" + this.getArrayString(nArray, 0) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divTop = new Array(" + this.getArrayString(nArray, 1) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divWidth = new Array(" + this.getArrayString(nArray, 2) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divHeight = new Array(" + this.getArrayString(nArray, 3) + "0);" + FileUtils.LINE_SEP);
                writer.write("var divArray = new Array(" + n + ");" + FileUtils.LINE_SEP);
                writer.write("var sLeft = new Array(" + n + ");" + FileUtils.LINE_SEP);
                writer.write("var sTop = new Array(" + n + ");" + FileUtils.LINE_SEP);
                writer.write("</SCRIPT>" + FileUtils.LINE_SEP);
                writer.write("<SCRIPT><!--" + FileUtils.LINE_SEP);
                writer.write("if(navigator.appName.toLowerCase().indexOf(\"microsoft\")>=0){" + FileUtils.LINE_SEP);
                writer.write("jsFile=\"" + string + "lvHighlight.js\";" + FileUtils.LINE_SEP);
                writer.write("}else{" + FileUtils.LINE_SEP);
                writer.write("jsFile=\"" + string + "lvHighlight_moz.js\";" + FileUtils.LINE_SEP);
                writer.write("}" + FileUtils.LINE_SEP);
                writer.write("document.write(\"<script src=\"+jsFile+\"></script>\");" + FileUtils.LINE_SEP);
                writer.write("-->" + FileUtils.LINE_SEP + "</SCRIPT>" + FileUtils.LINE_SEP);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        public void run() {
            try {
                String[] stringArray;
                Object object;
                String string = SaveReportLowVision.this.saveFileName.substring(0, SaveReportLowVision.this.saveFileName.lastIndexOf("."));
                File file = new File(string);
                file.mkdirs();
                String string2 = string;
                string2 = String.valueOf(SaveReportLowVision.this.getFileName(string2)) + "/";
                string = String.valueOf(string) + File.separator;
                String string3 = String.valueOf(string) + SaveReportLowVision.RESULT_BMP_FILE;
                FileUtils.copyFile((String)SaveReportLowVision.this.vizImageFile.getAbsolutePath(), (String)string3, (boolean)true);
                PrintWriter printWriter = new PrintWriter(new FileWriter(SaveReportLowVision.this.saveFileName));
                printWriter.write("<html><head><title>Report (LowVision) of " + SaveReportLowVision.this.currentUrlS + "</title>");
                IProblemItemImage[] iProblemItemImageArray = new IProblemItemImage[SaveReportLowVision.this.problemList.size()];
                SaveReportLowVision.this.problemList.toArray(iProblemItemImageArray);
                this.prepareJavaScript(printWriter, iProblemItemImageArray, string2);
                printWriter.write("</head>");
                if (iProblemItemImageArray.length > 0) {
                    printWriter.write("<body onload=\"onloadFunc()\">" + FileUtils.LINE_SEP);
                } else {
                    printWriter.write("<body>" + FileUtils.LINE_SEP);
                }
                if (SaveReportLowVision.this.reportImageFile != null) {
                    printWriter.write("<p><FONT>Problem Map</FONT><BR>");
                    printWriter.write("<img src=\"" + string2 + SaveReportLowVision.this.saveImgName + "\" height=\"200\" style=\"{border:2 solid black}\">");
                    printWriter.write("</p><hr>" + FileUtils.LINE_SEP);
                }
                printWriter.write("<DIV id=\"mother\">");
                printWriter.write("<img id=\"simImg\" src=\"" + string2 + SaveReportLowVision.RESULT_BMP_FILE + "\"></DIV>" + FileUtils.LINE_SEP);
                printWriter.write("<hr>" + FileUtils.LINE_SEP);
                SaveReportLowVision.this.iColorNum = 0;
                SaveReportLowVision.this.iFontNum = 0;
                if (iProblemItemImageArray.length > 0) {
                    printWriter.write("<table border=\"1\">\r\n");
                    printWriter.write("<tr>");
                    printWriter.write("<th>" + IProblemConst.TITLE_ICON + "</th>");
                    IGuidelineData[] iGuidelineDataArray = SaveReportLowVision.this.guidelineHolder.getGuidelineData();
                    int n = 0;
                    while (n < iGuidelineDataArray.length) {
                        printWriter.write("<th>" + iGuidelineDataArray[n].getGuidelineName() + "</th>");
                        ++n;
                    }
                    printWriter.write("<th>" + IProblemConst.TITLE_DESCRIPTION + "</th>");
                    printWriter.write("<th>" + IProblemConst.TITLE_SEVERITY + "</th>");
                    printWriter.write("<th>" + IProblemConst.TITLE_FORECOLOR + "</th>");
                    printWriter.write("<th>" + IProblemConst.TITLE_BACKCOLOR + "</th>");
                    printWriter.write("<th>" + IProblemConst.TITLE_X + "</th>");
                    printWriter.write("<th>" + IProblemConst.TITLE_Y + "</th>");
                    printWriter.write("<th>" + IProblemConst.TITLE_AREA + "</th>");
                    printWriter.write("</tr>" + FileUtils.LINE_SEP);
                    LowVisionVizResourceUtil.saveErrorIcons(string);
                    LowVisionVizResourceUtil.saveImages(string);
                    LowVisionVizResourceUtil.saveScripts(string);
                    n = 0;
                    while (n < iProblemItemImageArray.length) {
                        printWriter.write("<tr id=\"" + n + "\" onclick=\"TROnclickFunc(this)\">");
                        int n2 = iProblemItemImageArray[n].getIconId();
                        int n3 = 0;
                        object = "";
                        switch (n2) {
                            case 1: {
                                SaveReportLowVision saveReportLowVision = SaveReportLowVision.this;
                                saveReportLowVision.iColorNum = saveReportLowVision.iColorNum + 1;
                                n3 = 0;
                                if (iProblemItemImageArray[n].isCanHighlight()) {
                                    object = "HiIro21.gif";
                                    break;
                                }
                                object = "ErrIro21.gif";
                                break;
                            }
                            case 3: {
                                SaveReportLowVision saveReportLowVision = SaveReportLowVision.this;
                                saveReportLowVision.iFontNum = saveReportLowVision.iFontNum + 1;
                                n3 = 1;
                                object = iProblemItemImageArray[n].isCanHighlight() ? "HiBoke21.gif" : "ErrBoke21.gif";
                            }
                        }
                        printWriter.write("<td><img src=" + string2 + (String)object + " alt=\"" + ERROR_IMAGE_ALT[n3] + "\"></td>");
                        stringArray = iProblemItemImageArray[n].getEvaluationItem().getTableDataGuideline();
                        int n4 = 0;
                        while (n4 < stringArray.length) {
                            printWriter.write("<td>" + stringArray[n4] + "&nbsp;</td>");
                            ++n4;
                        }
                        printWriter.write("<td  STYLE=\"COLOR:blue;TEXT-DECORATION:underline\">" + iProblemItemImageArray[n].getDescription() + "&nbsp;</td>");
                        if (iProblemItemImageArray[n].getSeverityLV() > 0) {
                            printWriter.write("<td>" + String.valueOf(iProblemItemImageArray[n].getSeverityLV()) + "&nbsp;</td>");
                        } else {
                            printWriter.write("<td>-&nbsp;</td>");
                        }
                        printWriter.write("<td>" + iProblemItemImageArray[n].getForeground() + "&nbsp;</td>");
                        printWriter.write("<td>" + iProblemItemImageArray[n].getBackground() + "&nbsp;</td>");
                        printWriter.write("<td>" + String.valueOf(iProblemItemImageArray[n].getX()) + "&nbsp;</td>");
                        printWriter.write("<td>" + String.valueOf(iProblemItemImageArray[n].getY()) + "&nbsp;</td>");
                        printWriter.write("<td>" + String.valueOf(iProblemItemImageArray[n].getArea()) + "&nbsp;</td>");
                        printWriter.write("</tr>" + FileUtils.LINE_SEP);
                        ++n;
                    }
                    printWriter.write("</table>" + FileUtils.LINE_SEP);
                }
                if (SaveReportLowVision.this.reportImageFile != null) {
                    FileUtils.copyFile((String)SaveReportLowVision.this.reportImageFile.getAbsolutePath(), (String)(String.valueOf(string) + SaveReportLowVision.this.saveImgName), (boolean)true);
                }
                printWriter.write("</body>" + FileUtils.LINE_SEP);
                printWriter.write("</html>");
                printWriter.flush();
                printWriter.close();
                if (SaveReportLowVision.this.document != null) {
                    int n = SaveReportLowVision.this.saveFileName.lastIndexOf("lowvision" + File.separator);
                    String string4 = "lowvision/" + SaveReportLowVision.this.saveFileName.substring(n + 10);
                    NodeList nodeList = SaveReportLowVision.this.document.getElementsByTagName("td");
                    Element element = (Element)nodeList.item(0);
                    object = element.getChildNodes().item(0);
                    element.replaceChild(SaveReportLowVision.this.document.createTextNode("URL(" + String.valueOf(SaveReportLowVision.this.processNo) + ")"), (Node)object);
                    stringArray = SaveReportLowVision.this.document.getElementsByTagName("tbody");
                    Element element2 = (Element)stringArray.item(0);
                    Element element3 = SaveReportLowVision.this.document.createElement("tr");
                    element2.appendChild(element3);
                    Element element4 = SaveReportLowVision.this.document.createElement("td");
                    element4.setAttribute("width", "600");
                    element3.appendChild(element4);
                    Element element5 = SaveReportLowVision.this.document.createElement("a");
                    element5.setAttribute("href", string4);
                    element5.appendChild(SaveReportLowVision.this.document.createTextNode(SaveReportLowVision.this.currentUrlS));
                    element4.appendChild(element5);
                    element4 = SaveReportLowVision.this.document.createElement("td");
                    element4.appendChild(SaveReportLowVision.this.document.createTextNode(SaveReportLowVision.this.strParamNo));
                    element3.appendChild(element4);
                    element4 = SaveReportLowVision.this.document.createElement("td");
                    element4.appendChild(SaveReportLowVision.this.document.createTextNode(String.valueOf(SaveReportLowVision.this.iColorNum)));
                    element3.appendChild(element4);
                    element4 = SaveReportLowVision.this.document.createElement("td");
                    element4.appendChild(SaveReportLowVision.this.document.createTextNode(String.valueOf(SaveReportLowVision.this.iFontNum)));
                    element3.appendChild(element4);
                }
                SaveReportLowVision.this.bSave = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

