/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.examples.adesigner.eval.html;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.actf.examples.adesigner.eval.html.internal.CheckEngine;
import org.eclipse.actf.model.ui.IModelService;
import org.eclipse.actf.visualization.eval.ICheckTarget;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.IHtmlCheckTarget;
import org.eclipse.actf.visualization.eval.IHtmlChecker;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.guideline.GuidelineSelectionChangedEvent;
import org.eclipse.actf.visualization.eval.guideline.IGuidelineSlectionChangedListener;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Checker
implements IHtmlChecker,
IGuidelineSlectionChangedListener {
    private static final String CHECK_ITEM_PATTERN = "C_\\p{Digit}+(\\.\\p{Digit}+)?";
    private HashSet<String> mimeSet = new HashSet();
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean[] checkItems = new boolean[1000];
    private boolean enabled = false;

    public Checker() {
        this.updateCheckItems();
        this.guidelineHolder.addGuidelineSelectionChangedListener((IGuidelineSlectionChangedListener)this);
        int n = 0;
        while (n < IModelService.MIMETYPES_HTML.length) {
            this.mimeSet.add(IModelService.MIMETYPES_HTML[n]);
            ++n;
        }
    }

    private void updateCheckItems() {
        Arrays.fill(this.checkItems, false);
        this.enabled = false;
        for (IEvaluationItem iEvaluationItem : this.guidelineHolder.getMatchedCheckitemSet()) {
            String string = iEvaluationItem.getId();
            if (!string.matches(CHECK_ITEM_PATTERN)) continue;
            int n = (string = string.substring(2)).indexOf(".");
            if (n > -1) {
                string = string.substring(0, n);
            }
            try {
                int n2 = Integer.parseInt(string);
                if (n2 <= -1 || n2 >= 1000) continue;
                this.checkItems[n2] = true;
                this.enabled = true;
            }
            catch (Exception exception) {}
        }
    }

    public void selectionChanged(GuidelineSelectionChangedEvent guidelineSelectionChangedEvent) {
        this.updateCheckItems();
    }

    public List<IProblemItem> check(ICheckTarget iCheckTarget) {
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isTargetFormat(String string) {
        if (string == null) {
            return false;
        }
        return this.mimeSet.contains(string);
    }

    public List<IProblemItem> checkHtml(IHtmlCheckTarget iHtmlCheckTarget) {
        CheckEngine checkEngine = new CheckEngine(iHtmlCheckTarget.getHtmlEvalUtil(), this.checkItems);
        return checkEngine.check();
    }
}

