/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.internal.dom.sgml.util;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.actf.model.dom.html.IErrorHandler;
import org.eclipse.actf.model.internal.dom.sgml.util.IErrorHandlerTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ErrorHandlerTableImpl
extends Hashtable<URL, IErrorHandler[]>
implements IErrorHandlerTable {
    private static final long serialVersionUID = -5122037603773966517L;
    private String[] errorHandlerNameArray = new String[128];

    public ErrorHandlerTableImpl() {
        this.init();
    }

    private void init() {
        Properties properties = new Properties();
        try {
            properties.load(this.getClass().getResourceAsStream("errorhandlers.properties"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            URL uRL;
            String string = (String)enumeration.nextElement();
            try {
                uRL = new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
                continue;
            }
            this.put(uRL, this.createErrorHandlers((String)properties.get(string)));
        }
    }

    private IErrorHandler[] createErrorHandlers(String string) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < string.length()) {
            if (string.charAt(n3) == ',') {
                this.errorHandlerNameArray[n2++] = string.substring(n, n3);
                n = n3 + 1;
            }
            ++n3;
        }
        this.errorHandlerNameArray[n2++] = string.substring(n);
        IErrorHandler[] iErrorHandlerArray = new IErrorHandler[n2];
        int n4 = 0;
        while (n4 < n2) {
            try {
                Class<?> clazz = Class.forName(this.errorHandlerNameArray[n4]);
                iErrorHandlerArray[n4] = (IErrorHandler)clazz.newInstance();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            ++n4;
        }
        return iErrorHandlerArray;
    }

    @Override
    public IErrorHandler[] getErrorHandlers(URL uRL) {
        return (IErrorHandler[])this.get(uRL);
    }
}

