/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.util.internal.httpproxy.core;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.util.httpproxy.core.IHTTPHeader;

public abstract class HTTPHeader
implements IHTTPHeader {
    private boolean isRemoved = false;

    public static byte toUpcase(byte by) {
        if (by >= 97 && by <= 122) {
            return (byte)(by - 32);
        }
        return by;
    }

    public static boolean compare(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (byArray[n2] != byArray2[n2]) {
                return false;
            }
            --n2;
        }
        return true;
    }

    public static boolean compareIgnoreCase(byte[] byArray, byte[] byArray2) {
        int n = byArray.length;
        if (n != byArray2.length) {
            return false;
        }
        int n2 = n - 1;
        while (n2 >= 0) {
            if (HTTPHeader.toUpcase(byArray[n2]) != HTTPHeader.toUpcase(byArray2[n2])) {
                return false;
            }
            --n2;
        }
        return true;
    }

    protected HTTPHeader() {
    }

    public void setRemoved(boolean bl) {
        this.isRemoved = bl;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public abstract boolean isFieldNameEqualsTo(byte[] var1);

    public abstract boolean isFieldValueEqualsTo(byte[] var1);

    public abstract byte[] getName();

    public abstract byte[] getValue();

    public abstract void setValue(byte[] var1);

    protected abstract void write(OutputStream var1) throws IOException;

    protected void writeHeaderSeparator(OutputStream outputStream) throws IOException {
        outputStream.write(58);
        outputStream.write(32);
    }

    public boolean compareValue(byte[] byArray) {
        return HTTPHeader.compare(this.getValue(), byArray);
    }

    public boolean compareValueIgnoreCase(byte[] byArray) {
        return HTTPHeader.compareIgnoreCase(this.getValue(), byArray);
    }

    public void writeLine(OutputStream outputStream) throws IOException {
        if (!this.isRemoved) {
            this.write(outputStream);
            outputStream.write(13);
            outputStream.write(10);
        }
    }

    public String toString() {
        return "Header:" + new String(this.getName()) + ":" + new String(this.getValue());
    }
}

