/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.model.flash.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;
import java.util.zip.InflaterInputStream;

public class SwfHeaderParser {
    private static final Logger LOGGER = Logger.getLogger(SwfHeaderParser.class.getName());
    private static int COMPRESSED_FLAG = 67;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int byteCount = 0;
    private byte[] buf1 = new byte[8];
    private byte[] buf2 = new byte[17];
    private byte[] buf3 = new byte[4];
    private InputStream in;
    private boolean isCompressed = false;
    private int version;
    private int length;
    private int frameSizeX;
    private int frameSizeY;
    private int rate;
    private int framecount;

    public SwfHeaderParser(InputStream inputStream) {
        this.in = inputStream;
    }

    private int readSBits(int n) throws IOException {
        if (n > 32) {
            throw new IOException("Number of bits > 32");
        }
        int n2 = this.readUBits(n);
        int n3 = 32 - n;
        n2 = n2 << n3 >> n3;
        return n2;
    }

    private int readUBits(int n) throws IOException {
        int n2;
        byte[] byArray;
        if (n == 0) {
            return 0;
        }
        int n3 = n;
        int n4 = 0;
        if (this.bitPos == 0) {
            byArray = new byte[1];
            this.in.read(byArray);
            this.buf2[this.byteCount] = byArray[0];
            ++this.byteCount;
            this.bitBuf = byArray[0] & 0xFF;
            this.bitPos = 8;
        }
        while ((n2 = n3 - this.bitPos) > 0) {
            n4 |= this.bitBuf << n2;
            n3 -= this.bitPos;
            byArray = new byte[1];
            this.in.read(byArray);
            this.buf2[this.byteCount] = byArray[0];
            ++this.byteCount;
            this.bitBuf = byArray[0] & 0xFF;
            this.bitPos = 8;
        }
        this.bitPos -= n3;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return n4 |= this.bitBuf >> -n2;
    }

    public void parse() throws IOException {
        LOGGER.fine("skipping header...");
        this.in.read(this.buf1);
        if (this.buf1[0] == COMPRESSED_FLAG) {
            this.isCompressed = true;
        }
        LOGGER.fine("compressed=" + this.isCompressed);
        this.version = this.buf1[3] & 0xFF;
        LOGGER.fine("version=" + this.version);
        this.length = this.buf1[4] & 0xFF | (this.buf1[5] & 0xFF) << 8 | (this.buf1[6] & 0xFF) << 16 | this.buf1[7] << 24;
        LOGGER.fine("length=" + this.length);
        if (this.isCompressed) {
            this.in = new InflaterInputStream(this.in);
        }
        this.readFrameSize();
        this.in.read(this.buf3);
        this.rate = (this.buf3[0] & 0xFF) << 8 | this.buf3[1] & 0xFF;
        this.framecount = this.buf3[2] & 0xFF | (this.buf3[3] & 0xFF) << 8;
        LOGGER.fine("rate=" + this.rate + ", framecount=" + this.framecount);
    }

    private void readFrameSize() throws IOException {
        int n = this.readUBits(5);
        LOGGER.fine("frame size X min = " + Integer.toString(this.readSBits(n)));
        this.frameSizeX = this.readSBits(n);
        LOGGER.fine("frame size X max (twips) = " + Integer.toString(this.frameSizeX));
        LOGGER.fine("frame size Y min = " + Integer.toString(this.readSBits(n)));
        this.frameSizeY = this.readSBits(n);
        LOGGER.fine("frame size Y max (twips) = " + Integer.toString(this.frameSizeY));
    }

    public boolean isCompressed() {
        return this.isCompressed;
    }

    public int getVersion() {
        return this.version;
    }

    public int getLength() {
        return this.length;
    }

    public int getFrameSizeX() {
        return this.frameSizeX;
    }

    public int getFrameSizeY() {
        return this.frameSizeY;
    }

    public InputStream getInputStream() {
        return this.in;
    }
}

