/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tea.core.ui.internal.listeners;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.internal.events.BuildCommand;
import org.eclipse.core.internal.events.BuildManager;
import org.eclipse.core.internal.events.InternalBuilder;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.watson.ElementTree;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tea.core.TaskExecutionContext;
import org.eclipse.tea.core.TaskingInjectionHelper;
import org.eclipse.tea.core.annotations.lifecycle.BeginTaskChain;
import org.eclipse.tea.core.annotations.lifecycle.FinishTaskChain;
import org.eclipse.tea.core.services.TaskingLifeCycleListener;
import org.eclipse.tea.core.services.TaskingLog;
import org.eclipse.ui.PlatformUI;
import org.osgi.service.component.annotations.Component;

@Component
public class AutoBuildDeactivator
implements TaskingLifeCycleListener {
    private boolean autoBuildOriginalState = false;
    private static AtomicInteger nestCount = new AtomicInteger(0);
    private static final Map<IProject, ElementTree> suppressedProjects = new HashMap<IProject, ElementTree>();

    public Workspace getWorkspace() {
        return (Workspace)ResourcesPlugin.getWorkspace();
    }

    @BeginTaskChain
    public synchronized void begin(TaskingLog log) throws CoreException {
        if (nestCount.getAndIncrement() == 0) {
            log.debug("Disabling automatic build...");
            this.autoBuildOriginalState = this.setAutoBuild(log, false, false);
            AutoBuildDeactivator.cancelAutoBuild();
        }
    }

    private static void cancelAutoBuild() {
        Job.getJobManager().cancel(ResourcesPlugin.FAMILY_AUTO_BUILD);
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
        }
        catch (InterruptedException | OperationCanceledException throwable) {
            // empty catch block
        }
    }

    @FinishTaskChain
    public synchronized void finish(TaskExecutionContext context, TaskingLog log, MultiStatus status) throws CoreException {
        if (nestCount.decrementAndGet() != 0) {
            return;
        }
        if (!TaskingInjectionHelper.isHeadless((IEclipseContext)context.getContext()) && !this.autoBuildOriginalState && status.getSeverity() < 4) {
            Display.getDefault().asyncExec(() -> {
                boolean autoBuild = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Automatic Build", (String)"The Eclipse automatic build is disabled. Since the build was successful, enabling the automatic build is recommended. Should the automatic build be enabled now?");
                this.setAutoBuild(log, autoBuild, true);
            });
        } else {
            this.setAutoBuild(log, this.autoBuildOriginalState, !TaskingInjectionHelper.isHeadless((IEclipseContext)context.getContext()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setAutoBuild(TaskingLog log, boolean autoBuild, boolean suppressBuild) {
        boolean originalState = false;
        Map<IProject, ElementTree> map = suppressedProjects;
        synchronized (map) {
            block9: {
                try {
                    try {
                        IWorkspace workspace = ResourcesPlugin.getWorkspace();
                        IWorkspaceDescription workspaceDesc = workspace.getDescription();
                        originalState = workspaceDesc.isAutoBuilding();
                        workspaceDesc.setAutoBuilding(autoBuild);
                        workspace.setDescription(workspaceDesc);
                        if (!suppressedProjects.isEmpty() && suppressBuild) {
                            AutoBuildDeactivator.suppressBuild(suppressedProjects);
                        }
                    }
                    catch (Exception e) {
                        log.error("Failed to restore AutoBuild, target=" + autoBuild, (Throwable)e);
                        suppressedProjects.clear();
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    suppressedProjects.clear();
                    throw throwable;
                }
                suppressedProjects.clear();
            }
        }
        return originalState;
    }

    private static void suppressBuild(Map<IProject, ElementTree> suppressedProjects) {
        try {
            BuildManager mgr = ((Workspace)ResourcesPlugin.getWorkspace()).getBuildManager();
            Field jobField = mgr.getClass().getDeclaredField("autoBuildJob");
            jobField.setAccessible(true);
            Object o = jobField.get(mgr);
            jobField.setAccessible(false);
            AutoBuildDeactivator.cancelAutoBuild();
            Field force = o.getClass().getDeclaredField("forceBuild");
            force.setAccessible(true);
            force.set(o, false);
            force.setAccessible(false);
            if (!suppressedProjects.isEmpty()) {
                for (Map.Entry<IProject, ElementTree> entry : suppressedProjects.entrySet()) {
                    ICommand[] commands;
                    IProject project = entry.getKey();
                    if (!project.isOpen()) continue;
                    IBuildConfiguration bc = project.getActiveBuildConfig();
                    ElementTree elementTree = suppressedProjects.get(project);
                    if (elementTree == null || !project.isAccessible()) continue;
                    ICommand[] iCommandArray = commands = ((Project)project).internalGetDescription().getBuildSpec(false);
                    int n = commands.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ICommand c = iCommandArray[n2];
                        IncrementalProjectBuilder b = ((BuildCommand)c).getBuilder(bc);
                        Method setTree = InternalBuilder.class.getDeclaredMethod("setLastBuiltTree", ElementTree.class);
                        setTree.setAccessible(true);
                        setTree.invoke((Object)b, elementTree);
                        setTree.setAccessible(false);
                        ++n2;
                    }
                }
            }
            ((Job)o).schedule();
        }
        catch (Exception e) {
            System.err.println("cannot avoid autobuild");
            e.printStackTrace();
        }
    }
}

