/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emfcloud.jackson.databind.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emfcloud.jackson.databind.EMFContext;
import org.eclipse.emfcloud.jackson.databind.deser.ReferenceEntry;

public class CollectionDeserializer
extends JsonDeserializer<Collection<Object>> {
    private final CollectionType baseType;
    private final JsonDeserializer<? extends EObject> deserializer;
    private final JsonDeserializer<? extends ReferenceEntry> referenceDeserializer;

    public CollectionDeserializer(CollectionType type, JsonDeserializer<? extends EObject> deserializer, JsonDeserializer<ReferenceEntry> referenceDeserializer) {
        this.baseType = type;
        this.deserializer = deserializer;
        this.referenceDeserializer = referenceDeserializer;
    }

    public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        Collection<Object> values = this.createCollection(ctxt);
        while (p.nextToken() != JsonToken.END_ARRAY) {
            EObject result = (EObject)this.deserializer.deserialize(p, ctxt);
            if (result == null) continue;
            values.add(result);
        }
        return values;
    }

    private Collection<Object> createCollection(DeserializationContext ctxt) {
        CollectionType type = this.baseType;
        try {
            if (this.baseType.isAbstract() && this.baseType.isCollectionLikeType()) {
                type = (CollectionType)ctxt.getFactory().mapAbstractType(ctxt.getConfig(), (JavaType)type);
            }
            if (!type.isAbstract()) {
                return (Collection)type.getRawClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (type.isTypeOrSubTypeOf(Set.class)) {
            return new HashSet<Object>();
        }
        return new ArrayList<Object>();
    }

    public Collection<Object> deserialize(JsonParser p, DeserializationContext ctxt, Collection<Object> intoValue) throws IOException {
        EObject parent = EMFContext.getParent((DatabindContext)ctxt);
        EReference feature = EMFContext.getReference((DatabindContext)ctxt);
        while (p.nextToken() != JsonToken.END_ARRAY) {
            EMFContext.setParent((DatabindContext)ctxt, parent);
            EMFContext.setFeature((DatabindContext)ctxt, (EStructuralFeature)feature);
            if (feature != null && feature.isContainment()) {
                EObject result = (EObject)this.deserializer.deserialize(p, ctxt);
                if (result == null) continue;
                intoValue.add(result);
                continue;
            }
            ReferenceEntry entry = (ReferenceEntry)this.referenceDeserializer.deserialize(p, ctxt);
            if (entry == null) continue;
            intoValue.add(entry);
        }
        return intoValue;
    }
}

