/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.ssza;

import java.util.List;
import java.util.Objects;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.graph.TopologicalGraphService;
import org.eclipse.set.feature.table.PlanPro2TableTransformationService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableTransformationService;
import org.eclipse.set.feature.table.pt1.messages.Messages;
import org.eclipse.set.feature.table.pt1.ssza.SszaTransformator;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.RowMergeMode;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.utils.table.ColumnDescriptorModelBuilder;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(service={PlanPro2TableTransformationService.class}, immediate=true, property={"table.category=etcs", "table.shortcut=ssza"})
public final class SszaTransformationService
extends AbstractPlanPro2TableTransformationService {
    @Reference
    private Messages messages;
    @Reference
    private EnumTranslationService enumTranslationService;
    @Reference
    private TopologicalGraphService topGraphService;
    @Reference
    private EventAdmin eventAdmin;

    public AbstractPlanPro2TableModelTransformator createTransformator() {
        return new SszaTransformator(this.cols, this.enumTranslationService, this.topGraphService, this.eventAdmin);
    }

    public TableNameInfo getTableNameInfo() {
        return new TableNameInfo(this.messages.ToolboxTableNameSszaLong, this.messages.ToolboxTableNameSszaPlanningNumber, this.messages.ToolboxTableNameSszaShort);
    }

    @Override
    protected String getTableHeading() {
        return this.messages.SszaTableView_Heading;
    }

    @Override
    public ColumnDescriptor fillHeaderDescriptions(ColumnDescriptorModelBuilder builder) {
        ColumnDescriptor cd = super.fillHeaderDescriptions(builder);
        cd.setMergeCommonValues(RowMergeMode.ENABLED);
        List<String> notMergeColumns = List.of("E", "F", "G", "H", "I");
        this.cols.stream().filter(col -> notMergeColumns.stream().anyMatch(ele -> Objects.equals(ele, col.getColumnPosition()))).forEach(col -> col.setMergeCommonValues(RowMergeMode.DISABLED));
        return cd;
    }

    @Override
    protected String getShortcut() {
        return this.messages.ToolboxTableNameSszaShort.toLowerCase();
    }

    @Override
    protected List<String> getTopologicalColumnPosition() {
        return List.of("I");
    }
}

