/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.constants.ToolboxConstants;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.table.pt1.FootnoteTransformation;
import org.eclipse.set.feature.table.pt1.WaitFillingCell;
import org.eclipse.set.model.planpro.BasisTypen.BasisAttribut_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Basis_Objekt;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.tablemodel.CellContent;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.TableExtensions;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.CacheUtils;
import org.eclipse.set.utils.events.TableDataChangeEvent;
import org.eclipse.set.utils.table.AbstractTableModelTransformator;
import org.eclipse.set.utils.table.Pt1TableChangeProperties;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.osgi.service.event.EventAdmin;

public abstract class AbstractPlanPro2TableModelTransformator
extends AbstractTableModelTransformator<MultiContainer_AttributeGroup> {
    protected final FootnoteTransformation footnoteTransformation = new FootnoteTransformation();
    protected final EnumTranslationService enumTranslationService;
    protected final Set<ColumnDescriptor> cols = CollectionLiterals.newHashSet();
    protected final EventAdmin eventAdmin;
    protected static final String FILL_DELAY_CELL_THREAD = "fillDelayCell";
    protected final List<WaitFillingCell<Ur_Objekt>> delayFillingCells;
    protected final Map<TableRow, Set<ColumnDescriptor>> topologicalCells;
    protected static final Comparator<String> MIXED_STRING_COMPARATOR = ToolboxConstants.LST_OBJECT_NAME_COMPARATOR;

    public AbstractPlanPro2TableModelTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService, EventAdmin eventAdmin) {
        this.enumTranslationService = enumTranslationService;
        this.cols.addAll(cols);
        ArrayList _arrayList = new ArrayList();
        this.delayFillingCells = Collections.synchronizedList(_arrayList);
        this.topologicalCells = CollectionLiterals.newHashMap();
        this.eventAdmin = eventAdmin;
    }

    protected void fillFootnotes(TableRow row, Basis_Objekt object) {
        boolean _tripleEquals;
        this.footnoteTransformation.transform(object, row);
        Functions.Function1 _function = it -> {
            String _columnPosition = it.getColumnPosition();
            return _columnPosition != null;
        };
        Functions.Function1 _function_1 = it -> it.getColumnPosition();
        ColumnDescriptor column = (ColumnDescriptor)IterableExtensions.sortBy((Iterable)IterableExtensions.filter(this.cols, (Functions.Function1)_function), (Functions.Function1)_function_1).getLast();
        TableCell cell = TableRowExtensions.getCell((TableRow)row, (ColumnDescriptor)column);
        CellContent _content = cell.getContent();
        boolean bl = _tripleEquals = _content == null;
        if (_tripleEquals) {
            cell.setContent((CellContent)TablemodelFactory.eINSTANCE.createStringCellContent());
        }
    }

    public String translate(BasisAttribut_AttributeGroup owner) {
        Field wertField;
        block8: {
            block7: {
                try {
                    if (owner != null) break block7;
                    return null;
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        throw new RuntimeException(e);
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            Functions.Function1 _function = it -> {
                String _name = it.getName();
                return _name == "wert";
            };
            wertField = (Field)IterableExtensions.findFirst((Iterable)((Iterable)Conversions.doWrapArray((Object)owner.getClass().getDeclaredFields())), (Functions.Function1)_function);
            if (wertField != null) break block8;
            return null;
        }
        wertField.setAccessible(true);
        Object wert = wertField.get(owner);
        if (wert instanceof Boolean) {
            return this.translate((Boolean)wert);
        }
        if (wert instanceof Enumerator) {
            return this.enumTranslationService.translate(owner, (Enumerator)wert).getAlternative();
        }
        return null;
    }

    public String translate(Boolean value) {
        if (value == null) {
            return null;
        }
        return this.enumTranslationService.translate(value.booleanValue()).getAlternative();
    }

    public ColumnDescriptor getColumn(Set<ColumnDescriptor> columns, String pos) {
        Functions.Function1 _function = it -> it.getColumnPosition() != null && it.getColumnPosition().equals(pos);
        ColumnDescriptor column = (ColumnDescriptor)IterableExtensions.findFirst(columns, (Functions.Function1)_function);
        if (column == null) {
            throw new RuntimeException("Missing column " + pos);
        }
        return column;
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory) {
        Table table = this.transformTableContent(container, factory, null);
        Consumer<TableRow> _function = row -> {
            Procedures.Procedure2 _function_1 = (cell, index) -> {
                boolean _tripleEquals;
                CellContent _content = cell.getContent();
                boolean bl = _tripleEquals = _content == null;
                if (_tripleEquals) {
                    this.fillBlank((TableRow)row, (int)index);
                }
            };
            IterableExtensions.forEach((Iterable)row.getCells(), (Procedures.Procedure2)_function_1);
        };
        TableExtensions.getTableRows((Table)table).forEach(_function);
        return table;
    }

    public <S, T extends Ur_Objekt> void fillSingleCellWhenAllowed(TableRow row, ColumnDescriptor column, T object, Functions.Function0<? extends Boolean> fillCondition, String tableShortcut, String threadName, Functions.Function1<? super T, ? extends String> filling) {
        Functions.Function1 _function = it -> {
            String _apply = (String)filling.apply(it);
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_apply}));
        };
        this.fillIterableSingleCellWhenAllowed(row, column, object, fillCondition, _function, null, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR, tableShortcut);
    }

    public <S, T extends Ur_Objekt> void fillIterableSingleCellWhenAllowed(TableRow row, ColumnDescriptor column, T object, Functions.Function0<? extends Boolean> fillCondition, Functions.Function1<? super T, ? extends List<String>> sequence, Comparator<String> comparator, String separator, String tableShortcut) {
        try {
            Boolean _apply = (Boolean)fillCondition.apply();
            if (_apply.booleanValue()) {
                Functions.Function1 _function = it -> it;
                this.fillIterable(row, column, object, sequence, comparator, _function, separator);
                return;
            }
            Functions.Function1 _function_1 = it -> "\u23f3";
            this.fill(row, column, object, _function_1);
            Runnable _function_2 = () -> {
                ArrayList changeProperty = CollectionLiterals.newArrayList();
                try {
                    while (!((Boolean)fillCondition.apply()).booleanValue()) {
                        Thread.sleep(5000L);
                    }
                    List result = (List)sequence.apply((Object)object);
                    if (comparator == null) {
                        IterableExtensions.sortWith((Iterable)result, (Comparator)ToolboxConstants.LST_OBJECT_NAME_COMPARATOR);
                    } else {
                        IterableExtensions.sortWith((Iterable)result, (Comparator)comparator);
                    }
                    MultiContainer_AttributeGroup _container = BasisAttributExtensions.getContainer((EObject)object);
                    List _list = IterableExtensions.toList((Iterable)result);
                    String _xifexpression = null;
                    boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)separator);
                    _xifexpression = _isNullOrEmpty ? AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR : separator;
                    Pt1TableChangeProperties _pt1TableChangeProperties = new Pt1TableChangeProperties(_container, row, column, _list, _xifexpression);
                    changeProperty.add(_pt1TableChangeProperties);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Exception e = (Exception)_t;
                        changeProperty.add(this.fillWaitingCellException(row, column, BasisAttributExtensions.getContainer((EObject)object), e));
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
                String _lowerCase = tableShortcut.toLowerCase();
                TableDataChangeEvent updateValueEvent = new TableDataChangeEvent(_lowerCase, (Object)changeProperty);
                TableDataChangeEvent.sendEvent((EventAdmin)this.eventAdmin, (TableDataChangeEvent)updateValueEvent);
            };
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(tableShortcut);
            _builder.append("/");
            _builder.append(FILL_DELAY_CELL_THREAD);
            _builder.append("/");
            String _label = column.getLabel();
            _builder.append(_label);
            _builder.append("/");
            String _cacheKey = CacheUtils.getCacheKey(object);
            _builder.append(_cacheKey);
            new Thread(_function_2, _builder.toString()).start();
        }
        catch (Throwable _t) {
            if (_t instanceof Exception) {
                Exception e = (Exception)_t;
                this.handleFillingException(e, row, column);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public <S, T extends Ur_Objekt> void fillIterableMultiCellWhenAllowed(TableRow row, ColumnDescriptor column, T object, Functions.Function0<? extends Boolean> fillCondition, Functions.Function1<? super T, ? extends String> filling) {
        Functions.Function1 _function = it -> {
            String _apply = (String)filling.apply(it);
            return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_apply}));
        };
        this.fillIterableMultiCellWhenAllow(row, column, object, fillCondition, _function, null, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
    }

    public <S, T extends Ur_Objekt> void fillIterableMultiCellWhenAllow(TableRow row, ColumnDescriptor column, T object, final Functions.Function0<? extends Boolean> fillCondition, final Functions.Function1<? super T, ? extends List<String>> sequence, Comparator<String> comparator, String separator) {
        Boolean _apply = (Boolean)fillCondition.apply();
        if (_apply.booleanValue()) {
            Functions.Function1 _function = it -> it;
            this.fillIterable(row, column, object, sequence, comparator, _function, separator);
            return;
        }
        Functions.Function1 _function_1 = it -> "\u23f3";
        this.fill(row, column, object, _function_1);
        WaitFillingCell<T> _waitFillingCell = new WaitFillingCell<T>(column, row, object, new Function<T, List<String>>(){

            @Override
            public List<String> apply(T arg0) {
                return (List)sequence.apply(arg0);
            }
        }, new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                return (Boolean)fillCondition.apply();
            }
        });
        this.delayFillingCells.add(_waitFillingCell);
    }

    public void updateWaitingFillCell(String tableShortcut) {
        boolean _isNullOrEmpty = IterableExtensions.isNullOrEmpty(this.delayFillingCells);
        if (_isNullOrEmpty) {
            return;
        }
        Runnable _function = () -> {
            ArrayList changeProperties = CollectionLiterals.newArrayList();
            while (!IterableExtensions.isNullOrEmpty(this.delayFillingCells)) {
                try {
                    Functions.Function1 _function_1 = it -> it.getShouldFill();
                    Consumer<WaitFillingCell> _function_2 = it -> {
                        MultiContainer_AttributeGroup container = BasisAttributExtensions.getContainer(it.getObject());
                        try {
                            TableRow _row = it.getRow();
                            ColumnDescriptor _column = it.getColumn();
                            List<String> _fillValue = it.getFillValue();
                            Pt1TableChangeProperties _pt1TableChangeProperties = new Pt1TableChangeProperties(container, _row, _column, _fillValue, AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
                            changeProperties.add(_pt1TableChangeProperties);
                        }
                        catch (Throwable _t) {
                            if (_t instanceof Exception) {
                                Exception e = (Exception)_t;
                                changeProperties.add(this.fillWaitingCellException(it.getRow(), it.getColumn(), container, e));
                            }
                            throw Exceptions.sneakyThrow((Throwable)_t);
                        }
                    };
                    IterableExtensions.filter(this.delayFillingCells, (Functions.Function1)_function_1).forEach(_function_2);
                    Predicate<WaitFillingCell> _function_3 = cell -> {
                        Functions.Function1 _function_4 = property -> cell.getColumn() == property.getChangeDataColumn() && Objects.equals(cell.getRow(), property.getRow());
                        return IterableExtensions.exists((Iterable)changeProperties, (Functions.Function1)_function_4);
                    };
                    this.delayFillingCells.removeIf(_function_3);
                    Thread.sleep(5000L);
                }
                catch (Throwable _t) {
                    if (_t instanceof Exception) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            String _lowerCase = tableShortcut.toLowerCase();
            TableDataChangeEvent updateTableEvent = new TableDataChangeEvent(_lowerCase, (Object)changeProperties);
            TableDataChangeEvent.sendEvent((EventAdmin)this.eventAdmin, (TableDataChangeEvent)updateTableEvent);
        };
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(tableShortcut);
        _builder.append("/");
        _builder.append(FILL_DELAY_CELL_THREAD);
        new Thread(_function, _builder.toString()).start();
    }

    private Pt1TableChangeProperties fillWaitingCellException(TableRow row, ColumnDescriptor column, MultiContainer_AttributeGroup container, Exception e) {
        String errorMsg = this.createErrorMsg(e, row);
        Ur_Objekt _leadingObject = TableRowExtensions.getGroup((TableRow)row).getLeadingObject();
        Identitaet_TypeClass _identitaet = null;
        if (_leadingObject != null) {
            _identitaet = _leadingObject.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        String guid = _wert;
        String leadingObject = this.getLeadingObjectIdentifier(row, guid);
        TableError _tableError = new TableError(guid, leadingObject, "", errorMsg, row);
        this.tableErrors.add(_tableError);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Error: ");
        _builder.append(errorMsg);
        return new Pt1TableChangeProperties(container, row, column, Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new String[]{_builder.toString()})), AbstractTableModelTransformator.ITERABLE_FILLING_SEPARATOR);
    }

    public Map<TableRow, Set<ColumnDescriptor>> getTopologicalCells() {
        return this.topologicalCells;
    }

    protected void addTopologicalCell(TableRow row, ColumnDescriptor col) {
        boolean _containsKey = this.topologicalCells.containsKey(row);
        if (_containsKey) {
            this.topologicalCells.get(row).add(col);
        } else {
            this.topologicalCells.put(row, CollectionLiterals.newHashSet((Object[])new ColumnDescriptor[]{col}));
        }
    }
}

