/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.application.parts;

import com.google.common.collect.Lists;
import jakarta.inject.Inject;
import java.util.List;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.core.services.nls.Translation;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.set.application.Messages;
import org.eclipse.set.basis.Translateable;
import org.eclipse.set.basis.constants.ContainerType;
import org.eclipse.set.basis.constants.PlanProFileNature;
import org.eclipse.set.basis.files.AttachmentContentService;
import org.eclipse.set.core.services.configurationservice.UserConfigurationService;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.core.services.part.ToolboxPartService;
import org.eclipse.set.core.services.pdf.PdfRendererService;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.PlanPro.Container_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.AnhangTransformation;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.RefreshAction;
import org.eclipse.set.utils.SelectableAction;
import org.eclipse.set.utils.attachment.AttachmentModelProvider;
import org.eclipse.set.utils.events.ContainerDataChanged;
import org.eclipse.set.utils.events.ProjectDataChanged;
import org.eclipse.set.utils.widgets.AttachmentTable;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class AttachmentPart
extends BasePart {
    private static final String HEADING_PATTERN = "%s (%s)";
    @Inject
    private AttachmentContentService contentService;
    private AttachmentTable domainTableFinal;
    private AttachmentTable domainTableInitial;
    private AttachmentTable domainTableSingle;
    private AttachmentTable objectTable;
    @Optional
    @Inject
    private PdfRendererService rendererService;
    @Inject
    private EnumTranslationService translationService;
    @Inject
    @Translation
    Messages messages;
    @Inject
    ToolboxPartService partService;
    @Inject
    UserConfigurationService userConfigService;
    @Inject
    @Translation
    org.eclipse.set.utils.Messages utilMessages;

    @Inject
    public AttachmentPart() {
    }

    private AttachmentTable createAttachmentTableViewerWidget(Composite parent, List<Anhang> model) {
        AttachmentTable attachmentTable = new AttachmentTable(parent, this.utilMessages, this.contentService, this.getDialogService(), this.getModelSession().getToolboxFile(), this.userConfigService);
        AnhangTransformation transformation = AnhangTransformation.createTransformation((EnumTranslationService)this.translationService, (AttachmentContentService)this.contentService);
        attachmentTable.setModel(transformation.toAttachment(model));
        attachmentTable.setTempDir(this.getModelSession().getTempDir().toString());
        if (this.rendererService != null) {
            attachmentTable.setAttachmentViewer(path -> this.partService.showAttachmentPart(path));
        }
        attachmentTable.createControl();
        return attachmentTable;
    }

    protected void createView(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)scrolledComposite);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setAlwaysShowScrollBars(false);
        Composite viewComposite = new Composite((Composite)scrolledComposite, 0);
        viewComposite.setLayout((Layout)new GridLayout());
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)viewComposite);
        scrolledComposite.setContent((Control)viewComposite);
        this.createViewContent(viewComposite);
        scrolledComposite.setMinSize(this.objectTable.getTableParent().computeSize(-1, -1));
    }

    private void createViewContent(Composite parent) {
        GridLayout layout = new GridLayout(2, false);
        parent.setLayout((Layout)layout);
        parent.setLayoutData((Object)new GridData(1, 1, true, false, 3, 2));
        AttachmentModelProvider modelProvider = new AttachmentModelProvider(this.getModelSession());
        Label objectMgmtHeader = new Label(parent, 0);
        GridData gridData = new GridData(1, 1, true, false, 3, 1);
        objectMgmtHeader.setLayoutData((Object)gridData);
        objectMgmtHeader.setText(this.messages.AttachmentPart_AttachmentsInObjectmanagement);
        this.objectTable = this.createAttachmentTableViewerWidget(parent, modelProvider.getObjectManagementAttachments());
        if (Lists.newArrayList((Object[])new PlanProFileNature[]{PlanProFileNature.INTEGRATION, PlanProFileNature.PLANNING}).contains(this.getModelSession().getNature())) {
            Label initialHeader = new Label(parent, 0);
            GridData domainHeaderGridData = new GridData(1, 1, true, false, 2, 1);
            initialHeader.setLayoutData((Object)domainHeaderGridData);
            String containerInitialName = this.translationService.translate((Translateable)ContainerType.INITIAL).getPresentation();
            initialHeader.setText(String.format(HEADING_PATTERN, this.messages.AttachmentPart_AttachmentsInDomain, containerInitialName));
            this.domainTableInitial = this.createAttachmentTableViewerWidget(parent, modelProvider.getDomainAttachmentsInitial());
            Label finalHeader = new Label(parent, 0);
            GridDataFactory.swtDefaults().align(1, 1).grab(true, false).span(2, 1).applyTo((Control)finalHeader);
            String containerFinalName = this.translationService.translate((Translateable)ContainerType.FINAL).getPresentation();
            finalHeader.setText(String.format(HEADING_PATTERN, this.messages.AttachmentPart_AttachmentsInDomain, containerFinalName));
            this.domainTableFinal = this.createAttachmentTableViewerWidget(parent, modelProvider.getDomainAttachmentsFinal());
        } else {
            Label singleHeader = new Label(parent, 0);
            GridDataFactory.swtDefaults().align(1, 1).grab(true, false).span(2, 1).applyTo((Control)singleHeader);
            String containerSingleName = this.translationService.translate((Translateable)ContainerType.SINGLE).getPresentation();
            singleHeader.setText(String.format(HEADING_PATTERN, this.messages.AttachmentPart_AttachmentsInDomain, containerSingleName));
            this.domainTableSingle = this.createAttachmentTableViewerWidget(parent, modelProvider.getDomainAttachmentsSingle());
        }
    }

    protected SelectableAction getOutdatedAction() {
        return new RefreshAction((BasePart)this, e -> {
            this.updateTables();
            this.setOutdated(false);
        });
    }

    protected void handleContainerDataChanged(ContainerDataChanged e) {
        if (e.getContainer() == this.getContainerInFocus()) {
            this.setOutdated(true);
        }
    }

    protected void handleProjectDataChanged(ProjectDataChanged e) {
        this.setOutdated(true);
    }

    protected void updateViewContainerDataChanged(List<Container_AttributeGroup> container) {
        if (this.isOutdated()) {
            this.updateTables();
        }
        this.setOutdated(false);
    }

    protected void updateViewProjectDataChanged(List<Notification> notifications) {
        if (this.isOutdated()) {
            this.updateTables();
        }
        this.setOutdated(false);
    }

    void updateTables() {
        List domainAttachments;
        AnhangTransformation transformation = AnhangTransformation.createTransformation((EnumTranslationService)this.translationService, (AttachmentContentService)this.contentService);
        AttachmentModelProvider modelProvider = new AttachmentModelProvider(this.getModelSession());
        if (this.domainTableInitial != null) {
            domainAttachments = modelProvider.getDomainAttachmentsInitial();
            this.domainTableInitial.updateModel(transformation.toAttachment(domainAttachments));
        }
        if (this.domainTableFinal != null) {
            domainAttachments = modelProvider.getDomainAttachmentsFinal();
            this.domainTableFinal.updateModel(transformation.toAttachment(domainAttachments));
        }
        if (this.domainTableSingle != null) {
            domainAttachments = modelProvider.getDomainAttachmentsSingle();
            this.domainTableSingle.updateModel(transformation.toAttachment(domainAttachments));
        }
        List objectAttachments = modelProvider.getObjectManagementAttachments();
        this.objectTable.updateModel(transformation.toAttachment(objectAttachments));
    }
}

