/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.overview;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.layer.cell.ILayerCell;
import org.eclipse.set.basis.files.ToolboxFile;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.table.messages.Messages;
import org.eclipse.set.feature.table.overview.TableErrorTransformationService;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.tablemodel.RowGroup;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.utils.BasePart;
import org.eclipse.set.utils.events.JumpToSiteplanEvent;
import org.eclipse.set.utils.events.JumpToSourceLineEvent;
import org.eclipse.set.utils.events.JumpToTableEvent;
import org.eclipse.set.utils.table.TableError;
import org.eclipse.set.utils.table.TableInfo;
import org.eclipse.set.utils.table.menu.TableMenuService;
import org.eclipse.set.utils.table.sorting.AbstractSortByColumnTables;
import org.eclipse.set.utils.xml.XMLNodeFinder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TableErrorTableView
extends AbstractSortByColumnTables {
    private final Messages messages;
    private NatTable natTable;
    private Collection<TableError> tableErrors = new ArrayList<TableError>();
    private final EnumTranslationService enumTranslationService;
    private final TableMenuService tableMenuService;
    private final BasePart part;
    private final XMLNodeFinder xmlNodeFinder;

    public TableErrorTableView(Messages messages, BasePart part, EnumTranslationService enumTranslationService, TableMenuService tableMenuService) {
        this.messages = messages;
        this.enumTranslationService = enumTranslationService;
        this.tableMenuService = tableMenuService;
        this.part = part;
        ToolboxFile toolboxFile = part.getModelSession().getToolboxFile();
        this.xmlNodeFinder = new XMLNodeFinder();
        this.xmlNodeFinder.read(toolboxFile, toolboxFile.getModelPath());
    }

    public Control create(Composite parent) {
        Table table = this.getTable();
        this.createTableBodyData(table, rowIndex -> rowIndex);
        this.addMenuItems();
        this.natTable = this.createTable(parent, table);
        return this.natTable;
    }

    public void updateView(Collection<TableError> errors) {
        this.tableErrors = errors;
        if (this.natTable != null) {
            this.bodyDataProvider.refresh(this.getTable());
            this.natTable.refresh();
        }
    }

    private Table getTable() {
        TableErrorTransformationService service = new TableErrorTransformationService(this.messages, this.enumTranslationService);
        Table table = service.transform(this.tableErrors);
        ECollections.sort((EList)table.getTablecontent().getRowgroups(), service.getRowGroupComparator());
        return table;
    }

    private void addMenuItems() {
        this.tableMenuService.addMenuItem(this.tableMenuService.createShowInTableItem(this.createJumpToTableEvent(), this.getSelectionLayer(), position -> {
            String shortCut = this.getRowReferenceTable(position);
            return shortCut != null && !shortCut.isEmpty();
        }));
        this.tableMenuService.addMenuItem(this.tableMenuService.createShowInTextViewItem(this.createJumpToTextViewEvent(this.part), this.getSelectionLayer(), rowPosition -> this.getRowReferenceObjectGuid(rowPosition) != null));
        this.tableMenuService.addMenuItem(this.tableMenuService.createShowInSitePlanItem(this.creataJumpToSiteplanEvent(), this.getSelectionLayer(), rowPosition -> {
            String guid = this.getRowReferenceObjectGuid(rowPosition);
            return guid != null && Services.getSiteplanService().isSiteplanElement(guid);
        }));
    }

    private JumpToTableEvent createJumpToTableEvent() {
        return new JumpToTableEvent(){

            public String getSearchKey() {
                return TableErrorTableView.this.getSelectedObjectGuid();
            }

            public String getTableShortcut() {
                int selectionRowPosition = TableErrorTableView.this.getSelectionRowPosition();
                if (selectionRowPosition == -1) {
                    return null;
                }
                return TableErrorTableView.this.getRowReferenceTable(selectionRowPosition);
            }

            public String getTableCategory() {
                if (TableErrorTableView.this.part.getToolboxPart().getElementId().startsWith("org.eclipse.set.feature.table.estw")) {
                    return TableInfo.Pt1TableCategory.ESTW.getId();
                }
                return TableInfo.Pt1TableCategory.ETCS.getId();
            }
        };
    }

    protected JumpToSourceLineEvent createJumpToTextViewEvent(BasePart basePart) {
        return new JumpToSourceLineEvent(basePart){

            public String getObjectGuid() {
                return TableErrorTableView.this.getSelectedObjectGuid();
            }
        };
    }

    protected JumpToSiteplanEvent creataJumpToSiteplanEvent() {
        return new JumpToSiteplanEvent(){

            public String getGuid() {
                return TableErrorTableView.this.getSelectedObjectGuid();
            }
        };
    }

    protected TableMenuService getTableMenuService() {
        return this.tableMenuService;
    }

    protected XMLNodeFinder getXMLNodeFinder() {
        return this.xmlNodeFinder;
    }

    private String getSelectedObjectGuid() {
        int selectionRowPosition = this.getSelectionRowPosition();
        if (selectionRowPosition == -1) {
            return null;
        }
        return this.getRowReferenceObjectGuid(selectionRowPosition);
    }

    private int getSelectionRowPosition() {
        Collection selectedCells = this.bodyLayerStack.getSelectionLayer().getSelectedCells();
        if (selectedCells.isEmpty()) {
            return -1;
        }
        return ((ILayerCell)selectedCells.iterator().next()).getRowPosition();
    }

    private String getRowReferenceTable(int rowPosition) {
        try {
            return this.getSelectedError(rowPosition).getSource();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private String getRowReferenceObjectGuid(int rowPosition) {
        try {
            return this.getSelectedError(rowPosition).getGuid();
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    private TableError getSelectedError(int rowPosition) {
        RowGroup group = TableRowExtensions.getGroup((TableRow)this.bodyDataProvider.getRow(rowPosition).getRow());
        Ur_Objekt ur_Objekt = group.getLeadingObject();
        if (ur_Objekt instanceof TableError) {
            TableError error = (TableError)ur_Objekt;
            return error;
        }
        return null;
    }

    protected String getCSVHeaderPattern() {
        return null;
    }

    public void exportCsv() {
    }
}

