/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.text;

import com.google.common.collect.Lists;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.set.utils.text.TagRule;

public class AttributeRule
implements IRule {
    private final IToken successToken;
    private final TagRule tagRule;

    private static boolean findEquals(ICharacterScanner scanner) {
        int i = 0;
        int c = scanner.read();
        while (c != 61) {
            ++i;
            if (AttributeRule.isBreak((char)c)) {
                int j = 0;
                while (j < i) {
                    scanner.unread();
                    ++j;
                }
                return false;
            }
            c = scanner.read();
        }
        scanner.unread();
        return true;
    }

    private static boolean isBreak(char c) {
        return Lists.newArrayList((Object[])new Character[]{Character.valueOf('\"'), Character.valueOf('\''), Character.valueOf('>')}).contains(Character.valueOf(c));
    }

    public AttributeRule(TagRule tagRule, IToken successToken) {
        this.tagRule = tagRule;
        this.successToken = successToken;
    }

    public IToken evaluate(ICharacterScanner scanner) {
        if (!this.tagRule.isOpen()) {
            return Token.UNDEFINED;
        }
        int read = scanner.read();
        if (Character.isAlphabetic(read) && AttributeRule.findEquals(scanner)) {
            return this.successToken;
        }
        scanner.unread();
        return Token.UNDEFINED;
    }
}

