/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils;

import java.awt.Desktop;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.set.browser.Browser;
import org.eclipse.set.browser.cef.ChromiumStatic;
import org.eclipse.set.browser.swt.BrowserFunction;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class WebBrowser {
    private final Browser browser;
    private final List<BrowserFunction> browserFunctions = new ArrayList<BrowserFunction>();

    public WebBrowser(Composite parent) {
        if (ToolboxConfiguration.isDevelopmentMode()) {
            ChromiumStatic.getCEFConfiguration().DebugPort = 9999;
        }
        this.browser = this.createBrowser(parent);
    }

    private Browser createBrowser(Composite parent) {
        Browser browserInstance = new Browser(parent, 0);
        browserInstance.setJavascriptEnabled(true);
        browserInstance.addLocationListener(new LocationListener(){

            public void changing(LocationEvent event) {
                WebBrowser.this.onLocationChange(event);
            }

            public void changed(LocationEvent event) {
            }
        });
        browserInstance.addOpenWindowListener(event -> {
            if (event.browser == null) {
                event.browser = this.createBrowser(parent);
            }
        });
        return browserInstance;
    }

    private void onLocationChange(LocationEvent event) {
        event.doit = this.isURLAllowed(event.location);
        if (!event.doit && Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            try {
                Desktop.getDesktop().browse(new URI(event.location));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected List<String> getAllowedPrefixes() {
        return List.of("file://", "http://localhost:", "http://localhost/", "chrome://");
    }

    private boolean isURLAllowed(String url) {
        List<String> allowedPrefixes = this.getAllowedPrefixes();
        return allowedPrefixes.stream().anyMatch(url::startsWith);
    }

    public void executeJavascript(String javascript) {
        this.browser.execute(javascript);
    }

    public Browser getBrowser() {
        return this.browser;
    }

    public Control getControl() {
        return this.getBrowser();
    }

    public void registerJSFunction(BrowserFunction browserFunction) {
        this.browserFunctions.add(browserFunction);
    }

    public <R> void registerJSFunction(String name, final Function<String, R> function) {
        this.browserFunctions.add(new BrowserFunction((org.eclipse.set.browser.swt.Browser)this.browser, name){

            public final Object function(Object[] arguments) {
                if (arguments.length != 1 && !(arguments[0] instanceof String)) {
                    throw new RuntimeException("Incorrect parameter.");
                }
                return function.apply((String)arguments[0]);
            }
        });
    }

    public void setLayoutData(GridData gridData) {
        this.browser.setLayoutData((Object)gridData);
    }

    public void setUrl(String url) {
        this.browser.setUrl(url);
    }

    public void refresh() {
        this.browser.refresh();
    }

    public void stop() {
        for (BrowserFunction function : this.browserFunctions) {
            function.dispose();
        }
    }
}

