/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import org.eclipse.set.basis.geometry.GeometryOptionsBuilder;

public class GeometryCalculationOptions {
    private static final int DEFAULT_BLOSS_SEGMENTS_MIN = 10;
    private static final double DEFAULT_BLOSS_SEGMENTS_PER_LENGTH = 0.5;
    private static final int DEFAULT_BLOSS_PRECISION = 20;
    private static final int DEFAULT_CLOTHOID_SEGMENTS_MIN = 10;
    private static final double DEFAULT_CLOTHOID_SEGMENTS_PER_LENGTH = 0.5;
    private static final int DEFAULT_CLOTHOID_PRECISION = 5;
    private final GeometryOptionsBuilder.GeometryOptions chordOptions;
    private final GeometryOptionsBuilder.GeometryOptions blossOptions;
    private final GeometryOptionsBuilder.GeometryOptions clothoidOptions;

    public GeometryCalculationOptions(GeometryOptionsBuilder.GeometryOptions chordOptions, GeometryOptionsBuilder.GeometryOptions blossOptions, GeometryOptionsBuilder.GeometryOptions clothoidOptions) {
        this.chordOptions = chordOptions;
        this.blossOptions = blossOptions;
        this.clothoidOptions = clothoidOptions;
    }

    public GeometryOptionsBuilder.GeometryOptions getChordOptions() {
        return this.chordOptions;
    }

    public GeometryOptionsBuilder.GeometryOptions getBlossOptions() {
        return this.blossOptions;
    }

    public GeometryOptionsBuilder.GeometryOptions getClothoidOptions() {
        return this.clothoidOptions;
    }

    public static GeometryCalculationOptions getDefaultOptions() {
        return new GeometryCalculationOptionsBuilder().build();
    }

    public static class GeometryCalculationOptionsBuilder {
        private GeometryOptionsBuilder.GeometryOptions chordOptionsBuilder = new GeometryOptionsBuilder().build();
        private GeometryOptionsBuilder.GeometryOptions blossOptionsBuilder = new GeometryOptionsBuilder().setStepSize(0.5).setAccuracy(20).setSegmentCount(10).build();
        private GeometryOptionsBuilder.GeometryOptions clothoidOptionsBuilder = new GeometryOptionsBuilder().setSegmentCount(10).setAccuracy(5).setStepSize(0.5).build();

        public GeometryCalculationOptionsBuilder setChordOptions(GeometryOptionsBuilder.GeometryOptions chordOptions) {
            this.chordOptionsBuilder = chordOptions;
            return this;
        }

        public GeometryCalculationOptionsBuilder setBlossOptions(GeometryOptionsBuilder.GeometryOptions blossOptions) {
            this.blossOptionsBuilder = blossOptions;
            return this;
        }

        public GeometryCalculationOptionsBuilder setClothoidOptions(GeometryOptionsBuilder.GeometryOptions clothoidOptions) {
            this.clothoidOptionsBuilder = clothoidOptions;
            return this;
        }

        public GeometryCalculationOptions build() {
            return new GeometryCalculationOptions(this.chordOptionsBuilder, this.blossOptionsBuilder, this.clothoidOptionsBuilder);
        }
    }
}

