/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import java.awt.Dimension;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.FileImageInputStream;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.set.basis.IModelSession;
import org.eclipse.set.basis.files.ToolboxFileRole;
import org.eclipse.set.core.services.session.SessionService;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang;
import org.eclipse.set.model.planpro.Basisobjekte.Anhang_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.Basisobjekte.Dateiname_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.Dateityp_TypeClass;
import org.eclipse.set.model.planpro.Basisobjekte.ENUMDateityp;
import org.eclipse.set.model.planpro.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Adresse_PLZ_Ort_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Adresse_Strasse_Nr_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Akteur;
import org.eclipse.set.model.planpro.PlanPro.Akteur_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Akteur_Zuordnung;
import org.eclipse.set.model.planpro.PlanPro.Bauzustand_Kurzbezeichnung_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bezeichnung_Anlage_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Bezeichnung_Unteranlage_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Datum_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.E_Mail_Adresse_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Index_Ausgabe_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Laufende_Nummer_Ausgabe_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Name_Akteur_5_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Name_Akteur_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Name_Organisation_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Organisation;
import org.eclipse.set.model.planpro.PlanPro.Organisationseinheit_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle;
import org.eclipse.set.model.planpro.PlanPro.PlanPro_Schnittstelle_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_E_Allg_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_E_Handlung_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Einzel;
import org.eclipse.set.model.planpro.PlanPro.Planung_G_Schriftfeld_AttributeGroup;
import org.eclipse.set.model.planpro.PlanPro.Planung_Gruppe;
import org.eclipse.set.model.planpro.PlanPro.Planung_Projekt;
import org.eclipse.set.model.planpro.PlanPro.Referenz_Planung_Basis_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Telefonnummer_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Werkzeug_Name_TypeClass;
import org.eclipse.set.model.planpro.PlanPro.Werkzeug_Version_TypeClass;
import org.eclipse.set.model.titlebox.PlanningOffice;
import org.eclipse.set.model.titlebox.StringField;
import org.eclipse.set.model.titlebox.Titlebox;
import org.eclipse.set.model.titlebox.TitleboxFactory;
import org.eclipse.set.model.titlebox.extensions.TitleboxExtensions;
import org.eclipse.set.ppmodel.extensions.PlanProSchnittstelleExtensions;
import org.eclipse.set.ppmodel.extensions.PlanungProjektExtensions;
import org.eclipse.set.ppmodel.extensions.utils.TableNameInfo;
import org.eclipse.set.ppmodel.extensions.utils.XMLGregorianCalendarExtensions;
import org.eclipse.set.utils.ToolboxConfiguration;
import org.eclipse.set.utils.ToolboxVersion;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class PlanProToTitleboxTransformation {
    private static final String EMPTY_EDITION_NUMBER = "";
    private static final String DATE_FORMAT = "dd.MM.yy";
    private static final String DATE_FORMAT_LONG = "dd.MM.yyyy";
    public static final String DATE_FORMAT_SHORT = "MM/yy";
    private static final String EMPTY_PLANNING_NUMBER = "<Plannummer DB AG>";
    private static final int SMALL_FELD_MAX_LENGTH = 7;
    private static final String ZERO_WIDTH_SPACE = "\u200b";
    private PlanPro_Schnittstelle mainSchnittstelle;
    private PlanPro_Schnittstelle compareSchnittstelle;
    private final HashMap<ArrayList<?>, Titlebox> _createCache_transform = CollectionLiterals.newHashMap();

    public PlanProToTitleboxTransformation(SessionService sessionService) {
        IModelSession _loadedSession = sessionService.getLoadedSession(ToolboxFileRole.SESSION);
        PlanPro_Schnittstelle _planProSchnittstelle = null;
        if (_loadedSession != null) {
            _planProSchnittstelle = _loadedSession.getPlanProSchnittstelle();
        }
        this.mainSchnittstelle = _planProSchnittstelle;
        IModelSession _loadedSession_1 = sessionService.getLoadedSession(ToolboxFileRole.COMPARE_PLANNING);
        PlanPro_Schnittstelle _planProSchnittstelle_1 = null;
        if (_loadedSession_1 != null) {
            _planProSchnittstelle_1 = _loadedSession_1.getPlanProSchnittstelle();
        }
        this.compareSchnittstelle = _planProSchnittstelle_1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Titlebox transform(TableNameInfo tableName, Function<String, Path> attachmentPathProvider) {
        Titlebox _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{tableName, attachmentPathProvider});
        HashMap<ArrayList<?>, Titlebox> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            Titlebox _createTitlebox;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _createTitlebox = TitleboxFactory.eINSTANCE.createTitlebox();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, tableName, attachmentPathProvider);
        return _result;
    }

    private void _init_transform(Titlebox it, TableNameInfo tableName, Function<String, Path> attachmentPathProvider) {
        String idPlanungBasis;
        TitleboxExtensions.resetFields((Titlebox)it);
        Planung_Projekt _LSTPlanungProjekt = null;
        if (this.mainSchnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(this.mainSchnittstelle);
        }
        Planung_Gruppe _leadingPlanungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _leadingPlanungGruppe = PlanungProjektExtensions.getLeadingPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_G_Schriftfeld_AttributeGroup _planungGSchriftfeld = null;
        if (_leadingPlanungGruppe != null) {
            _planungGSchriftfeld = _leadingPlanungGruppe.getPlanungGSchriftfeld();
        }
        this.addFieldsFrom(it, _planungGSchriftfeld, tableName, attachmentPathProvider);
        Planung_Einzel _planungEinzel = null;
        if (this.mainSchnittstelle != null) {
            _planungEinzel = this.getPlanungEinzel(this.mainSchnittstelle);
        }
        Planung_Einzel planungEinzel = _planungEinzel;
        Planung_E_Handlung_AttributeGroup _planungEHandlung = null;
        if (planungEinzel != null) {
            _planungEHandlung = planungEinzel.getPlanungEHandlung();
        }
        EList _planungEErstellung = null;
        if (_planungEHandlung != null) {
            _planungEErstellung = _planungEHandlung.getPlanungEErstellung();
        }
        Akteur_Zuordnung _lastOrNull = null;
        if (_planungEErstellung != null) {
            _lastOrNull = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEErstellung);
        }
        Akteur_Zuordnung lastPlanungEErstellung = _lastOrNull;
        String _elvis = null;
        Datum_TypeClass _datum = null;
        if (lastPlanungEErstellung != null) {
            _datum = lastPlanungEErstellung.getDatum();
        }
        XMLGregorianCalendar _wert = null;
        if (_datum != null) {
            _wert = _datum.getWert();
        }
        String _string = null;
        if (_wert != null) {
            _string = XMLGregorianCalendarExtensions.toString(_wert, DATE_FORMAT_LONG);
        }
        _elvis = _string != null ? _string : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)83, (String)_elvis);
        String _elvis_1 = null;
        Akteur _handelnder = null;
        if (lastPlanungEErstellung != null) {
            _handelnder = lastPlanungEErstellung.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg = null;
        if (_handelnder != null) {
            _akteurAllg = _handelnder.getAkteurAllg();
        }
        Name_Akteur_TypeClass _nameAkteur = null;
        if (_akteurAllg != null) {
            _nameAkteur = _akteurAllg.getNameAkteur();
        }
        String _wert_1 = null;
        if (_nameAkteur != null) {
            _wert_1 = _nameAkteur.getWert();
        }
        _elvis_1 = _wert_1 != null ? _wert_1 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)84, (String)_elvis_1);
        Planung_E_Handlung_AttributeGroup _planungEHandlung_1 = null;
        if (planungEinzel != null) {
            _planungEHandlung_1 = planungEinzel.getPlanungEHandlung();
        }
        EList _planungEQualitaetspruefung = null;
        if (_planungEHandlung_1 != null) {
            _planungEQualitaetspruefung = _planungEHandlung_1.getPlanungEQualitaetspruefung();
        }
        Akteur_Zuordnung _lastOrNull_1 = null;
        if (_planungEQualitaetspruefung != null) {
            _lastOrNull_1 = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEQualitaetspruefung);
        }
        Akteur_Zuordnung lastQualitaetPruefung = _lastOrNull_1;
        String _elvis_2 = null;
        Datum_TypeClass _datum_1 = null;
        if (lastQualitaetPruefung != null) {
            _datum_1 = lastQualitaetPruefung.getDatum();
        }
        XMLGregorianCalendar _wert_2 = null;
        if (_datum_1 != null) {
            _wert_2 = _datum_1.getWert();
        }
        String _string_1 = null;
        if (_wert_2 != null) {
            _string_1 = XMLGregorianCalendarExtensions.toString(_wert_2, DATE_FORMAT_LONG);
        }
        _elvis_2 = _string_1 != null ? _string_1 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)88, (String)_elvis_2);
        String _elvis_3 = null;
        Akteur _handelnder_1 = null;
        if (lastQualitaetPruefung != null) {
            _handelnder_1 = lastQualitaetPruefung.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg_1 = null;
        if (_handelnder_1 != null) {
            _akteurAllg_1 = _handelnder_1.getAkteurAllg();
        }
        Name_Akteur_TypeClass _nameAkteur_1 = null;
        if (_akteurAllg_1 != null) {
            _nameAkteur_1 = _akteurAllg_1.getNameAkteur();
        }
        String _wert_3 = null;
        if (_nameAkteur_1 != null) {
            _wert_3 = _nameAkteur_1.getWert();
        }
        _elvis_3 = _wert_3 != null ? _wert_3 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)89, (String)_elvis_3);
        Planung_E_Handlung_AttributeGroup _planungEHandlung_2 = null;
        if (planungEinzel != null) {
            _planungEHandlung_2 = planungEinzel.getPlanungEHandlung();
        }
        EList _planungEFreigabe = null;
        if (_planungEHandlung_2 != null) {
            _planungEFreigabe = _planungEHandlung_2.getPlanungEFreigabe();
        }
        Akteur_Zuordnung _lastOrNull_2 = null;
        if (_planungEFreigabe != null) {
            _lastOrNull_2 = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEFreigabe);
        }
        Akteur_Zuordnung lastPlanungFreigabe = _lastOrNull_2;
        String _elvis_4 = null;
        Datum_TypeClass _datum_2 = null;
        if (lastPlanungFreigabe != null) {
            _datum_2 = lastPlanungFreigabe.getDatum();
        }
        XMLGregorianCalendar _wert_4 = null;
        if (_datum_2 != null) {
            _wert_4 = _datum_2.getWert();
        }
        String _string_2 = null;
        if (_wert_4 != null) {
            _string_2 = XMLGregorianCalendarExtensions.toString(_wert_4, DATE_FORMAT_LONG);
        }
        _elvis_4 = _string_2 != null ? _string_2 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)91, (String)_elvis_4);
        String _elvis_5 = null;
        Akteur _handelnder_2 = null;
        if (lastPlanungFreigabe != null) {
            _handelnder_2 = lastPlanungFreigabe.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg_2 = null;
        if (_handelnder_2 != null) {
            _akteurAllg_2 = _handelnder_2.getAkteurAllg();
        }
        Name_Akteur_TypeClass _nameAkteur_2 = null;
        if (_akteurAllg_2 != null) {
            _nameAkteur_2 = _akteurAllg_2.getNameAkteur();
        }
        String _wert_5 = null;
        if (_nameAkteur_2 != null) {
            _wert_5 = _nameAkteur_2.getWert();
        }
        _elvis_5 = _wert_5 != null ? _wert_5 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)92, (String)_elvis_5);
        Planung_E_Handlung_AttributeGroup _planungEHandlung_3 = null;
        if (planungEinzel != null) {
            _planungEHandlung_3 = planungEinzel.getPlanungEHandlung();
        }
        EList _planungEAbnahme = null;
        if (_planungEHandlung_3 != null) {
            _planungEAbnahme = _planungEHandlung_3.getPlanungEAbnahme();
        }
        Akteur_Zuordnung _lastOrNull_3 = null;
        if (_planungEAbnahme != null) {
            _lastOrNull_3 = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEAbnahme);
        }
        Akteur_Zuordnung lastPlanungAbnahme = _lastOrNull_3;
        Planung_E_Handlung_AttributeGroup _planungEHandlung_4 = null;
        if (planungEinzel != null) {
            _planungEHandlung_4 = planungEinzel.getPlanungEHandlung();
        }
        EList _planungEUebernahme = null;
        if (_planungEHandlung_4 != null) {
            _planungEUebernahme = _planungEHandlung_4.getPlanungEUebernahme();
        }
        Akteur_Zuordnung _lastOrNull_4 = null;
        if (_planungEUebernahme != null) {
            _lastOrNull_4 = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEUebernahme);
        }
        Akteur_Zuordnung lastPlanungUebernahme = _lastOrNull_4;
        Planung_E_Allg_AttributeGroup _planungAllgemein = null;
        if (this.mainSchnittstelle != null) {
            _planungAllgemein = this.getPlanungAllgemein(this.mainSchnittstelle);
        }
        Planung_E_Allg_AttributeGroup planungAllgemein = _planungAllgemein;
        String _referenzPlanungBasis = null;
        if (this.mainSchnittstelle != null) {
            _referenzPlanungBasis = this.getReferenzPlanungBasis(this.mainSchnittstelle);
        }
        if ((idPlanungBasis = _referenzPlanungBasis) != null) {
            TitleboxExtensions.set((Titlebox)it, (int)34, (String)this.getReferenzPlanungBasis(this.mainSchnittstelle));
            String _bauzustandPlanungEinzel = null;
            if (planungEinzel != null) {
                _bauzustandPlanungEinzel = this.getBauzustandPlanungEinzel(planungEinzel);
            }
            TitleboxExtensions.set((Titlebox)it, (int)35, (String)_bauzustandPlanungEinzel);
            String _elvis_6 = null;
            Akteur _handelnder_3 = null;
            if (lastPlanungEErstellung != null) {
                _handelnder_3 = lastPlanungEErstellung.getHandelnder();
            }
            Akteur_Allg_AttributeGroup _akteurAllg_3 = null;
            if (_handelnder_3 != null) {
                _akteurAllg_3 = _handelnder_3.getAkteurAllg();
            }
            Name_Akteur_5_TypeClass _nameAkteur5 = null;
            if (_akteurAllg_3 != null) {
                _nameAkteur5 = _akteurAllg_3.getNameAkteur5();
            }
            String _wert_6 = null;
            if (_nameAkteur5 != null) {
                _wert_6 = _nameAkteur5.getWert();
            }
            _elvis_6 = _wert_6 != null ? _wert_6 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)36, (String)_elvis_6);
            String _elvis_7 = null;
            Datum_TypeClass _datum_3 = null;
            if (lastPlanungEErstellung != null) {
                _datum_3 = lastPlanungEErstellung.getDatum();
            }
            XMLGregorianCalendar _wert_7 = null;
            if (_datum_3 != null) {
                _wert_7 = _datum_3.getWert();
            }
            String _string_3 = null;
            if (_wert_7 != null) {
                _string_3 = XMLGregorianCalendarExtensions.toString(_wert_7, DATE_FORMAT_SHORT);
            }
            _elvis_7 = _string_3 != null ? _string_3 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)43, (String)_elvis_7);
            String _elvis_8 = null;
            Akteur _handelnder_4 = null;
            if (lastQualitaetPruefung != null) {
                _handelnder_4 = lastQualitaetPruefung.getHandelnder();
            }
            Akteur_Allg_AttributeGroup _akteurAllg_4 = null;
            if (_handelnder_4 != null) {
                _akteurAllg_4 = _handelnder_4.getAkteurAllg();
            }
            Name_Akteur_5_TypeClass _nameAkteur5_1 = null;
            if (_akteurAllg_4 != null) {
                _nameAkteur5_1 = _akteurAllg_4.getNameAkteur5();
            }
            String _wert_8 = null;
            if (_nameAkteur5_1 != null) {
                _wert_8 = _nameAkteur5_1.getWert();
            }
            _elvis_8 = _wert_8 != null ? _wert_8 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)37, (String)_elvis_8);
            String _elvis_9 = null;
            Datum_TypeClass _datum_4 = null;
            if (lastQualitaetPruefung != null) {
                _datum_4 = lastQualitaetPruefung.getDatum();
            }
            XMLGregorianCalendar _wert_9 = null;
            if (_datum_4 != null) {
                _wert_9 = _datum_4.getWert();
            }
            String _string_4 = null;
            if (_wert_9 != null) {
                _string_4 = XMLGregorianCalendarExtensions.toString(_wert_9, DATE_FORMAT_SHORT);
            }
            _elvis_9 = _string_4 != null ? _string_4 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)44, (String)_elvis_9);
            String _elvis_10 = null;
            Akteur _handelnder_5 = null;
            if (lastPlanungAbnahme != null) {
                _handelnder_5 = lastPlanungAbnahme.getHandelnder();
            }
            Akteur_Allg_AttributeGroup _akteurAllg_5 = null;
            if (_handelnder_5 != null) {
                _akteurAllg_5 = _handelnder_5.getAkteurAllg();
            }
            Name_Akteur_5_TypeClass _nameAkteur5_2 = null;
            if (_akteurAllg_5 != null) {
                _nameAkteur5_2 = _akteurAllg_5.getNameAkteur5();
            }
            String _wert_10 = null;
            if (_nameAkteur5_2 != null) {
                _wert_10 = _nameAkteur5_2.getWert();
            }
            _elvis_10 = _wert_10 != null ? _wert_10 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)38, (String)_elvis_10);
            String _elvis_11 = null;
            Datum_TypeClass _datum_5 = null;
            if (lastPlanungAbnahme != null) {
                _datum_5 = lastPlanungAbnahme.getDatum();
            }
            XMLGregorianCalendar _wert_11 = null;
            if (_datum_5 != null) {
                _wert_11 = _datum_5.getWert();
            }
            String _string_5 = null;
            if (_wert_11 != null) {
                _string_5 = XMLGregorianCalendarExtensions.toString(_wert_11, DATE_FORMAT_SHORT);
            }
            _elvis_11 = _string_5 != null ? _string_5 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)45, (String)_elvis_11);
            String _elvis_12 = null;
            Akteur _handelnder_6 = null;
            if (lastPlanungUebernahme != null) {
                _handelnder_6 = lastPlanungUebernahme.getHandelnder();
            }
            Akteur_Allg_AttributeGroup _akteurAllg_6 = null;
            if (_handelnder_6 != null) {
                _akteurAllg_6 = _handelnder_6.getAkteurAllg();
            }
            Name_Akteur_5_TypeClass _nameAkteur5_3 = null;
            if (_akteurAllg_6 != null) {
                _nameAkteur5_3 = _akteurAllg_6.getNameAkteur5();
            }
            String _wert_12 = null;
            if (_nameAkteur5_3 != null) {
                _wert_12 = _nameAkteur5_3.getWert();
            }
            _elvis_12 = _wert_12 != null ? _wert_12 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)39, (String)_elvis_12);
            String _elvis_13 = null;
            Datum_TypeClass _datum_6 = null;
            if (lastPlanungUebernahme != null) {
                _datum_6 = lastPlanungUebernahme.getDatum();
            }
            XMLGregorianCalendar _wert_13 = null;
            if (_datum_6 != null) {
                _wert_13 = _datum_6.getWert();
            }
            String _string_6 = null;
            if (_wert_13 != null) {
                _string_6 = XMLGregorianCalendarExtensions.toString(_wert_13, DATE_FORMAT_SHORT);
            }
            _elvis_13 = _string_6 != null ? _string_6 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)46, (String)_elvis_13);
        }
        ToolboxVersion version = ToolboxConfiguration.getToolboxVersion();
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Geplant mit ");
        String _elvis_14 = null;
        PlanPro_Schnittstelle_Allg_AttributeGroup _planProSchnittstelleAllg = null;
        if (this.mainSchnittstelle != null) {
            _planProSchnittstelleAllg = this.mainSchnittstelle.getPlanProSchnittstelleAllg();
        }
        Werkzeug_Name_TypeClass _werkzeugName = null;
        if (_planProSchnittstelleAllg != null) {
            _werkzeugName = _planProSchnittstelleAllg.getWerkzeugName();
        }
        String _wert_14 = null;
        if (_werkzeugName != null) {
            _wert_14 = _werkzeugName.getWert();
        }
        _elvis_14 = _wert_14 != null ? _wert_14 : EMPTY_EDITION_NUMBER;
        _builder.append(_elvis_14);
        _builder.append(" ");
        String _elvis_15 = null;
        PlanPro_Schnittstelle_Allg_AttributeGroup _planProSchnittstelleAllg_1 = null;
        if (this.mainSchnittstelle != null) {
            _planProSchnittstelleAllg_1 = this.mainSchnittstelle.getPlanProSchnittstelleAllg();
        }
        Werkzeug_Version_TypeClass _werkzeugVersion = null;
        if (_planProSchnittstelleAllg_1 != null) {
            _werkzeugVersion = _planProSchnittstelleAllg_1.getWerkzeugVersion();
        }
        String _wert_15 = null;
        if (_werkzeugVersion != null) {
            _wert_15 = _werkzeugVersion.getWert();
        }
        _elvis_15 = _wert_15 != null ? _wert_15 : EMPTY_EDITION_NUMBER;
        _builder.append(_elvis_15);
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("Visualisiert mit ");
        String _shortName = ToolboxConfiguration.getShortName();
        _builder.append(_shortName, "\t\t");
        _builder.append(" ");
        String _shortVersion = version.getShortVersion();
        _builder.append(_shortVersion, "\t\t");
        TitleboxExtensions.set((Titlebox)it, (int)23, (String)_builder.toString());
        Index_Ausgabe_TypeClass _indexAusgabe = null;
        if (planungAllgemein != null) {
            _indexAusgabe = planungAllgemein.getIndexAusgabe();
        }
        String _wert_16 = null;
        if (_indexAusgabe != null) {
            _wert_16 = _indexAusgabe.getWert();
        }
        TitleboxExtensions.set((Titlebox)it, (int)56, (String)_wert_16);
        String _bauzustandPlanungAllgemein = null;
        if (planungAllgemein != null) {
            _bauzustandPlanungAllgemein = this.getBauzustandPlanungAllgemein(planungAllgemein);
        }
        TitleboxExtensions.set((Titlebox)it, (int)57, (String)_bauzustandPlanungAllgemein);
        String _elvis_16 = null;
        Akteur _handelnder_7 = null;
        if (lastPlanungEErstellung != null) {
            _handelnder_7 = lastPlanungEErstellung.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg_7 = null;
        if (_handelnder_7 != null) {
            _akteurAllg_7 = _handelnder_7.getAkteurAllg();
        }
        Name_Akteur_5_TypeClass _nameAkteur5_4 = null;
        if (_akteurAllg_7 != null) {
            _nameAkteur5_4 = _akteurAllg_7.getNameAkteur5();
        }
        String _wert_17 = null;
        if (_nameAkteur5_4 != null) {
            _wert_17 = _nameAkteur5_4.getWert();
        }
        _elvis_16 = _wert_17 != null ? _wert_17 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)58, (String)_elvis_16);
        String _elvis_17 = null;
        Datum_TypeClass _datum_7 = null;
        if (lastPlanungEErstellung != null) {
            _datum_7 = lastPlanungEErstellung.getDatum();
        }
        XMLGregorianCalendar _wert_18 = null;
        if (_datum_7 != null) {
            _wert_18 = _datum_7.getWert();
        }
        String _string_7 = null;
        if (_wert_18 != null) {
            _string_7 = XMLGregorianCalendarExtensions.toString(_wert_18, DATE_FORMAT);
        }
        _elvis_17 = _string_7 != null ? _string_7 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)70, (String)_elvis_17);
        Planung_E_Handlung_AttributeGroup _planungEHandlung_5 = null;
        if (planungEinzel != null) {
            _planungEHandlung_5 = planungEinzel.getPlanungEHandlung();
        }
        EList _planungEPruefung = null;
        if (_planungEHandlung_5 != null) {
            _planungEPruefung = _planungEHandlung_5.getPlanungEPruefung();
        }
        Akteur_Zuordnung _lastOrNull_5 = null;
        if (_planungEPruefung != null) {
            _lastOrNull_5 = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEPruefung);
        }
        Akteur_Zuordnung lastPlanPruefung = _lastOrNull_5;
        String _elvis_18 = null;
        Akteur _handelnder_8 = null;
        if (lastPlanPruefung != null) {
            _handelnder_8 = lastPlanPruefung.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg_8 = null;
        if (_handelnder_8 != null) {
            _akteurAllg_8 = _handelnder_8.getAkteurAllg();
        }
        Name_Akteur_5_TypeClass _nameAkteur5_5 = null;
        if (_akteurAllg_8 != null) {
            _nameAkteur5_5 = _akteurAllg_8.getNameAkteur5();
        }
        String _wert_19 = null;
        if (_nameAkteur5_5 != null) {
            _wert_19 = _nameAkteur5_5.getWert();
        }
        _elvis_18 = _wert_19 != null ? _wert_19 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)59, (String)_elvis_18);
        String _elvis_19 = null;
        Datum_TypeClass _datum_8 = null;
        if (lastPlanPruefung != null) {
            _datum_8 = lastPlanPruefung.getDatum();
        }
        XMLGregorianCalendar _wert_20 = null;
        if (_datum_8 != null) {
            _wert_20 = _datum_8.getWert();
        }
        String _string_8 = null;
        if (_wert_20 != null) {
            _string_8 = XMLGregorianCalendarExtensions.toString(_wert_20, DATE_FORMAT);
        }
        _elvis_19 = _string_8 != null ? _string_8 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)71, (String)_elvis_19);
        String _elvis_20 = null;
        Akteur _handelnder_9 = null;
        if (lastPlanungAbnahme != null) {
            _handelnder_9 = lastPlanungAbnahme.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg_9 = null;
        if (_handelnder_9 != null) {
            _akteurAllg_9 = _handelnder_9.getAkteurAllg();
        }
        Name_Akteur_5_TypeClass _nameAkteur5_6 = null;
        if (_akteurAllg_9 != null) {
            _nameAkteur5_6 = _akteurAllg_9.getNameAkteur5();
        }
        String _wert_21 = null;
        if (_nameAkteur5_6 != null) {
            _wert_21 = _nameAkteur5_6.getWert();
        }
        _elvis_20 = _wert_21 != null ? _wert_21 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)60, (String)_elvis_20);
        String _elvis_21 = null;
        Datum_TypeClass _datum_9 = null;
        if (lastPlanungAbnahme != null) {
            _datum_9 = lastPlanungAbnahme.getDatum();
        }
        XMLGregorianCalendar _wert_22 = null;
        if (_datum_9 != null) {
            _wert_22 = _datum_9.getWert();
        }
        String _string_9 = null;
        if (_wert_22 != null) {
            _string_9 = XMLGregorianCalendarExtensions.toString(_wert_22, DATE_FORMAT);
        }
        _elvis_21 = _string_9 != null ? _string_9 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)72, (String)_elvis_21);
        String _elvis_22 = null;
        Akteur _handelnder_10 = null;
        if (lastPlanungUebernahme != null) {
            _handelnder_10 = lastPlanungUebernahme.getHandelnder();
        }
        Akteur_Allg_AttributeGroup _akteurAllg_10 = null;
        if (_handelnder_10 != null) {
            _akteurAllg_10 = _handelnder_10.getAkteurAllg();
        }
        Name_Akteur_5_TypeClass _nameAkteur5_7 = null;
        if (_akteurAllg_10 != null) {
            _nameAkteur5_7 = _akteurAllg_10.getNameAkteur5();
        }
        String _wert_23 = null;
        if (_nameAkteur5_7 != null) {
            _wert_23 = _nameAkteur5_7.getWert();
        }
        _elvis_22 = _wert_23 != null ? _wert_23 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)61, (String)_elvis_22);
        String _elvis_23 = null;
        Datum_TypeClass _datum_10 = null;
        if (lastPlanungUebernahme != null) {
            _datum_10 = lastPlanungUebernahme.getDatum();
        }
        XMLGregorianCalendar _wert_24 = null;
        if (_datum_10 != null) {
            _wert_24 = _datum_10.getWert();
        }
        String _string_10 = null;
        if (_wert_24 != null) {
            _string_10 = XMLGregorianCalendarExtensions.toString(_wert_24, DATE_FORMAT);
        }
        _elvis_23 = _string_10 != null ? _string_10 : EMPTY_EDITION_NUMBER;
        TitleboxExtensions.set((Titlebox)it, (int)73, (String)_elvis_23);
        StringConcatenation _builder_1 = new StringConcatenation();
        String _oertlichkeit = this.getOertlichkeit(this.mainSchnittstelle);
        _builder_1.append(_oertlichkeit);
        String _elvis_24 = null;
        String _planningNumber = null;
        if (tableName != null) {
            _planningNumber = tableName.getPlanningNumber();
        }
        _elvis_24 = _planningNumber != null ? _planningNumber : EMPTY_PLANNING_NUMBER;
        _builder_1.append(_elvis_24);
        TitleboxExtensions.set((Titlebox)it, (int)74, (String)_builder_1.toString());
        TitleboxExtensions.set((Titlebox)it, (int)99, (String)this.buildLastEditionNumber(planungAllgemein));
        if (this.compareSchnittstelle != null) {
            Planung_E_Allg_AttributeGroup _planungAllgemein_1 = null;
            if (this.compareSchnittstelle != null) {
                _planungAllgemein_1 = this.getPlanungAllgemein(this.compareSchnittstelle);
            }
            Planung_E_Allg_AttributeGroup comparePlanungAllgemein = _planungAllgemein_1;
            Planung_Einzel _planungEinzel_1 = null;
            if (this.compareSchnittstelle != null) {
                _planungEinzel_1 = this.getPlanungEinzel(this.compareSchnittstelle);
            }
            Planung_E_Handlung_AttributeGroup _planungEHandlung_6 = null;
            if (_planungEinzel_1 != null) {
                _planungEHandlung_6 = _planungEinzel_1.getPlanungEHandlung();
            }
            EList _planungEErstellung_1 = null;
            if (_planungEHandlung_6 != null) {
                _planungEErstellung_1 = _planungEHandlung_6.getPlanungEErstellung();
            }
            Akteur_Zuordnung _lastOrNull_6 = null;
            if (_planungEErstellung_1 != null) {
                _lastOrNull_6 = (Akteur_Zuordnung)IterableExtensions.lastOrNull((Iterable)_planungEErstellung_1);
            }
            Akteur_Zuordnung compareLastPlanungEErstellung = _lastOrNull_6;
            String _buildLastEditionNumber = null;
            if (comparePlanungAllgemein != null) {
                _buildLastEditionNumber = this.buildLastEditionNumber(comparePlanungAllgemein);
            }
            TitleboxExtensions.set((Titlebox)it, (int)48, (String)_buildLastEditionNumber);
            String _elvis_25 = null;
            Datum_TypeClass _datum_11 = null;
            if (compareLastPlanungEErstellung != null) {
                _datum_11 = compareLastPlanungEErstellung.getDatum();
            }
            XMLGregorianCalendar _wert_25 = _datum_11.getWert();
            String _string_11 = null;
            if (_wert_25 != null) {
                _string_11 = XMLGregorianCalendarExtensions.toString(_wert_25, DATE_FORMAT);
            }
            _elvis_25 = _string_11 != null ? _string_11 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)62, (String)_elvis_25);
            TitleboxExtensions.set((Titlebox)it, (int)49, (String)this.buildLastEditionNumber(planungAllgemein));
            String _elvis_26 = null;
            Datum_TypeClass _datum_12 = null;
            if (lastPlanungEErstellung != null) {
                _datum_12 = lastPlanungEErstellung.getDatum();
            }
            XMLGregorianCalendar _wert_26 = null;
            if (_datum_12 != null) {
                _wert_26 = _datum_12.getWert();
            }
            String _string_12 = null;
            if (_wert_26 != null) {
                _string_12 = XMLGregorianCalendarExtensions.toString(_wert_26, DATE_FORMAT);
            }
            _elvis_26 = _string_12 != null ? _string_12 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)63, (String)_elvis_26);
        } else {
            TitleboxExtensions.set((Titlebox)it, (int)48, (String)this.buildLastEditionNumber(planungAllgemein));
            String _elvis_27 = null;
            Datum_TypeClass _datum_13 = null;
            if (lastPlanungEErstellung != null) {
                _datum_13 = lastPlanungEErstellung.getDatum();
            }
            XMLGregorianCalendar _wert_27 = null;
            if (_datum_13 != null) {
                _wert_27 = _datum_13.getWert();
            }
            String _string_13 = null;
            if (_wert_27 != null) {
                _string_13 = XMLGregorianCalendarExtensions.toString(_wert_27, DATE_FORMAT);
            }
            _elvis_27 = _string_13 != null ? _string_13 : EMPTY_EDITION_NUMBER;
            TitleboxExtensions.set((Titlebox)it, (int)62, (String)_elvis_27);
        }
        boolean _isPdfExportTestFilling = ToolboxConfiguration.isPdfExportTestFilling();
        if (_isPdfExportTestFilling) {
            TitleboxExtensions.fillEmptyFieldsWithAddresses((Titlebox)it);
        }
    }

    /*
     * Unable to fully structure code
     */
    private String getOertlichkeit(PlanPro_Schnittstelle schnittstelle) {
        _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        _leadingPlanungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _leadingPlanungGruppe = PlanungProjektExtensions.getLeadingPlanungGruppe(_LSTPlanungProjekt);
        }
        _fuehrendeOertlichkeit = null;
        if (_leadingPlanungGruppe != null) {
            _fuehrendeOertlichkeit = _leadingPlanungGruppe.getFuehrendeOertlichkeit();
        }
        _wert = null;
        if (_fuehrendeOertlichkeit != null) {
            _wert = _fuehrendeOertlichkeit.getWert();
        }
        if ((fuehrendeOertlichkeit = _wert) != null) ** GOTO lbl19
        return "";
lbl-1000:
        // 1 sources

        {
            _builder = new StringConcatenation();
            _builder.append(fuehrendeOertlichkeit);
            _builder.append("_");
            fuehrendeOertlichkeit = _builder.toString();
lbl19:
            // 2 sources

            ** while (fuehrendeOertlichkeit.length() < 5)
        }
lbl20:
        // 1 sources

        _builder = new StringConcatenation();
        _builder.append(fuehrendeOertlichkeit);
        _builder.append(".");
        return _builder.toString();
    }

    private String getBauzustandPlanungAllgemein(Planung_E_Allg_AttributeGroup planung) {
        boolean _greaterThan;
        String _elvis = null;
        Bauzustand_Kurzbezeichnung_TypeClass _bauzustandKurzbezeichnung = null;
        if (planung != null) {
            _bauzustandKurzbezeichnung = planung.getBauzustandKurzbezeichnung();
        }
        String _wert = null;
        if (_bauzustandKurzbezeichnung != null) {
            _wert = _bauzustandKurzbezeichnung.getWert();
        }
        _elvis = _wert != null ? _wert : EMPTY_EDITION_NUMBER;
        String bauzustand = _elvis;
        int _length = bauzustand.length();
        boolean bl = _greaterThan = _length > 7;
        if (_greaterThan) {
            Functions.Function1 _function = it -> {
                boolean _greaterThan_1;
                int _length_1 = it.length();
                boolean bl = _greaterThan_1 = _length_1 > 7;
                if (_greaterThan_1) {
                    StringBuilder sb = new StringBuilder((String)it);
                    sb.insert(7, ZERO_WIDTH_SPACE);
                    return sb.toString();
                }
                return it;
            };
            List result = ListExtensions.map((List)((List)Conversions.doWrapArray((Object)bauzustand.split(" "))), (Functions.Function1)_function);
            return String.join((CharSequence)" ", result);
        }
        return bauzustand;
    }

    private String getBauzustandPlanungEinzel(Planung_Einzel planung) {
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (planung != null) {
            _planungEAllg = planung.getPlanungEAllg();
        }
        return this.getBauzustandPlanungAllgemein(_planungEAllg);
    }

    private String getReferenzPlanungBasis(PlanPro_Schnittstelle schnittstelle) {
        Planung_Einzel _planungEinzel = null;
        if (schnittstelle != null) {
            _planungEinzel = this.getPlanungEinzel(schnittstelle);
        }
        Referenz_Planung_Basis_TypeClass _referenzPlanungBasis = null;
        if (_planungEinzel != null) {
            _referenzPlanungBasis = _planungEinzel.getReferenzPlanungBasis();
        }
        String _wert = null;
        if (_referenzPlanungBasis != null) {
            _wert = _referenzPlanungBasis.getWert();
        }
        return _wert;
    }

    private String buildLastEditionNumber(Planung_E_Allg_AttributeGroup planungEAllg) {
        if (planungEAllg != null) {
            String _elvis = null;
            Index_Ausgabe_TypeClass _indexAusgabe = null;
            if (planungEAllg != null) {
                _indexAusgabe = planungEAllg.getIndexAusgabe();
            }
            String _wert = null;
            if (_indexAusgabe != null) {
                _wert = _indexAusgabe.getWert();
            }
            _elvis = _wert != null ? _wert : EMPTY_EDITION_NUMBER;
            String _elvis_1 = null;
            Laufende_Nummer_Ausgabe_TypeClass _laufendeNummerAusgabe = null;
            if (planungEAllg != null) {
                _laufendeNummerAusgabe = planungEAllg.getLaufendeNummerAusgabe();
            }
            String _wert_1 = null;
            if (_laufendeNummerAusgabe != null) {
                _wert_1 = _laufendeNummerAusgabe.getWert();
            }
            _elvis_1 = _wert_1 != null ? _wert_1 : EMPTY_EDITION_NUMBER;
            return String.format("%s.%s", _elvis, _elvis_1);
        }
        return EMPTY_EDITION_NUMBER;
    }

    public Planung_E_Allg_AttributeGroup getPlanungAllgemein(PlanPro_Schnittstelle schnittstelle) {
        Planung_Einzel _planungEinzel = null;
        if (schnittstelle != null) {
            _planungEinzel = this.getPlanungEinzel(schnittstelle);
        }
        Planung_E_Allg_AttributeGroup _planungEAllg = null;
        if (_planungEinzel != null) {
            _planungEAllg = _planungEinzel.getPlanungEAllg();
        }
        return _planungEAllg;
    }

    public Planung_Gruppe getPlanungGruppe(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _leadingPlanungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _leadingPlanungGruppe = PlanungProjektExtensions.getLeadingPlanungGruppe(_LSTPlanungProjekt);
        }
        return _leadingPlanungGruppe;
    }

    public Planung_Einzel getPlanungEinzel(PlanPro_Schnittstelle schnittstelle) {
        Planung_Projekt _LSTPlanungProjekt = null;
        if (schnittstelle != null) {
            _LSTPlanungProjekt = PlanProSchnittstelleExtensions.LSTPlanungProjekt(schnittstelle);
        }
        Planung_Gruppe _leadingPlanungGruppe = null;
        if (_LSTPlanungProjekt != null) {
            _leadingPlanungGruppe = PlanungProjektExtensions.getLeadingPlanungGruppe(_LSTPlanungProjekt);
        }
        Planung_Einzel _lSTPlanungEinzel = null;
        if (_leadingPlanungGruppe != null) {
            _lSTPlanungEinzel = _leadingPlanungGruppe.getLSTPlanungEinzel();
        }
        return _lSTPlanungEinzel;
    }

    private void addFieldsFrom(Titlebox titlebox, Planung_G_Schriftfeld_AttributeGroup schriftfeld, TableNameInfo tableName, Function<String, Path> attachmentPathProvider) {
        TitleboxExtensions.set((Titlebox)titlebox, (int)85, (String)this.compileField85(schriftfeld, tableName));
        titlebox.setPlanningOffice(this.fillPlanningOffice(schriftfeld, attachmentPathProvider));
    }

    public Dimension getImageDimension(String path, ENUMDateityp filetype) {
        if (path == null || filetype == null) {
            return null;
        }
        String suffix = this.getFiletypeSuffix(filetype);
        if (suffix == null) {
            return null;
        }
        Iterator<ImageReader> iter = ImageIO.getImageReadersBySuffix(suffix);
        boolean _hasNext = iter.hasNext();
        if (_hasNext) {
            ImageReader reader = iter.next();
            try {
                File _file = new File(path);
                FileImageInputStream stream = new FileImageInputStream(_file);
                reader.setInput(stream);
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Dimension dimension = new Dimension(width, height);
                return dimension;
            }
            catch (Throwable _t) {
                if (!(_t instanceof Exception)) {
                    throw Exceptions.sneakyThrow((Throwable)_t);
                }
            }
            finally {
                reader.dispose();
            }
        }
        return null;
    }

    private String nonBreaking(String text) {
        String _replace = null;
        if (text != null) {
            _replace = text.replace(" ", "\u00a0");
        }
        return _replace;
    }

    public String getFiletypeSuffix(ENUMDateityp dateityp) {
        if (dateityp != null) {
            switch (dateityp) {
                case ENUM_DATEITYP_JPG: {
                    return "jpg";
                }
                case ENUM_DATEITYP_PNG: {
                    return "png";
                }
            }
            return null;
        }
        return null;
    }

    private PlanningOffice fillPlanningOffice(Planung_G_Schriftfeld_AttributeGroup schriftfeld, Function<String, Path> attachmentPathProvider) {
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        PlanningOffice it = TitleboxFactory.eINSTANCE.createPlanningOffice();
        it.setVariant("no-logo");
        Anhang _planungsbueroLogo = null;
        if (schriftfeld != null) {
            _planungsbueroLogo = schriftfeld.getPlanungsbueroLogo();
        }
        Anhang_Allg_AttributeGroup _anhangAllg = null;
        if (_planungsbueroLogo != null) {
            _anhangAllg = _planungsbueroLogo.getAnhangAllg();
        }
        Dateiname_TypeClass _dateiname = null;
        if (_anhangAllg != null) {
            _dateiname = _anhangAllg.getDateiname();
        }
        String _wert = null;
        if (_dateiname != null) {
            _wert = _dateiname.getWert();
        }
        boolean bl = _tripleNotEquals = _wert != null;
        if (_tripleNotEquals) {
            String _elvis = null;
            Anhang _planungsbueroLogo_1 = null;
            if (schriftfeld != null) {
                _planungsbueroLogo_1 = schriftfeld.getPlanungsbueroLogo();
            }
            Identitaet_TypeClass _identitaet = null;
            if (_planungsbueroLogo_1 != null) {
                _identitaet = _planungsbueroLogo_1.getIdentitaet();
            }
            String _wert_1 = null;
            if (_identitaet != null) {
                _wert_1 = _identitaet.getWert();
            }
            Path _apply = attachmentPathProvider.apply(_wert_1);
            Path _absolutePath = null;
            if (_apply != null) {
                _absolutePath = _apply.toAbsolutePath();
            }
            Path _normalize = null;
            if (_absolutePath != null) {
                _normalize = _absolutePath.normalize();
            }
            String _string = null;
            if (_normalize != null) {
                _string = _normalize.toString();
            }
            _elvis = _string != null ? _string : EMPTY_EDITION_NUMBER;
            String logo = _elvis;
            Anhang _planungsbueroLogo_2 = null;
            if (schriftfeld != null) {
                _planungsbueroLogo_2 = schriftfeld.getPlanungsbueroLogo();
            }
            Anhang_Allg_AttributeGroup _anhangAllg_1 = null;
            if (_planungsbueroLogo_2 != null) {
                _anhangAllg_1 = _planungsbueroLogo_2.getAnhangAllg();
            }
            Dateityp_TypeClass _dateityp = null;
            if (_anhangAllg_1 != null) {
                _dateityp = _anhangAllg_1.getDateityp();
            }
            ENUMDateityp _wert_2 = null;
            if (_dateityp != null) {
                _wert_2 = _dateityp.getWert();
            }
            Dimension dimension = this.getImageDimension(logo, _wert_2);
            if (logo != null && dimension != null) {
                it.setLogo("file:///" + logo);
                if (dimension.width > dimension.height) {
                    it.setVariant("logo-top");
                } else {
                    it.setVariant("logo-side");
                }
            }
        }
        Organisation _planungsbuero = null;
        if (schriftfeld != null) {
            _planungsbuero = schriftfeld.getPlanungsbuero();
        }
        Name_Organisation_TypeClass _nameOrganisation = null;
        if (_planungsbuero != null) {
            _nameOrganisation = _planungsbuero.getNameOrganisation();
        }
        String _wert_3 = null;
        if (_nameOrganisation != null) {
            _wert_3 = _nameOrganisation.getWert();
        }
        it.setName(this.fillPlanningOfficeField(_wert_3));
        Organisation _planungsbuero_1 = null;
        if (schriftfeld != null) {
            _planungsbuero_1 = schriftfeld.getPlanungsbuero();
        }
        Organisationseinheit_TypeClass _organisationseinheit = null;
        if (_planungsbuero_1 != null) {
            _organisationseinheit = _planungsbuero_1.getOrganisationseinheit();
        }
        String _wert_4 = null;
        if (_organisationseinheit != null) {
            _wert_4 = _organisationseinheit.getWert();
        }
        it.setGroup(this.fillPlanningOfficeField(_wert_4));
        boolean _or = false;
        Organisation _planungsbuero_2 = null;
        if (schriftfeld != null) {
            _planungsbuero_2 = schriftfeld.getPlanungsbuero();
        }
        Adresse_PLZ_Ort_TypeClass _adressePLZOrt = null;
        if (_planungsbuero_2 != null) {
            _adressePLZOrt = _planungsbuero_2.getAdressePLZOrt();
        }
        String _wert_5 = null;
        if (_adressePLZOrt != null) {
            _wert_5 = _adressePLZOrt.getWert();
        }
        boolean bl2 = _tripleNotEquals_1 = _wert_5 != null;
        if (_tripleNotEquals_1) {
            _or = true;
        } else {
            boolean _tripleNotEquals_2;
            Organisation _planungsbuero_3 = null;
            if (schriftfeld != null) {
                _planungsbuero_3 = schriftfeld.getPlanungsbuero();
            }
            Adresse_Strasse_Nr_TypeClass _adresseStrasseNr = null;
            if (_planungsbuero_3 != null) {
                _adresseStrasseNr = _planungsbuero_3.getAdresseStrasseNr();
            }
            String _wert_6 = null;
            if (_adresseStrasseNr != null) {
                _wert_6 = _adresseStrasseNr.getWert();
            }
            _or = _tripleNotEquals_2 = _wert_6 != null;
        }
        if (_or) {
            String _nonBreaking_1;
            String _nonBreaking;
            String _elvis_1 = null;
            Organisation _planungsbuero_4 = null;
            if (schriftfeld != null) {
                _planungsbuero_4 = schriftfeld.getPlanungsbuero();
            }
            Adresse_PLZ_Ort_TypeClass _adressePLZOrt_1 = null;
            if (_planungsbuero_4 != null) {
                _adressePLZOrt_1 = _planungsbuero_4.getAdressePLZOrt();
            }
            String _wert_7 = null;
            if (_adressePLZOrt_1 != null) {
                _wert_7 = _adressePLZOrt_1.getWert();
            }
            _elvis_1 = (_nonBreaking = this.nonBreaking(_wert_7)) != null ? _nonBreaking : EMPTY_EDITION_NUMBER;
            String addrPLZ = _elvis_1;
            String _elvis_2 = null;
            Organisation _planungsbuero_5 = null;
            if (schriftfeld != null) {
                _planungsbuero_5 = schriftfeld.getPlanungsbuero();
            }
            Adresse_Strasse_Nr_TypeClass _adresseStrasseNr_1 = null;
            if (_planungsbuero_5 != null) {
                _adresseStrasseNr_1 = _planungsbuero_5.getAdresseStrasseNr();
            }
            String _wert_8 = null;
            if (_adresseStrasseNr_1 != null) {
                _wert_8 = _adresseStrasseNr_1.getWert();
            }
            _elvis_2 = (_nonBreaking_1 = this.nonBreaking(_wert_8)) != null ? _nonBreaking_1 : EMPTY_EDITION_NUMBER;
            String addrStr = _elvis_2;
            String _variant = it.getVariant();
            boolean _equals = Objects.equals(_variant, "no-logo");
            if (_equals) {
                it.setLocation(this.fillPlanningOfficeField(addrStr + "\n" + addrPLZ));
            } else {
                StringConcatenation _builder = new StringConcatenation();
                _builder.append(addrStr);
                _builder.append(", ");
                _builder.append(addrPLZ);
                it.setLocation(this.fillPlanningOfficeField(_builder.toString()));
            }
        } else {
            it.setLocation(this.fillPlanningOfficeField(EMPTY_EDITION_NUMBER));
        }
        Organisation _planungsbuero_6 = null;
        if (schriftfeld != null) {
            _planungsbuero_6 = schriftfeld.getPlanungsbuero();
        }
        Telefonnummer_TypeClass _telefonnummer = null;
        if (_planungsbuero_6 != null) {
            _telefonnummer = _planungsbuero_6.getTelefonnummer();
        }
        String _wert_9 = null;
        if (_telefonnummer != null) {
            _wert_9 = _telefonnummer.getWert();
        }
        it.setPhone(this.fillPlanningOfficeField(_wert_9));
        Organisation _planungsbuero_7 = null;
        if (schriftfeld != null) {
            _planungsbuero_7 = schriftfeld.getPlanungsbuero();
        }
        E_Mail_Adresse_TypeClass _eMailAdresse = null;
        if (_planungsbuero_7 != null) {
            _eMailAdresse = _planungsbuero_7.getEMailAdresse();
        }
        String _wert_10 = null;
        if (_eMailAdresse != null) {
            _wert_10 = _eMailAdresse.getWert();
        }
        it.setEmail(this.fillPlanningOfficeField(_wert_10));
        StringField _name = it.getName();
        StringField _group = it.getGroup();
        StringField _location = it.getLocation();
        StringField _phone = it.getPhone();
        StringField _email = it.getEmail();
        List<StringField> fields = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new StringField[]{_name, _group, _location, _phone, _email}));
        Functions.Function1 _function = it_1 -> it_1.getText().length();
        String fontSize = this.getFontSize((Integer)IterableExtensions.max((Iterable)ListExtensions.map(fields, (Functions.Function1)_function)), it.getVariant());
        Consumer<StringField> _function_1 = it_1 -> it_1.setFontsize(fontSize);
        fields.forEach(_function_1);
        return it;
    }

    private StringField fillPlanningOfficeField(String text) {
        StringField it = TitleboxFactory.eINSTANCE.createStringField();
        String _elvis = null;
        _elvis = text != null ? text : EMPTY_EDITION_NUMBER;
        it.setText(_elvis);
        return it;
    }

    private String getFontSize(int length, String variant) {
        block17: {
            if (variant == null) break block17;
            switch (variant) {
                case "logo-side": {
                    if (length > 40) {
                        return "2mm";
                    }
                    if (length > 27) {
                        return "2.2mm";
                    }
                    if (length > 25) {
                        return "2.3mm";
                    }
                    if (length > 20) {
                        return "2.4mm";
                    }
                    return "2.5mm";
                }
                case "logo-top": {
                    return "2mm";
                }
                case "no-logo": {
                    return "2.7mm";
                }
            }
        }
        return null;
    }

    private String compileField85(Planung_G_Schriftfeld_AttributeGroup schriftfeld, TableNameInfo tableName) {
        StringConcatenation _builder = new StringConcatenation();
        Bezeichnung_Anlage_TypeClass _bezeichnungAnlage = null;
        if (schriftfeld != null) {
            _bezeichnungAnlage = schriftfeld.getBezeichnungAnlage();
        }
        String _wert = null;
        if (_bezeichnungAnlage != null) {
            _wert = _bezeichnungAnlage.getWert();
        }
        _builder.append(_wert);
        _builder.newLineIfNotEmpty();
        Bezeichnung_Unteranlage_TypeClass _bezeichnungUnteranlage = null;
        if (schriftfeld != null) {
            _bezeichnungUnteranlage = schriftfeld.getBezeichnungUnteranlage();
        }
        String _wert_1 = null;
        if (_bezeichnungUnteranlage != null) {
            _wert_1 = _bezeichnungUnteranlage.getWert();
        }
        _builder.append(_wert_1);
        _builder.newLineIfNotEmpty();
        String _elvis = null;
        String _fullDisplayName = null;
        if (tableName != null) {
            _fullDisplayName = tableName.getFullDisplayName();
        }
        _elvis = _fullDisplayName != null ? _fullDisplayName : "<Planzeichen> \u2013 <Planart>";
        _builder.append(_elvis);
        _builder.newLineIfNotEmpty();
        return _builder.toString();
    }
}

