/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.model.tablemodel.extensions;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.ColumnWidthMode;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableCell;
import org.eclipse.set.model.tablemodel.TablemodelFactory;
import org.eclipse.set.model.tablemodel.extensions.Headings;
import org.eclipse.set.model.tablemodel.extensions.RowGroupExtensions;
import org.eclipse.set.utils.math.IntegerExtensions;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class ColumnDescriptorExtensions {
    public static List<ColumnDescriptor> transform(Collection<ColumnDescriptor> descriptors) {
        return IterableExtensions.toList(descriptors);
    }

    public static void addMissingHeadingUnits(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> {
            boolean _isUnit = it.isUnit();
            return !_isUnit;
        };
        Consumer<ColumnDescriptor> _function_1 = it -> ColumnDescriptorExtensions.addUnit(it, "");
        IterableExtensions.filter(ColumnDescriptorExtensions.getColumns(descriptor), (Functions.Function1)_function).forEach(_function_1);
    }

    public static ColumnDescriptor addUnit(ColumnDescriptor descriptor, String unit) {
        ColumnDescriptor unitDescriptor = TablemodelFactory.eINSTANCE.createColumnDescriptor();
        unitDescriptor.setLabel(unit);
        unitDescriptor.setUnit(true);
        unitDescriptor.setColumnPosition(descriptor.getColumnPosition());
        ColumnDescriptorExtensions.getTable(descriptor).getColumndescriptors().add((Object)unitDescriptor);
        descriptor.getChildren().add((Object)unitDescriptor);
        return unitDescriptor;
    }

    public static Table getTable(ColumnDescriptor descriptor) {
        EObject _eContainer = descriptor.eContainer();
        return (Table)_eContainer;
    }

    public static String[] getColumnAdresses(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.getColumnAdress(it);
        return (String[])Conversions.unwrapArray((Object)ListExtensions.map(ColumnDescriptorExtensions.getColumns(descriptor), (Functions.Function1)_function), String.class);
    }

    private static String getColumnAdress(ColumnDescriptor descriptor) {
        ColumnDescriptor d = descriptor;
        boolean _isUnit = d.isUnit();
        if (_isUnit) {
            while (d.getLabel().isEmpty()) {
                d = d.getParent();
            }
        }
        return d.getLabel();
    }

    public static String[] getColumnLabels(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> it.getLabel();
        return (String[])Conversions.unwrapArray((Object)ListExtensions.map(ColumnDescriptorExtensions.getColumns(descriptor), (Functions.Function1)_function), String.class);
    }

    public static double getGroupRowHeight(ColumnDescriptor descriptor) {
        return Headings.getMaxHeight(ColumnDescriptorExtensions.getGroups(descriptor));
    }

    public static double getGroupGroupRowHeight(ColumnDescriptor descriptor) {
        return Headings.getMaxHeight(ColumnDescriptorExtensions.getGroupGroups(descriptor));
    }

    public static double getGroupGroupGroupRowHeight(ColumnDescriptor descriptor) {
        return Headings.getMaxHeight(ColumnDescriptorExtensions.getGroupGroupGroups(descriptor));
    }

    public static double getGroup4RowHeight(ColumnDescriptor descriptor) {
        return Headings.getMaxHeight(ColumnDescriptorExtensions.getGroup4(descriptor));
    }

    public static List<ColumnDescriptor> getColumns(ColumnDescriptor descriptor) {
        return ColumnDescriptorExtensions.getLeaves(ColumnDescriptorExtensions.getRoot(descriptor));
    }

    public static ColumnDescriptor getRoot(ColumnDescriptor descriptor) {
        boolean _tripleEquals;
        ColumnDescriptor _parent = descriptor.getParent();
        boolean bl = _tripleEquals = _parent == null;
        if (_tripleEquals) {
            return descriptor;
        }
        return ColumnDescriptorExtensions.getRoot(descriptor.getParent());
    }

    public static boolean isRoot(ColumnDescriptor descriptor) {
        ColumnDescriptor _root = ColumnDescriptorExtensions.getRoot(descriptor);
        return descriptor == _root;
    }

    public static List<ColumnDescriptor> getLeaves(ColumnDescriptor descriptor) {
        boolean _isEmpty = descriptor.getChildren().isEmpty();
        if (_isEmpty) {
            return CollectionLiterals.newLinkedList((Object[])new ColumnDescriptor[]{descriptor});
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.getLeaves(it);
        return IterableExtensions.toList((Iterable)IterableExtensions.flatMap((Iterable)descriptor.getChildren(), (Functions.Function1)_function));
    }

    public static boolean isLeaf(ColumnDescriptor descriptor) {
        return descriptor.getChildren().isEmpty();
    }

    public static Set<ColumnDescriptor> getGroup4(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> it.getParent();
        Functions.Function1 _function_1 = it -> ColumnDescriptorExtensions.isGroup4Test(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(ColumnDescriptorExtensions.getGroupGroupGroups(descriptor), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private static boolean isGroup4Test(ColumnDescriptor descriptor) {
        boolean _isRoot = ColumnDescriptorExtensions.isRoot(descriptor);
        if (_isRoot) {
            return false;
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isLeaf(it) || ColumnDescriptorExtensions.isGroup(it) || ColumnDescriptorExtensions.isGroupGroup(it) || ColumnDescriptorExtensions.isGroupGroupGroup(it);
        return IterableExtensions.forall((Iterable)descriptor.getChildren(), (Functions.Function1)_function);
    }

    public static Set<ColumnDescriptor> getGroupGroupGroups(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> it.getParent();
        Functions.Function1 _function_1 = it -> ColumnDescriptorExtensions.isGroupGroupGroupTest(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(ColumnDescriptorExtensions.getGroupGroups(descriptor), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private static boolean isGroupGroupGroupTest(ColumnDescriptor descriptor) {
        boolean _isRoot = ColumnDescriptorExtensions.isRoot(descriptor);
        if (_isRoot) {
            return false;
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isLeaf(it) || ColumnDescriptorExtensions.isGroup(it) || ColumnDescriptorExtensions.isGroupGroup(it);
        return IterableExtensions.forall((Iterable)descriptor.getChildren(), (Functions.Function1)_function);
    }

    public static boolean isGroupGroupGroup(ColumnDescriptor descriptor) {
        return ColumnDescriptorExtensions.getGroupGroupGroups(descriptor).contains(descriptor);
    }

    public static Set<ColumnDescriptor> getGroupGroups(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> it.getParent();
        Functions.Function1 _function_1 = it -> ColumnDescriptorExtensions.isGroupGroupTest(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.map(ColumnDescriptorExtensions.getGroups(descriptor), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private static boolean isGroupGroupTest(ColumnDescriptor descriptor) {
        boolean _isRoot = ColumnDescriptorExtensions.isRoot(descriptor);
        if (_isRoot) {
            return false;
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isLeaf(it) || ColumnDescriptorExtensions.isGroup(it);
        return IterableExtensions.forall((Iterable)descriptor.getChildren(), (Functions.Function1)_function);
    }

    public static boolean isGroupGroup(ColumnDescriptor descriptor) {
        return ColumnDescriptorExtensions.getGroupGroups(descriptor).contains(descriptor);
    }

    public static Set<ColumnDescriptor> getGroups(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> it.getParent();
        Functions.Function1 _function_1 = it -> ColumnDescriptorExtensions.isGroupTest(it);
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter((Iterable)ListExtensions.map(ColumnDescriptorExtensions.getColumns(descriptor), (Functions.Function1)_function), (Functions.Function1)_function_1));
    }

    private static boolean isGroupTest(ColumnDescriptor descriptor) {
        boolean _isRoot = ColumnDescriptorExtensions.isRoot(descriptor);
        if (_isRoot) {
            return false;
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isLeaf(it);
        boolean isGroup = IterableExtensions.forall((Iterable)descriptor.getChildren(), (Functions.Function1)_function);
        return isGroup;
    }

    public static boolean isColumnGroup(ColumnDescriptor descriptor) {
        boolean _isRoot = ColumnDescriptorExtensions.isRoot(descriptor);
        if (_isRoot) {
            return false;
        }
        int _size = descriptor.getChildren().size();
        return _size > 1;
    }

    public static boolean isGroup(ColumnDescriptor descriptor) {
        return ColumnDescriptorExtensions.getGroups(descriptor).contains(descriptor);
    }

    public static int[] getColumnIndices(ColumnDescriptor descriptor) {
        List<ColumnDescriptor> columns = ColumnDescriptorExtensions.getColumns(descriptor);
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isDescendantOf((ColumnDescriptor)columns.get((int)it), descriptor);
        return (int[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)IntegerExtensions.getPredecessors((int)((Object[])Conversions.unwrapArray(columns, Object.class)).length))), (Functions.Function1)_function), Integer.TYPE);
    }

    public static boolean isDescendantOf(ColumnDescriptor descriptor, ColumnDescriptor otherDescriptor) {
        Functions.Function1 _function = it -> Objects.equals(it, descriptor) || ColumnDescriptorExtensions.isDescendantOf(descriptor, it);
        return IterableExtensions.exists((Iterable)otherDescriptor.getChildren(), (Functions.Function1)_function);
    }

    public static int[] getGreyedColumnIndices(ColumnDescriptor descriptor) {
        List<ColumnDescriptor> columns = ColumnDescriptorExtensions.getColumns(descriptor);
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isColumnGreyed((ColumnDescriptor)columns.get((int)it));
        return (int[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)((Iterable)Conversions.doWrapArray((Object)IntegerExtensions.getPredecessors((int)((Object[])Conversions.unwrapArray(columns, Object.class)).length))), (Functions.Function1)_function), Integer.TYPE);
    }

    public static float getHeight(ColumnDescriptor descriptor) {
        return Double.valueOf(descriptor.getHeight()).floatValue();
    }

    public static boolean isColumnGreyed(ColumnDescriptor descriptor) {
        boolean _tripleNotEquals;
        boolean _isGreyed = descriptor.isGreyed();
        if (_isGreyed) {
            return true;
        }
        ColumnDescriptor _parent = descriptor.getParent();
        boolean bl = _tripleNotEquals = _parent != null;
        if (_tripleNotEquals) {
            return ColumnDescriptorExtensions.isColumnGreyed(descriptor.getParent());
        }
        return false;
    }

    public static Float getColumnWidth(ColumnDescriptor descriptor, int columnIdx) {
        return ColumnDescriptorExtensions.getColumnWidth(ColumnDescriptorExtensions.getColumns(descriptor).get(columnIdx));
    }

    public static ColumnWidthMode getColumnWidthMode(ColumnDescriptor descriptor, int columnIdx) {
        return ColumnDescriptorExtensions.getColumnWidthMode(ColumnDescriptorExtensions.getColumns(descriptor).get(columnIdx));
    }

    private static ColumnWidthMode getColumnWidthMode(ColumnDescriptor descriptor) {
        boolean _tripleNotEquals;
        if (descriptor == null) {
            return null;
        }
        Float _width = descriptor.getWidth();
        boolean bl = _tripleNotEquals = _width != null;
        if (_tripleNotEquals) {
            return descriptor.getWidthMode();
        }
        return ColumnDescriptorExtensions.getColumnWidthMode(descriptor.getParent());
    }

    public static Float getColumnWidth(ColumnDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        Float result = descriptor.getWidth();
        if (result != null) {
            return result;
        }
        return ColumnDescriptorExtensions.getColumnWidth(descriptor.getParent());
    }

    public static TableCell createTableCell(ColumnDescriptor descriptor) {
        TableCell newColumn = TablemodelFactory.eINSTANCE.createTableCell();
        newColumn.setColumndescriptor(descriptor);
        return newColumn;
    }

    public static boolean isEqual(ColumnDescriptor descriptor, ColumnDescriptor other) {
        boolean result = ColumnDescriptorExtensions.testEqual(descriptor.getWidth(), other.getWidth());
        result = result && ColumnDescriptorExtensions.testEqual(descriptor.getLabel(), other.getLabel());
        result = result && ColumnDescriptorExtensions.testEqual(descriptor.isGreyed(), other.isGreyed());
        result = result && ColumnDescriptorExtensions.testEqual(descriptor.isUnit(), other.isUnit());
        result = result && ColumnDescriptorExtensions.testEqual(descriptor.getHeight(), other.getHeight());
        result = result && ColumnDescriptorExtensions.testEqualChildren(descriptor, other);
        return result;
    }

    public static List<TableCell> getColumnCells(ColumnDescriptor descriptor) {
        Functions.Function1 _function = it -> RowGroupExtensions.getColumnCells(it, descriptor);
        return IterableExtensions.toList((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)ColumnDescriptorExtensions.getTable(descriptor).getTablecontent().getRowgroups(), (Functions.Function1)_function)));
    }

    public static boolean isFootnoteReferenceColumn(ColumnDescriptor descriptor) {
        ColumnDescriptor _parent = null;
        if (descriptor != null) {
            _parent = descriptor.getParent();
        }
        String _label = null;
        if (_parent != null) {
            _label = _parent.getLabel();
        }
        return Objects.equals(_label, "Bemerkung");
    }

    private static boolean testEqualChildren(ColumnDescriptor descriptor, ColumnDescriptor other) {
        int _size_1;
        boolean _notEquals;
        int _size = descriptor.getChildren().size();
        boolean bl = _notEquals = _size != (_size_1 = other.getChildren().size());
        if (_notEquals) {
            return false;
        }
        Functions.Function1 _function = it -> ColumnDescriptorExtensions.isEqual((ColumnDescriptor)it.getValue(), (ColumnDescriptor)other.getChildren().get(((Integer)it.getKey()).intValue()));
        return IterableExtensions.forall((Iterable)IterableExtensions.indexed((Iterable)descriptor.getChildren()), (Functions.Function1)_function);
    }

    private static boolean testEqual(Object left, Object right) {
        if (left != null) {
            return left.equals(right);
        }
        return right == null;
    }
}

