/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.files;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.set.model.planpro.PlanPro.PlanProPackage;
import org.eclipse.set.model.planpro.PlanPro.util.PlanProValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ExtendedPlanProValidator
extends PlanProValidator {
    private static final ExtendedPlanProValidator EXTENDED_INSTANCE = new ExtendedPlanProValidator();

    public static void registerValidator() {
        EValidator.Registry.INSTANCE.put((Object)PlanProPackage.eINSTANCE, () -> EXTENDED_INSTANCE);
    }

    private static boolean nullSafeEquals(String string, String other) {
        if (string == null || other == null) {
            return string == other;
        }
        return string.equals(other);
    }

    private static String getEMFAnnotationValue(EStructuralFeature feature, String source, String key) {
        EList annotations = feature.getEAnnotations();
        for (EAnnotation annotation : annotations) {
            if (!ExtendedPlanProValidator.nullSafeEquals(annotation.getSource(), source)) continue;
            return (String)annotation.getDetails().get((Object)key);
        }
        return null;
    }

    private static String getPatternDescription(DiagnosticChain diagnostics) throws ParserConfigurationException, SAXException, IOException {
        if (!(diagnostics instanceof BasicDiagnostic)) {
            return null;
        }
        BasicDiagnostic basicDiagnostic = (BasicDiagnostic)diagnostics;
        Object object = basicDiagnostic.getData().get(0);
        if (!(object instanceof EObject)) {
            return null;
        }
        EObject objectWithWert = (EObject)object;
        EStructuralFeature featureWithPatternDescription = objectWithWert.eContainingFeature();
        String value = ExtendedPlanProValidator.getEMFAnnotationValue(featureWithPatternDescription, null, "appinfo");
        if (value == null) {
            return null;
        }
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(value);
        ByteArrayInputStream input = new ByteArrayInputStream(stringBuilder.toString().getBytes(StandardCharsets.UTF_8.name()));
        Document document = documentBuilder.parse(input);
        Element root = document.getDocumentElement();
        NodeList descriptionNodesVariant = root.getElementsByTagName("Patternbeschreibung_Abweichend");
        if (descriptionNodesVariant.getLength() > 0) {
            return descriptionNodesVariant.item(0).getTextContent();
        }
        NodeList descriptionNodes = root.getElementsByTagName("Patternbeschreibung");
        if (descriptionNodes.getLength() > 0) {
            return descriptionNodes.item(0).getTextContent();
        }
        return null;
    }

    private static boolean canReport(DiagnosticChain diagnostics) {
        try {
            return ExtendedPlanProValidator.getPatternDescription(diagnostics) != null;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    private static void reportPlanProDataValuePatternViolation(DiagnosticChain diagnostics) {
        try {
            diagnostics.add((Diagnostic)new BasicDiagnostic(4, "org.eclipse.emf.ecore", 9, ExtendedPlanProValidator.getPatternDescription(diagnostics), new Object[0]));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException(e);
        }
    }

    protected void reportDataValuePatternViolation(EDataType eDataType, Object value, EValidator.PatternMatcher[] patterns, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (ExtendedPlanProValidator.canReport(diagnostics)) {
            ExtendedPlanProValidator.reportPlanProDataValuePatternViolation(diagnostics);
            return;
        }
        super.reportDataValuePatternViolation(eDataType, value, patterns, diagnostics, context);
    }
}

