/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.extensions;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Position;
import org.eclipse.set.basis.text.Tag;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;

public class TagExtensions {
    public static String asString(Tag tag) {
        String name = null;
        try {
            name = tag.getName();
        }
        catch (Throwable _t) {
            if (_t instanceof BadLocationException) {
                BadLocationException e = (BadLocationException)_t;
                StringConcatenation _builder = new StringConcatenation();
                _builder.append("!");
                String _message = e.getMessage();
                _builder.append(_message);
                _builder.append("!");
                name = _builder.toString();
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("name=");
        _builder.append(name);
        _builder.append(" line=");
        int _line = tag.getLine();
        _builder.append((Object)_line);
        return _builder.toString();
    }

    public static Set<Position> getFoldingPositions(ArrayList<Tag> tags) {
        HashSet result = Sets.newHashSet();
        int i = 0;
        while (i < tags.size()) {
            Position position = TagExtensions.getPosition(tags.get(i), i, tags);
            if (position != null) {
                result.add(position);
            }
            ++i;
        }
        return result;
    }

    private static Tag findClosing(Tag tag, int tagNumber, ArrayList<Tag> tags) {
        int level = 0;
        int i = tagNumber + 1;
        while (i < tags.size()) {
            String _name_1;
            Tag other = tags.get(i);
            String _name = other.getName();
            boolean _equals = Objects.equals(_name, _name_1 = tag.getName());
            if (!(!_equals || other.isOpening() && other.isClosing())) {
                boolean _isOpening = other.isOpening();
                if (_isOpening) {
                    ++level;
                } else {
                    boolean _isClosing = other.isClosing();
                    if (_isClosing) {
                        if (level == 0) {
                            return other;
                        }
                        --level;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    private static Position getPosition(Tag tag, int tagNumber, ArrayList<Tag> tags) {
        Tag closing;
        boolean _not;
        boolean _isClosing = tag.isClosing();
        boolean bl = _not = !_isClosing;
        if (_not && (closing = TagExtensions.findClosing(tag, tagNumber, tags)) != null) {
            int _line_1;
            boolean _tripleNotEquals;
            int _line = tag.getLine();
            boolean bl2 = _tripleNotEquals = _line != (_line_1 = closing.getLine());
            if (_tripleNotEquals) {
                int _lineOffset = tag.getLineOffset();
                int _endLineOffset = closing.getEndLineOffset();
                int _lineOffset_1 = tag.getLineOffset();
                int _minus = _endLineOffset - _lineOffset_1;
                Position position = new Position(_lineOffset, _minus);
                return position;
            }
        }
        return null;
    }
}

