/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.autofill;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.set.basis.autofill.Autofill;
import org.eclipse.set.basis.autofill.FillInstruction;
import org.eclipse.set.basis.autofill.FillSetting;

public class DefaultAutofill
implements Autofill {
    private EditingDomain editingDomain;
    private final Consumer<Exception> exceptionHandler;
    private final List<FillInstruction> instructions = Lists.newLinkedList();

    public DefaultAutofill(Consumer<Exception> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void addFillingInstruction(FillInstruction instruction) {
        this.instructions.add(instruction);
        instruction.setAutofill(this);
    }

    @Override
    public void execute(FillInstruction instruction) {
        try {
            FillSetting source = instruction.getSourceSetting();
            FillSetting target = instruction.getTargetSetting();
            target.setValue(this.editingDomain, source.getValue());
        }
        catch (Exception e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.accept(e);
            }
            throw e;
        }
    }

    @Override
    public void setEditingDomain(EditingDomain editingDomain) {
        this.editingDomain = editingDomain;
    }
}

