/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.net4j.internal.util.bundle.AbstractBundle;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.collection.AbstractIterator;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class OSGiBundle
extends AbstractBundle {
    public OSGiBundle(AbstractPlatform platform, String bundleID, Class<?> accessor) {
        super(platform, bundleID, accessor);
    }

    public BundleContext getBundleContext() {
        return (BundleContext)super.getBundleContext();
    }

    @Override
    public URL getBaseURL() {
        try {
            URL entry = this.getBundleContext().getBundle().getEntry("/");
            URL baseURL = FileLocator.resolve((URL)entry);
            String str = baseURL.toExternalForm();
            if (str.endsWith("/./")) {
                baseURL = new URL(str.substring(0, str.length() - 2));
            }
            return baseURL;
        }
        catch (IOException ex) {
            throw WrappedException.wrap(ex);
        }
    }

    @Override
    public Class<?> loadClass(String pluginID, String className) throws ClassNotFoundException {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle == null) {
            throw new ClassNotFoundException(String.valueOf(className) + " cannot be loaded because because bundle " + pluginID + " cannot be resolved");
        }
        return bundle.loadClass(className);
    }

    @Override
    public Iterator<Class<?>> getClasses() {
        final LinkedList<String> folders = new LinkedList<String>();
        folders.offer("/");
        return new AbstractIterator<Class<?>>(){
            private Enumeration<String> entryPaths;

            @Override
            protected Object computeNextElement() {
                while (true) {
                    if (this.entryPaths != null && this.entryPaths.hasMoreElements()) {
                        String entryPath = this.entryPaths.nextElement();
                        if (entryPath.endsWith("/")) {
                            folders.offer(entryPath);
                            continue;
                        }
                        Class c = OSGiBundle.this.getClassFromBundle(entryPath);
                        if (c == null) continue;
                        return c;
                    }
                    String folder = (String)folders.poll();
                    if (folder == null) {
                        return END_OF_DATA;
                    }
                    Bundle bundle = OSGiBundle.this.getBundleContext().getBundle();
                    this.entryPaths = bundle.getEntryPaths(folder);
                }
            }
        };
    }

    @Override
    public String getStateLocation() {
        Bundle bundle = this.getBundleContext().getBundle();
        return Platform.getStateLocation((Bundle)bundle).toString();
    }
}

