/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.siteplan.browserfunctions;

import java.util.Optional;
import org.eclipse.set.core.services.siteplan.SiteplanService;
import org.eclipse.set.model.planpro.Basisobjekte.Ur_Objekt;
import org.eclipse.set.model.siteplan.SiteplanObject;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.model.tablemodel.extensions.TableRowExtensions;
import org.eclipse.set.utils.WebBrowser;
import org.eclipse.set.utils.events.JumpToSiteplanEvent;

public class JumpToSiteplanElementBrowserFunction {
    private static final String DESELECTED = "DESELECTED";
    private static final String JUMP_TO_ELEMENT_FUNCTION = "window.planproJumpToElement";
    private final WebBrowser webBrowser;
    private final SiteplanService siteplanService;

    public JumpToSiteplanElementBrowserFunction(SiteplanService siteplanService, WebBrowser webbrowser) {
        this.siteplanService = siteplanService;
        this.webBrowser = webbrowser;
    }

    public final void execute(String guid) {
        String jsFunction = String.format("{\n\tlet intervalId = 0\n\tconst jumpToElement = () => {\n\t\tif(%s) {\n\t\t\t%s('%s');\n\t\t\tclearInterval(intervalId);\n\t\t}\n\t}\n\tintervalId = setInterval(jumpToElement, 200);\n\n}\n", JUMP_TO_ELEMENT_FUNCTION, JUMP_TO_ELEMENT_FUNCTION, guid);
        this.webBrowser.executeJavascript(jsFunction);
    }

    public void execute(JumpToSiteplanEvent selectedRowEvent) {
        String objectGuid = this.getObjectGuid(selectedRowEvent);
        if (objectGuid != null) {
            this.execute(objectGuid);
        } else {
            this.execute(DESELECTED);
        }
    }

    private String getObjectGuid(JumpToSiteplanEvent event) {
        if (event.getRow() != null) {
            Ur_Objekt leadingObject = TableRowExtensions.getLeadingObject((TableRow)event.getRow());
            Optional relevantSiteplanElement = this.siteplanService.getSiteplanElement(leadingObject);
            if (relevantSiteplanElement.isPresent()) {
                return ((SiteplanObject)relevantSiteplanElement.get()).getGuid();
            }
            return null;
        }
        if (event.getGuid() != null && !event.getGuid().isBlank()) {
            return event.getGuid();
        }
        return null;
    }
}

