/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.utils.events;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.set.utils.events.FunctionalToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvent;
import org.eclipse.set.utils.events.ToolboxEventHandler;
import org.eclipse.set.utils.events.ToolboxEvents;

public class EventRegistration {
    private final IEventBroker broker;
    private final List<ToolboxEventHandler<?>> eventHandlers = Lists.newArrayList();

    public EventRegistration(IEventBroker broker) {
        this.broker = broker;
    }

    public <T extends ToolboxEvent> void registerHandler(Class<T> type, Consumer<T> handler) {
        FunctionalToolboxEventHandler<T> eventHandler = new FunctionalToolboxEventHandler<T>(handler);
        ToolboxEvents.subscribe(this.broker, type, eventHandler);
        this.eventHandlers.add(eventHandler);
    }

    public void unsubscribeAll() {
        this.eventHandlers.forEach(h -> ToolboxEvents.unsubscribe(this.broker, h));
    }
}

