/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.graph;

import java.util.Objects;
import org.eclipse.set.basis.graph.DirectedElement;

public class DirectedElementImpl<T>
implements DirectedElement<T> {
    private T element;
    private boolean isForwards;

    public static <S> DirectedElementImpl<S> backwards(S element) {
        return new DirectedElementImpl<S>(element, false);
    }

    public static <S> DirectedElementImpl<S> forwards(S element) {
        return new DirectedElementImpl<S>(element, true);
    }

    public DirectedElementImpl(T element, boolean isForwards) {
        this.element = element;
        this.isForwards = isForwards;
    }

    @Override
    public T getElement() {
        return this.element;
    }

    @Override
    public boolean isForwards() {
        return this.isForwards;
    }

    @Override
    public void setElement(T element) {
        this.element = element;
    }

    @Override
    public void setForwards(boolean isForwards) {
        this.isForwards = isForwards;
    }

    public String toString() {
        return String.format("%s{element=%s isForwards=%s}", super.toString(), this.element, this.isForwards);
    }

    public int hashCode() {
        return Objects.hash(this.element, this.isForwards);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DirectedElementImpl other = (DirectedElementImpl)obj;
        return Objects.equals(this.element, other.element) && this.isForwards == other.isForwards;
    }
}

