/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.basis.geometry;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.set.basis.geometry.GEOKanteMetadata;
import org.eclipse.set.basis.geometry.GeoPosition;
import org.eclipse.set.model.planpro.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.model.planpro.Geodaten.ENUMGEOKoordinatensystem;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class GEOKanteCoordinate {
    private static final double GEOMETRY_TOLERANCE = 1.0E-9;
    private final GEOKanteMetadata geoKante;
    private final GeoPosition position;
    private final ENUMGEOKoordinatensystem crs;
    private final Optional<BigDecimal> topDistance;
    private Set<Bereich_Objekt> bereichObjekt = null;

    public GEOKanteCoordinate(GeoPosition position, GEOKanteMetadata geoKante, ENUMGEOKoordinatensystem crs) {
        this.position = position;
        this.geoKante = geoKante;
        this.crs = crs;
        this.topDistance = GEOKanteCoordinate.determineTopDistance(position.getCoordinate(), geoKante);
    }

    public GEOKanteCoordinate(Coordinate coordinate, GEOKanteMetadata geoKante, ENUMGEOKoordinatensystem crs) {
        this.position = new GeoPosition(coordinate, 0.0, 0.0);
        this.geoKante = geoKante;
        this.crs = crs;
        this.topDistance = GEOKanteCoordinate.determineTopDistance(coordinate, geoKante);
    }

    public GEOKanteCoordinate(Coordinate coordinate, GEOKanteMetadata geoKante, Set<Bereich_Objekt> bereichObjekt, ENUMGEOKoordinatensystem crs) {
        this.position = new GeoPosition(coordinate, 0.0, 0.0);
        this.geoKante = geoKante;
        this.crs = crs;
        this.topDistance = GEOKanteCoordinate.determineTopDistance(coordinate, geoKante);
        this.bereichObjekt = bereichObjekt;
    }

    public GEOKanteCoordinate(Coordinate coordinate, GEOKanteMetadata geoKante, BigDecimal topDistance, ENUMGEOKoordinatensystem crs) {
        this.position = new GeoPosition(coordinate, 0.0, 0.0);
        this.geoKante = geoKante;
        this.crs = crs;
        this.topDistance = Optional.of(topDistance);
    }

    private static Optional<BigDecimal> determineTopDistance(Coordinate coordinate, GEOKanteMetadata metadata) {
        GeometryFactory geometryFactory = new GeometryFactory();
        LineString geometry = metadata.getGeometry();
        if (!geometry.isWithinDistance((Geometry)geometryFactory.createPoint(coordinate), 1.0E-9)) {
            return Optional.empty();
        }
        BigDecimal distance = metadata.getStart();
        Coordinate currentCoordinate = null;
        Coordinate[] coordinateArray = geometry.getCoordinates();
        int n = coordinateArray.length;
        int n2 = 0;
        while (n2 < n) {
            Coordinate nextCoordinate = coordinateArray[n2];
            if (currentCoordinate == null) {
                currentCoordinate = nextCoordinate;
            } else {
                double distanceToNextCoord = currentCoordinate.distance(nextCoordinate);
                double distanceToTargetCoord = currentCoordinate.distance(coordinate);
                if (GEOKanteCoordinate.isOnLine(coordinate, currentCoordinate, nextCoordinate, 1.0E-9) && distanceToNextCoord >= distanceToTargetCoord) {
                    return Optional.of(distance.add(BigDecimal.valueOf(distanceToTargetCoord)));
                }
                distance = distance.add(BigDecimal.valueOf(distanceToNextCoord));
                currentCoordinate = nextCoordinate;
            }
            ++n2;
        }
        return Optional.empty();
    }

    public static boolean isOnLine(Coordinate coordinate, Coordinate coordinateA, Coordinate coordinateB, double tolerance) {
        GeometryFactory geometryFactory = new GeometryFactory();
        LineString line = geometryFactory.createLineString(new Coordinate[]{coordinateA, coordinateB});
        Point point = geometryFactory.createPoint(coordinate);
        return line.isWithinDistance((Geometry)point, tolerance);
    }

    public Set<Bereich_Objekt> getBereichObjekte() {
        if (this.bereichObjekt != null) {
            return this.bereichObjekt;
        }
        if (this.topDistance.isEmpty()) {
            return Collections.emptySet();
        }
        this.bereichObjekt = this.geoKante.segments.stream().filter(segment -> this.topDistance.get().compareTo(segment.getStart()) >= 0 && this.topDistance.get().compareTo(segment.getEnd()) <= 0).flatMap(segment -> segment.getBereichObjekte().stream()).collect(Collectors.toSet());
        return this.bereichObjekt;
    }

    public GeoPosition getGeoPosition() {
        return this.position;
    }

    public Coordinate getCoordinate() {
        return this.position.getCoordinate();
    }

    public ENUMGEOKoordinatensystem getCRS() {
        return this.crs;
    }

    public double getEffectiveRotation() {
        return this.position.getEffectiveRotation();
    }

    public double getTopologicalRotation() {
        return this.position.getTopologicalRotation();
    }
}

